function [CAl, VFR] = Activity_39_1_bulk(given,guess)
%Activity_39_1_bulk Solve the bulk liquid mole balances in Activity 39.1 of AFCoKaRE

    % Function that evaluates the bulk mole balance equations
    function f = evalEqns(z)
        % Extract the unknowns
        CA = z(1);
        vfr = z(2);
        
        % Solve the liquid film mole balances
        [NA0, NAxL, NBxL] = Activity_39_1_film(given,CA);
        
        % Calculate quantities appearing in the bulk mole balance equations
        rate = given.k*given.Vl*CA*given.CBl;
        
        % Evaluate the bulk mole balance equations
        f = [
            NAxL*given.SV*given.Vl - rate - vfr*CA;
            NBxL*given.SV*given.Vl + vfr*given.CBl0 - rate - vfr*given.CBl;
        ];
    end % of internal function evalEqns
    
    % Solve the bulk phase mole balance equations
    z = fsolve(@evalEqns, guess);
    CAl = z(1);
    VFR = z(2);
	
end % of Activity_39_1_bulk.m