function Activity_39_1
%Activity_39_1 Code used in the solution of Activity 39.1 of AFCoKaRE

    % Known quantities and constants entered in a structure array
    given = struct;
    given.CBl0 = 2500.0; % mol/m^3
    given.T = 35.0+273.15; % K
    given.P = 5.0; % atm
    given.Vl = 250.E-6; % m^3
    given.SV = 3.0E2; % /m
    given.hA = 40.0E-3; % atm m^3/mol
    given.kL = 6.7E-2/100*60; % m/min
    given.DA = 1.7E-5/1.0E4*60; % m^2/min
    given.DB = 8.0E-6/1.0E4*60; % m^2/min
    given.k = 5.1E8/1E6; % m^3/mol/min
    given.fB = 0.99;
    given.CAi = given.P/given.hA;
    given.CBl = given.CBl0*(1-given.fB);
    given.xL = given.DA/given.kL;

    % Solve the bulk liquid mole balances
    guess = [
        given.CAi/10.; % CAl guess
        15.E-6; % VFRl guess
        ];
    [CAl, VFR] = Activity_39_1_bulk(given,guess);
    
    % Report the results
    liquidVFR_cc_per_min = VFR*1E6
    CAl_mol_per_L = CAl/1000.
    
    % Fraction of conversion occurring in the film
    [NA0, NAxL, NBxL] = Activity_39_1_film(given,CAl);
    total_B_converted = VFR*given.CBl0*given.fB;
    B_converted_in_film = -NBxL*given.Vl*given.SV;
    percent_of_conversion_in_film = 100*B_converted_in_film/total_B_converted
    Vfilm_per_Vliquid = given.SV*given.xL

end % of Activity_39_1
