% MATLAB file used in the solution of Activity 36.1 of "A First Course on
% Kinetics and Reaction Engineering."
function Activity_36_1
    % Known constants
    k = 0.7; % L/mol/min
    V = 25.; % L
    Vdot = 4.; % L/min
    CAfeed = 2.3; % mol/L
    
    % Define the functions to be integrated numerically
    agefun = @(x) 0.16*exp(-0.16*x);
    sfmfun = @(x) (1-exp(-k*x))*0.16.*exp(-0.16*x);
    
    % Check the normalization of the age function
    age_check = integral(agefun,0,Inf)
    
    % Calculate the conversion using the segregated flow model
    fA_SF = integral(sfmfun,0,Inf)
    
end % of Activity_36_1

