% MATLAB function used in the solution of Activity 28.1 of "A First Course
% on Kinetics and Reaction Engineering."
function Activity_28_1
    % Get the CSTR data
    [cstr_conv,cstr_vol,rate] = Activity_28_1_cstr;
    % Get the PFR data
    [pfr_conv,pfr_vol] = Activity_28_1_pfr;
    % Create the plot
    [hAx,hLine1,hLine2] = plotyy(cstr_conv,rate,[cstr_conv, pfr_conv],[cstr_vol, pfr_vol]);
    xlabel('Fractional Conversion')
    ylabel(hAx(1),'CSTR Rate (mol/min/L)')
    ylabel(hAx(2),'Volume (L)')
    legend('CSTR Rate','CSTR Volume','PFR Volume')
end % of Activity_28_1.m

