% MATLAB file used in the solution of Activity 22.2 of "A First Course on 
% Kinetics and Reaction Engineering."
%
function Activity_22_2
    % Known quantities and constants (cal, mol, K, min, ft2, kg, L)
    V = 4; % L
    CA0 = 2; % mol/l

    % Define variables for plotting
    tau = linspace(1,100);
    nB = zeros(100,1);
    nBmax = 0;
    tauMax = 0;
    
    % Calculate nB for each tau and find the maximum
    for i = 1:100
        z = Activity_22_2a(tau(i));
        nB(i) = z(2);
        if z(2) > nBmax
            nBmax = z(2);
            tauMax = tau(i);
        end
    end
    
    z = Activity_22_2a(tauMax);
    tau_at_max = tauMax
    VFR = V/tauMax;
    nA0 = CA0*VFR;
    fA_at_max = (nA0 - z(1))/nA0*100
    nBmax
    T_at_max = z(3) - 273.15
    Te_at_max = z(4) - 273.15
    
    % Plot the results
    figure
    plot(tau,nB)
    xlabel('Space Time (min)')
    ylabel('Net Rate of B production (mol/min)')
end % of Activity_22_2.m