% Modified version of the MATLAB template file FitNumDifSR.m from "A First
% Course on Kinetics and Reaction Engineering" used in the solution of
% Activity 16.1 of "A First Course on Kinetics and Reaction Engineering."
%
function Activity_16_1(p_guess)
% Data provided in the problem statement, in consistent units
T=600.; % K
P0A=150.; % Torr
P0B=450.; % Torr
Rgas=62.366; % Torr-L/(mol-K)
V=1; % L (basis)
x=[23.1 33.3 58.2 69.7 90.7 127.7 192.1 240.6 281.1]'; % t (h)
y_hat=[0.17 0.22 0.34 0.41 0.49 0.58 0.7 0.77 0.83]'; % fA

	% Function that evaluates the ODEs
    function dudv = odeqns(v,u)
        % Current parameter values are available in column vector p
        % Current set variable values are available in column vector x_set
        rate = p(1)*V*u(1)*u(2);
        dudv = [
            -rate
            -rate
            rate
        ];
    end % of internal function odeqns
    
    % Function that solves the model equations and calculates the model-
    % predicted responses
    function y = nlmodel(p_current,x)
        % Declare y
        y = zeros(n_data,1);
        % Make the current parameters available to the model equations
        p = p_current;
        
        for i = 1:n_data
            % Make the set variables available to the model equations
            for j = 1:n_set
                x_set(j) = x(i,j);
            end
            
            % Initial and final values
            v0 = 0;
            u0 = [
                P0A*V/Rgas/T
                P0B*V/Rgas/T
                0
            ];
            vf = x_set(1);
            
            % Solve the set of ordinary differential model equations
            [v,uu] = ode45(@odeqns,[v0 vf],u0);
% NOTE: For stiff equations replace ode45 with ode15s
            last_value = length(v);
            u = uu(last_value,:);
            
            % calculate the response, y, by evaluating 
            % f(u(1),...,u(n),x_set(1),...,x_set(n_set))
            y(i) = (u0(1)-u(1))/u0(1);
        end
    end % of internal function nlmodel

    % All the necessary internal functions are now defined

    % get the number of data points and set variables
    n_data = size(x,1);
    n_set = size(x,2);
    
    % create global variables to make parameters and set variables
    % available to the internal function that evaluates the model equations
    p = zeros(length(p_guess),1);
    x_set = zeros(size(x,2),1);

    % Perform the regression analysis and report the results
    [pf,resid,J,sigma,mse] = nlinfit(x,y_hat,@nlmodel,p_guess);
    confint = nlparci(pf,resid,'covar',sigma);
    pf_u = (confint(:,2) - confint(:,1))/2.0;
    
    % Calculate the model-predicted responses
    y = zeros(n_data,1);
    y = nlmodel(pf,x);
    
    % Display the correlation coefficient, parameters and uncertainties
    r_squared = 1.0 - (sum(resid.^2))/(sum((y_hat-mean(y_hat)).^2))
    display('Best Values for the Parameters:')
    pf
    display('95% Confidence Intervals for the Parameters:')
    pf_u

    % Generate the graphical output
    n_set = size(x,2);
    if n_set == 1
        % Model plot
        % Use many data points for the model so the curve is smooth
        xx = linspace(min(x),max(x))';
        yy = nlmodel(pf,xx);
        figure;
        plot(x,y,'r',x,y_hat,'o')
        xlabel('X')
        ylabel('Y')
        title('Model Plot')
        legend('Model','Data')
    else
        % Parity plot
        figure;
        plot(y_hat,y_hat,'r',y_hat,y,'o')
        xlabel('Measured Response')
        ylabel('Predicted Response')
        title('Parity Plot')

        % Residuals plots for each set variable
        for n = 1:n_set
            figure;
            plot(x(:,n),zeros(length(y),1),'r',x(:,n),resid,'o')
            xlabel(['x',num2str(n)])
            ylabel('Residual')
            title(['Residuals Plot vs. x',num2str(n)])
        end
    end

end % of Activity_16_1.m