% MATLAB file used in the solution of Activity 15.2 of 
% "A First Course on Kinetics and Reaction Engineering."

% Data provided in the problem statement, in consistent units
V=150; % cm^3
T=1150; % K
P=1.0; % atm
Rgas=82.06; % (atm-cm^3)/(mol-K)
VFR0=[2.26 1.23 0.73 0.51 0.29 0.17 0.09]'; % cm^3/min
yZ=[0.088 0.131 0.166 0.195 0.228 0.260 0.287]';

% Calculate the inlet and outlet molar COS flow rates and k for each data
% point
nA0 = (P/Rgas/T)*VFR0;
nA = nA0.*(1-3*yZ)./(1-yZ);
k1 = ((nA-nA0) - 3*nA0.*log(nA./nA0))*2*Rgas*T/4/V/P
k2 = (9*nA0.^2.*(1./nA - 1./nA0) + 6*nA0.*log(nA./nA0) - nA + nA0);
k2 = k2*2*Rgas^2*T^2/4/V/P^2

% Calculate the average value of k and the standard deviation
k1_avg = mean(k1)
k1_dev = std(k1)
k2_avg = mean(k2)
k2_dev = std(k2)