% MATLAB file used in the solution of Activity 14.1 of 
% "A First Course on Kinetics and Reaction Engineering."

% Data provided in the problem statement, in consistent units
V = 750.; % mL
CA0 = 1.0; % mol/L
T = 70 + 273.15; % K
t = [1
2
3
4
5
6
7
8
9
10
12
15
20]; % min
CA = [0.874
0.837
0.800
0.750
0.572
0.626
0.404
0.458
0.339
0.431
0.249
0.172
0.185]; % mol/L

% calculate nA
nA = CA*V;

% fit 2nd, 3rd, 4th and 5th order polynomials to the nA vs t data
p2 = polyfit(t,nA,2)
p3 = polyfit(t,nA,3)
p4 = polyfit(t,nA,4)
p5 = polyfit(t,nA,5)

% plot the results
tt = linspace(1,20);
f2 = polyval(p2,tt);
figure
plot(t,nA,'ob',tt,f2,'-k')
xlabel('t');
ylabel('nA');
title('Second Order Polynomial Fit');

f3 = polyval(p3,tt);
figure
plot(t,nA,'ob',tt,f3,'-k')
xlabel('t');
ylabel('nA');
title('Third Order Polynomial Fit');

f4 = polyval(p4,tt);
figure
plot(t,nA,'ob',tt,f4,'-k')
xlabel('t');
ylabel('nA');
title('Fourth Order Polynomial Fit');

f5 = polyval(p5,tt);
figure
plot(t,nA,'ob',tt,f5,'-k')
xlabel('t');
ylabel('nA');
title('Fifth Order Polynomial Fit');