% MATLAB file used in the solution of Activity 13.1 of 
% "A First Course on Kinetics and Reaction Engineering."

% Ideal gas constant
R = 8.314e-3; % kJ/mol/K

% Data provided in the problem statement, in consistent units
V = 100; % L
% Enter the data as a big matrix, then break it out
dat = [305	20	1	1	0	0	307	0.3838
305	100	1	1	0	0	306	0.1473
305	300	1	1	0	0	306	0.0599
305	600	1	1	0	0	303	0.0315
305	600	2	5	0.5	0.5	304	0.7735
305	400	2	5	0.5	0.5	305	0.8772
305	200	2	5	0.5	0.5	306	1.1115
305	50	2	5	0.5	0.5	306	1.7045
305	5	2	5	0.5	0.5	304	2.3506
315	5	5	5	0.5	0.5	314	4.7473
315	40	5	5	0.5	0.5	314	3.6643
315	80	5	5	0.5	0.5	317	3.1304
315	120	5	5	0.5	0.5	314	2.7927
315	160	5	5	0.5	0.5	316	2.5465
315	160	0.5	0.25	0	0	316	0.0247
315	140	0.5	0.25	0	0	316	0.0257
315	100	0.5	0.25	0	0	315	0.0354
315	50	0.5	0.25	0	0	314	0.0605
315	20	0.5	0.25	0	0	315	0.1078
315	5	0.5	0.25	0	0	314	0.1759
325	1000	1	1	1	1	324	1.0615
325	1000	2	1	1	1	326	1.1118
325	1000	1	2	1	1	326	1.1126
325	1000	1	1	2	1	325	2.059
325	1000	1	1	1	2	326	1.0613
325	5	2	1	0.2	0.5	327	1.1362
325	50	2	1	0.2	0.5	324	0.8449
325	200	2	1	0.2	0.5	326	0.558
325	600	2	1	0.2	0.5	324	0.3711
325	600	0.5	3	0.5	0.1	326	0.6237
325	300	0.5	3	0.5	0.1	326	0.691
325	20	0.5	3	0.5	0.1	326	0.9494
340	5	4	2	1	1	341	2.9659
340	25	4	2	1	1	340	2.8588
340	100	4	2	1	1	341	2.5767
340	200	4	2	1	1	340	2.3394
340	200	2	4	2	0	338	3.3409
340	150	2	4	2	0	341	3.4456
340	100	2	4	2	0	340	3.5761
340	75	2	4	2	0	340	3.6547
340	25	2	4	2	0	339	3.8572
340	5	2	4	2	0	342	3.9668
360	5	3	1	0.1	1	360	1.0944
360	50	3	1	0.1	1	362	1.0427
360	100	3	1	0.1	1	361	0.9946
360	200	3	1	0.1	1	360	0.9156
360	200	3	5	1	0.1	359	3.5076
360	100	3	5	1	0.1	361	3.7089
360	50	3	5	1	0.1	358	3.8373
360	25	3	5	1	0.1	360	3.9166
360	5	3	5	1	0.1	359	3.9809];
T0 = dat(:,1);
VFR = dat(:,2);
CA0 = dat(:,3);
CB0 = dat(:,4);
CY0 = dat(:,5);
CZ0 = dat(:,6);
T = dat(:,7);
CY = dat(:,8);

% Calcuate x and y
nY = VFR.*CY;
nY0 = VFR.*CY0;
nA = (VFR.*CA0) - nY + nY0;
nB = (VFR.*CB0) - nY + nY0;
CA = nA./VFR;
CB = nB./VFR;
y_hat = log((nY - nY0)/V./CA./CB);
x = 1./T;

% Fit a linear model to the x,y_hat data
FitLinmbSR;

% Calculate k0 and E and their uncertainties
E = -m*R
E_u = R*m_u
k0 = exp(b)
k0_u = b_u*exp(b)