% MATLAB file used in the solution of Activity 9.2 of "A First Course on
% Kinetics and Reaction Engineering."

% Enter the data from the table
CS = [0.100
0.086
0.080
0.075
0.070
0.063
0.056
0.048
0.047
0.041
0.036
0.030
0.025
0.021
0.015
0.010];

CI = [0.100
0.050
0.005
0.001
0.100
0.050
0.005
0.001
0.100
0.050
0.005
0.001
0.100
0.050
0.005
0.001];

rP = [0.000798
0.000838
0.000912
0.000915
0.000745
0.000819
0.000898
0.000901
0.000689
0.000771
0.000896
0.000890
0.000563
0.000664
0.000846
0.000855];

% Calculate the x and y_hat values
x1 = 1./CS;
x2 = CI./CS;
y_hat = 1./rP;

% Form the x matrix
x = [x1 x2 ones(length(x1),1)];

% Use the MATLAB script file "FitLinmbSR.m" from "A First Course on
% Kinetics and Reaction Engineering" to fit a straight line with slope and
% intercept to the data
FitLinSR

% Calculate Vmax and its 95% confidence limits
Vmax = 1/b
lambda_Vmax = b_u/b^2

% Calculate Km and its 95% confidence limits
Km = m(1)*Vmax
lambda_Km = sqrt(m_u(1)^2/b^2 + (m(1)*b_u/b^2)^2)

% Calculate KI and its 95% confidence limits
KI = m(2)*Vmax
lambda_KI = sqrt(m_u(2)^2/b^2 + (m(2)*b_u/b^2)^2)
