echo on
%{
MatLab Solution for Learning Alternative Activity 1 of Unit 3 of 
"A First Course on Kinetics and Reaction Engineering."

Enter data given in the problem statement, converting them
to a consistent set of units (here J, mol and K).
Here are the stoichiometric coefficients and the gas constant:
%}

r_gas = 8.3144
nu_co = -2
nu_co2 = 1
nu_c = 1

%{
Here are the temperature and pressure:
%}

T = 800 + 273.15
P = 1.0

%{
Here are the standard free energies of formation at 1073 K:
%}

gf_co = -182500.
gf_co2 = -395600.
gf_c = 0.

%{
To calculate K, we will need delta G, so enter equation (4.2) 
(except using free energies at 1073 K instead of 298 K) to do so
%}

delta_G = gf_co*nu_co + gf_co2*nu_co2 + gf_c*nu_c

%{
Now we can calculate the equilibrium constant using equation (4.3)
%}

K = exp(-delta_G/r_gas/T)

%{
Enter the equilibrium expression, equation (4.8):
%}

syms a_co a_co2 a_c
equil_expr = K - (a_co^nu_co)*(a_co2^nu_co2)*(a_c^nu_c)

%{
Express the thermodynamic activities in terms of the composition,
and substitute the resulting expressions into the equilibrium expression:
%}

syms y_co y_co2
equil_expr=subs(equil_expr,a_c,1.0)
equil_expr=subs(equil_expr,a_co,y_co*P/1.0)
equil_expr=subs(equil_expr,a_co2,y_co2*P/1.0)

%{
We've got one equation with two unknowns;
express the mole fractions in terms of the extent of reaction
using the mole table in the solution and substitute into the equilibrium
expression.

Note, the gas phase mole fractions are equal to the moles divided by the total GAS PHASE moles,
and in this case the total GAS PHASE moles is different from the total moles because the
graphite is a solid, not a gas.
%}

syms extent
equil_expr=subs(equil_expr,y_co2,(2+extent)/((2+extent) + (3-2*extent)))
equil_expr=subs(equil_expr,y_co,(3-2*extent)/((2+extent) + (3-2*extent)))

%{
Solve the equilibrium expression
%}

extent = double(solve(equil_expr,extent))

%{
There are two roots, calculate the moles of CO using each root.
%}

nco_root1 = 3 - 2*extent(1)
nco_root2 = 3 - 2*extent(2)

%{
The first root gives a negative number for the moles of CO. This doesn't make
physical sense, so this is not the desired root. Use the second (desired) root
to calculate the final CO to CO2 ratio.
%}

ratio = (3-2*extent(2))/(2+extent(2))

echo off
