/*
 * SingleIsoBatchReactorView.java
 */
package singleisobatchreactor;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.jdesktop.application.Action;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.FrameView;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;

/**
 * The application's main frame.
 */
public class SingleIsoBatchReactorView extends FrameView {
    // A few output formats

    DecimalFormat threeSigFigs = new DecimalFormat("0.00E00");
    DecimalFormat notScientific2 = new DecimalFormat("##0.00");
    DecimalFormat notScientific4 = new DecimalFormat("##0.0000");

    public SingleIsoBatchReactorView(SingleFrameApplication app) {
        super(app);

        initComponents();

        // set default values
        startConcA = 0.5;
        concAFormattedTextField.setValue(startConcA);
        startConcB = 0.5;
        concBFormattedTextField.setValue(startConcB);
        startConcY = 0.0;
        concYFormattedTextField.setValue(startConcY);
        startConcZ = 0.0;
        concZFormattedTextField.setValue(startConcZ);
        T = 298.15;
        tempFormattedTextField.setValue(T);
        V = 5.0;
        volFormattedTextField.setValue(V);
        ResourceMap resourceMap = getResourceMap();
        afterIcon = resourceMap.getIcon("altdiagramLabel.icon");
        beforeIcon = resourceMap.getIcon("diagramLabel.icon");
        recordButton.setEnabled(false);
    }

    @Action
    public void showAboutBox() {
        if (aboutBox == null) {
            JFrame mainFrame = SingleIsoBatchReactorApp.getApplication().getMainFrame();
            aboutBox = new SingleIsoBatchReactorAboutBox(mainFrame);
            aboutBox.setLocationRelativeTo(mainFrame);
        }
        SingleIsoBatchReactorApp.getApplication().show(aboutBox);
    }

    public class MyDataPoint {

        double et, concY;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    mainPanel = new javax.swing.JPanel();
    startValuesPanel = new javax.swing.JPanel();
    concALabel = new javax.swing.JLabel();
    concAFormattedTextField = new javax.swing.JFormattedTextField();
    concBLabel = new javax.swing.JLabel();
    concYLabel = new javax.swing.JLabel();
    concZLabel = new javax.swing.JLabel();
    concBFormattedTextField = new javax.swing.JFormattedTextField();
    concYFormattedTextField = new javax.swing.JFormattedTextField();
    concZFormattedTextField = new javax.swing.JFormattedTextField();
    jPanel1 = new javax.swing.JPanel();
    temperatureLabel = new javax.swing.JLabel();
    tempFormattedTextField = new javax.swing.JFormattedTextField();
    temperatureLabel1 = new javax.swing.JLabel();
    volFormattedTextField = new javax.swing.JFormattedTextField();
    jScrollPane1 = new javax.swing.JScrollPane();
    outputTextArea = new javax.swing.JTextArea();
    resetButton = new javax.swing.JButton();
    diagramLabel = new javax.swing.JLabel();
    startButton = new javax.swing.JButton();
    timeLabel = new javax.swing.JLabel();
    timeValueLabel = new javax.swing.JLabel();
    concLabel = new javax.swing.JLabel();
    concValueLabel = new javax.swing.JLabel();
    recordButton = new javax.swing.JButton();
    reactionLabel = new javax.swing.JLabel();
    menuBar = new javax.swing.JMenuBar();
    javax.swing.JMenu fileMenu = new javax.swing.JMenu();
    saveMenuItem = new javax.swing.JMenuItem();
    javax.swing.JMenuItem exitMenuItem = new javax.swing.JMenuItem();
    javax.swing.JMenu helpMenu = new javax.swing.JMenu();
    javax.swing.JMenuItem aboutMenuItem = new javax.swing.JMenuItem();
    userGuideMenuItem = new javax.swing.JMenuItem();
    assumptionsMenuItem = new javax.swing.JMenuItem();

    mainPanel.setName("mainPanel"); // NOI18N

    org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(singleisobatchreactor.SingleIsoBatchReactorApp.class).getContext().getResourceMap(SingleIsoBatchReactorView.class);
    startValuesPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(resourceMap.getString("startValuesPanel.border.title"))); // NOI18N
    startValuesPanel.setName("startValuesPanel"); // NOI18N

    concALabel.setText(resourceMap.getString("concALabel.text")); // NOI18N
    concALabel.setName("concALabel"); // NOI18N

    concAFormattedTextField.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#,##0.00"))));
    concAFormattedTextField.setHorizontalAlignment(javax.swing.JTextField.CENTER);
    concAFormattedTextField.setToolTipText(resourceMap.getString("concAFormattedTextField.toolTipText")); // NOI18N
    concAFormattedTextField.setName("concAFormattedTextField"); // NOI18N
    concAFormattedTextField.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
      public void propertyChange(java.beans.PropertyChangeEvent evt) {
        newStartConcA(evt);
      }
    });

    concBLabel.setText(resourceMap.getString("concBLabel.text")); // NOI18N
    concBLabel.setName("concBLabel"); // NOI18N

    concYLabel.setText(resourceMap.getString("concYLabel.text")); // NOI18N
    concYLabel.setName("concYLabel"); // NOI18N

    concZLabel.setText(resourceMap.getString("concZLabel.text")); // NOI18N
    concZLabel.setName("concZLabel"); // NOI18N

    concBFormattedTextField.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#,##0.00"))));
    concBFormattedTextField.setHorizontalAlignment(javax.swing.JTextField.CENTER);
    concBFormattedTextField.setToolTipText(resourceMap.getString("concBFormattedTextField.toolTipText")); // NOI18N
    concBFormattedTextField.setName("concBFormattedTextField"); // NOI18N
    concBFormattedTextField.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
      public void propertyChange(java.beans.PropertyChangeEvent evt) {
        newStartConcB(evt);
      }
    });

    concYFormattedTextField.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#,##0.00"))));
    concYFormattedTextField.setHorizontalAlignment(javax.swing.JTextField.CENTER);
    concYFormattedTextField.setToolTipText(resourceMap.getString("concYFormattedTextField.toolTipText")); // NOI18N
    concYFormattedTextField.setName("concYFormattedTextField"); // NOI18N
    concYFormattedTextField.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
      public void propertyChange(java.beans.PropertyChangeEvent evt) {
        newStartConcY(evt);
      }
    });

    concZFormattedTextField.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#,##0.00"))));
    concZFormattedTextField.setHorizontalAlignment(javax.swing.JTextField.CENTER);
    concZFormattedTextField.setToolTipText(resourceMap.getString("concZFormattedTextField.toolTipText")); // NOI18N
    concZFormattedTextField.setName("concZFormattedTextField"); // NOI18N
    concZFormattedTextField.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
      public void propertyChange(java.beans.PropertyChangeEvent evt) {
        newStartConcZ(evt);
      }
    });

    org.jdesktop.layout.GroupLayout startValuesPanelLayout = new org.jdesktop.layout.GroupLayout(startValuesPanel);
    startValuesPanel.setLayout(startValuesPanelLayout);
    startValuesPanelLayout.setHorizontalGroup(
      startValuesPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(startValuesPanelLayout.createSequentialGroup()
        .addContainerGap()
        .add(startValuesPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
          .add(org.jdesktop.layout.GroupLayout.TRAILING, startValuesPanelLayout.createSequentialGroup()
            .add(concALabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 74, Short.MAX_VALUE)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(concAFormattedTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 94, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
          .add(startValuesPanelLayout.createSequentialGroup()
            .add(concBLabel)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
            .add(concBFormattedTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 94, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
          .add(startValuesPanelLayout.createSequentialGroup()
            .add(concYLabel)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
            .add(concYFormattedTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 94, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
          .add(startValuesPanelLayout.createSequentialGroup()
            .add(concZLabel)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 14, Short.MAX_VALUE)
            .add(concZFormattedTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 94, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
        .addContainerGap())
    );
    startValuesPanelLayout.setVerticalGroup(
      startValuesPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(startValuesPanelLayout.createSequentialGroup()
        .add(startValuesPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(concALabel)
          .add(concAFormattedTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        .add(8, 8, 8)
        .add(startValuesPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(concBLabel)
          .add(concBFormattedTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        .add(14, 14, 14)
        .add(startValuesPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(concYLabel)
          .add(concYFormattedTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
        .add(startValuesPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(concZLabel)
          .add(concZFormattedTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
    );

    jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(resourceMap.getString("jPanel1.border.title"))); // NOI18N
    jPanel1.setName("jPanel1"); // NOI18N

    temperatureLabel.setText(resourceMap.getString("temperatureLabel.text")); // NOI18N
    temperatureLabel.setName("temperatureLabel"); // NOI18N

    tempFormattedTextField.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#,##0.00"))));
    tempFormattedTextField.setHorizontalAlignment(javax.swing.JTextField.CENTER);
    tempFormattedTextField.setToolTipText(resourceMap.getString("tempFormattedTextField.toolTipText")); // NOI18N
    tempFormattedTextField.setName("tempFormattedTextField"); // NOI18N
    tempFormattedTextField.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
      public void propertyChange(java.beans.PropertyChangeEvent evt) {
        newTemperature(evt);
      }
    });

    temperatureLabel1.setText(resourceMap.getString("temperatureLabel1.text")); // NOI18N
    temperatureLabel1.setName("temperatureLabel1"); // NOI18N

    volFormattedTextField.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#,##0.00"))));
    volFormattedTextField.setHorizontalAlignment(javax.swing.JTextField.CENTER);
    volFormattedTextField.setToolTipText(resourceMap.getString("volFormattedTextField.toolTipText")); // NOI18N
    volFormattedTextField.setName("volFormattedTextField"); // NOI18N
    volFormattedTextField.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
      public void propertyChange(java.beans.PropertyChangeEvent evt) {
        newReactorVolume(evt);
      }
    });

    org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
    jPanel1.setLayout(jPanel1Layout);
    jPanel1Layout.setHorizontalGroup(
      jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(jPanel1Layout.createSequentialGroup()
        .addContainerGap()
        .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
          .add(jPanel1Layout.createSequentialGroup()
            .add(temperatureLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 74, Short.MAX_VALUE)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(tempFormattedTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 94, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
          .add(jPanel1Layout.createSequentialGroup()
            .add(temperatureLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 74, Short.MAX_VALUE)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(volFormattedTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 94, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
        .addContainerGap())
    );
    jPanel1Layout.setVerticalGroup(
      jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(jPanel1Layout.createSequentialGroup()
        .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(temperatureLabel)
          .add(tempFormattedTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(temperatureLabel1)
          .add(volFormattedTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
    );

    jScrollPane1.setName("jScrollPane1"); // NOI18N

    outputTextArea.setColumns(20);
    outputTextArea.setRows(5);
    outputTextArea.setName("outputTextArea"); // NOI18N
    jScrollPane1.setViewportView(outputTextArea);

    javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(singleisobatchreactor.SingleIsoBatchReactorApp.class).getContext().getActionMap(SingleIsoBatchReactorView.class, this);
    resetButton.setAction(actionMap.get("reset")); // NOI18N
    resetButton.setText(resourceMap.getString("resetButton.text")); // NOI18N
    resetButton.setName("resetButton"); // NOI18N

    diagramLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    diagramLabel.setIcon(resourceMap.getIcon("diagramLabel.icon")); // NOI18N
    diagramLabel.setText(resourceMap.getString("diagramLabel.text")); // NOI18N
    diagramLabel.setName("diagramLabel"); // NOI18N

    startButton.setAction(actionMap.get("startExperiment")); // NOI18N
    startButton.setText(resourceMap.getString("startButton.text")); // NOI18N
    startButton.setName("startButton"); // NOI18N

    timeLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    timeLabel.setText(resourceMap.getString("timeLabel.text")); // NOI18N
    timeLabel.setName("timeLabel"); // NOI18N

    timeValueLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    timeValueLabel.setText(resourceMap.getString("timeValueLabel.text")); // NOI18N
    timeValueLabel.setName("timeValueLabel"); // NOI18N

    concLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    concLabel.setText(resourceMap.getString("concLabel.text")); // NOI18N
    concLabel.setName("concLabel"); // NOI18N

    concValueLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    concValueLabel.setText(resourceMap.getString("concValueLabel.text")); // NOI18N
    concValueLabel.setName("concValueLabel"); // NOI18N

    recordButton.setAction(actionMap.get("recordOutput")); // NOI18N
    recordButton.setText(resourceMap.getString("recordButton.text")); // NOI18N
    recordButton.setName("recordButton"); // NOI18N

    reactionLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    reactionLabel.setIcon(resourceMap.getIcon("reactionLabel.icon")); // NOI18N
    reactionLabel.setText(resourceMap.getString("reactionLabel.text")); // NOI18N
    reactionLabel.setName("reactionLabel"); // NOI18N

    org.jdesktop.layout.GroupLayout mainPanelLayout = new org.jdesktop.layout.GroupLayout(mainPanel);
    mainPanel.setLayout(mainPanelLayout);
    mainPanelLayout.setHorizontalGroup(
      mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(mainPanelLayout.createSequentialGroup()
        .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
          .add(mainPanelLayout.createSequentialGroup()
            .add(92, 92, 92)
            .add(resetButton))
          .add(mainPanelLayout.createSequentialGroup()
            .addContainerGap()
            .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
              .add(org.jdesktop.layout.GroupLayout.LEADING, jScrollPane1)
              .add(org.jdesktop.layout.GroupLayout.LEADING, mainPanelLayout.createSequentialGroup()
                .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                  .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                  .add(startValuesPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .add(18, 18, 18)
                .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                  .add(reactionLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                  .add(diagramLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 254, Short.MAX_VALUE))
                .add(18, 18, 18)
                .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                  .add(startButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                  .add(recordButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                  .add(timeLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                  .add(timeValueLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                  .add(concLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                  .add(concValueLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))))
        .add(53, 53, 53))
    );
    mainPanelLayout.setVerticalGroup(
      mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(mainPanelLayout.createSequentialGroup()
        .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
          .add(mainPanelLayout.createSequentialGroup()
            .addContainerGap()
            .add(startValuesPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
            .add(18, 18, 18)
            .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
            .add(18, 18, 18)
            .add(resetButton))
          .add(mainPanelLayout.createSequentialGroup()
            .add(28, 28, 28)
            .add(reactionLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 49, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(diagramLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 216, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
          .add(mainPanelLayout.createSequentialGroup()
            .add(49, 49, 49)
            .add(startButton)
            .add(34, 34, 34)
            .add(timeLabel)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(timeValueLabel)
            .add(34, 34, 34)
            .add(concLabel)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(concValueLabel)
            .add(32, 32, 32)
            .add(recordButton)))
        .add(23, 23, 23)
        .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 168, Short.MAX_VALUE)
        .add(18, 18, 18))
    );

    menuBar.setName("menuBar"); // NOI18N

    fileMenu.setText(resourceMap.getString("fileMenu.text")); // NOI18N
    fileMenu.setName("fileMenu"); // NOI18N

    saveMenuItem.setAction(actionMap.get("saveData")); // NOI18N
    saveMenuItem.setText(resourceMap.getString("saveMenuItem.text")); // NOI18N
    saveMenuItem.setName("saveMenuItem"); // NOI18N
    fileMenu.add(saveMenuItem);

    exitMenuItem.setAction(actionMap.get("quit")); // NOI18N
    exitMenuItem.setName("exitMenuItem"); // NOI18N
    fileMenu.add(exitMenuItem);

    menuBar.add(fileMenu);

    helpMenu.setText(resourceMap.getString("helpMenu.text")); // NOI18N
    helpMenu.setName("helpMenu"); // NOI18N

    aboutMenuItem.setAction(actionMap.get("showAboutBox")); // NOI18N
    aboutMenuItem.setName("aboutMenuItem"); // NOI18N
    helpMenu.add(aboutMenuItem);

    userGuideMenuItem.setAction(actionMap.get("showUserGuide")); // NOI18N
    userGuideMenuItem.setText(resourceMap.getString("userGuideMenuItem.text")); // NOI18N
    userGuideMenuItem.setName("userGuideMenuItem"); // NOI18N
    helpMenu.add(userGuideMenuItem);

    assumptionsMenuItem.setAction(actionMap.get("showAssumptions")); // NOI18N
    assumptionsMenuItem.setText(resourceMap.getString("assumptionsMenuItem.text")); // NOI18N
    assumptionsMenuItem.setToolTipText(resourceMap.getString("assumptionsMenuItem.toolTipText")); // NOI18N
    assumptionsMenuItem.setName("assumptionsMenuItem"); // NOI18N
    helpMenu.add(assumptionsMenuItem);

    menuBar.add(helpMenu);

    setComponent(mainPanel);
    setMenuBar(menuBar);
  }// </editor-fold>//GEN-END:initComponents

    private void newStartConcA(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_newStartConcA
        // see whether the value has really changed
        double newConc = ((Number) concAFormattedTextField.getValue()).doubleValue();
        if (newConc != startConcA) {
            // the value has changed ; make sure it is in range
            if (newConc < 0.01) {
                startConcA = 0.01;
            } else if (newConc > 5.) {
                startConcA = 5.0;
            } else {
                startConcA = newConc;
            }
            concAFormattedTextField.setValue(new Double(startConcA));
        }
    }//GEN-LAST:event_newStartConcA

    private void newStartConcB(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_newStartConcB
        // see whether the value has really changed
        double newConc = ((Number) concBFormattedTextField.getValue()).doubleValue();
        if (newConc != startConcB) {
            // the value has changed ; make sure it is in range
            if (newConc < 0.01) {
                startConcB = 0.01;
            } else if (newConc > 5.) {
                startConcB = 5.0;
            } else {
                startConcB = newConc;
            }
            concBFormattedTextField.setValue(new Double(startConcB));
        }
    }//GEN-LAST:event_newStartConcB

    private void newStartConcY(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_newStartConcY
        // see whether the value has really changed
        double newConc = ((Number) concYFormattedTextField.getValue()).doubleValue();
        if (newConc != startConcY) {
            // the value has changed ; make sure it is in range
            if (newConc < 0.0) {
                startConcY = 0.0;
            } else if (newConc > 5.) {
                startConcY = 5.0;
            } else {
                startConcY = newConc;
            }
            concYFormattedTextField.setValue(new Double(startConcY));
        }
    }//GEN-LAST:event_newStartConcY

    private void newStartConcZ(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_newStartConcZ
        // see whether the value has really changed
        double newConc = ((Number) concZFormattedTextField.getValue()).doubleValue();
        if (newConc != startConcZ) {
            // the value has changed ; make sure it is in range
            if (newConc < 0.0) {
                startConcZ = 0.0;
            } else if (newConc > 5.) {
                startConcZ = 5.0;
            } else {
                startConcZ = newConc;
            }
            concZFormattedTextField.setValue(new Double(startConcZ));
        }
    }//GEN-LAST:event_newStartConcZ

    private void newTemperature(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_newTemperature
        // see whether the value has really changed
        double newTemp = ((Number) tempFormattedTextField.getValue()).doubleValue();
        if (newTemp != T) {
            // the value has changed ; make sure it is in range
            if (newTemp < 270.0) {
                T = 270.0;
            } else if (newTemp > 360.0) {
                T = 360.0;
            } else {
                T = newTemp;
            }
            tempFormattedTextField.setValue(new Double(T));
        }
    }//GEN-LAST:event_newTemperature

    private void newReactorVolume(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_newReactorVolume
        // see whether the value has really changed
        double newVol = ((Number) volFormattedTextField.getValue()).doubleValue();
        if (newVol != V) {
            // the value has changed ; make sure it is in range
            if (newVol < 0.01) {
                V = 0.01;
            } else if (newVol > 1000.0) {
                V = 1000.0;
            } else {
                V = newVol;
            }
            volFormattedTextField.setValue(new Double(V));
        }
    }
    StartExperimentTask exptTask;

    @Action(block = Task.BlockingScope.COMPONENT)
    public Task startExperiment() {
        return exptTask = new StartExperimentTask(getApplication());
    }//GEN-LAST:event_newReactorVolume

    private class StartExperimentTask extends org.jdesktop.application.Task<Object, MyDataPoint> {

        double cA0, cB0, cY0, cZ0, temperature, volume, k, cMax;
        MyDataPoint point;

        StartExperimentTask(org.jdesktop.application.Application app) {
            // Runs on the EDT.  Copy GUI state that
            // doInBackground() depends on from parameters
            // to StartExperimentTask fields, here.
            super(app);
            // disable the starting concentration and reactor properties text fields
            concAFormattedTextField.setEnabled(false);
            concBFormattedTextField.setEnabled(false);
            concYFormattedTextField.setEnabled(false);
            concZFormattedTextField.setEnabled(false);
            tempFormattedTextField.setEnabled(false);
            volFormattedTextField.setEnabled(false);
            recordButton.setEnabled(true);
            // get starting concentrations, T and V
            cA0 = ((Number) concAFormattedTextField.getValue()).doubleValue();
            cMax = cA0;
            cB0 = ((Number) concBFormattedTextField.getValue()).doubleValue();
            if (cB0 > cMax) {
                cMax = cB0;
            }
            cY0 = ((Number) concYFormattedTextField.getValue()).doubleValue();
            if (cY0 > cMax) {
                cMax = cY0;
            }
            cZ0 = ((Number) concZFormattedTextField.getValue()).doubleValue();
            if (cZ0 > cMax) {
                cMax = cZ0;
            }
            temperature = ((Number) tempFormattedTextField.getValue()).doubleValue();
            volume = ((Number) volFormattedTextField.getValue()).doubleValue();
            k = 7.32e7*Math.exp(-50000.0/8.3144/temperature);
            // change the diagram
            diagramLabel.setIcon(afterIcon);
            // write the initial output
            String txt = "Isothermal Batch Reactor Kinetics Data";
            txt += "\nReaction: A + B --> Y + Z";
            txt += "\nReactor volume: " + notScientific2.format(volume) + " L";
            txt += "\nTemperature: " + notScientific2.format(temperature) + " K";
            txt += "\nStarting concentration of A: " + notScientific4.format(cA0) + " M";
            txt += "\nStarting concentration of B: " + notScientific4.format(cB0) + " M";
            txt += "\nStarting concentration of Y: " + notScientific4.format(cY0) + " M";
            txt += "\nStarting concentration of Z: " + notScientific4.format(cZ0) + " M";
            txt += "\nElapsed time (min)\tMolar Concentration of Y";
            txt += "\n" + notScientific2.format(0.00) + "\t" + notScientific4.format(cY0);
            outputTextArea.setText(txt);
        }

        @Override
        protected Object doInBackground() {
            // Runs on a background thread, so don't reference
            // the Swing GUI from here.

            // declare and initialize variables
            point = new MyDataPoint();
            long t0 = System.currentTimeMillis();

            // start an infinite loop
            while (true) {
                // calculate the elapsed time and the concentration of Y
                point.et = ((double) (System.currentTimeMillis() - t0)) / 1000.0/60;
                if (cA0 == cB0) {
                    point.concY = cY0 + cA0*(k*cA0*point.et)/(1.0+k*cA0*point.et);
                } else {
                    double gamma = Math.exp((cB0-cA0)*k*point.et);
                    point.concY = cY0 + cA0 - (cB0 - cA0)/(cB0*gamma/cA0 -1.0);
                }
                // add in some experimental noise
                point.concY += ((Math.random()*2.0)-1.0)*0.005*cMax;
                publish(point);
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException ex) {
                    return null;
                }

            }
        }

        @Override
        protected void process(List<MyDataPoint> pointList) {
            // only use the last point in the list if there is more than one
            MyDataPoint thePoint = pointList.get(pointList.size() - 1);
            // update the time value label
            timeValueLabel.setText(notScientific2.format(thePoint.et));
            concValueLabel.setText(notScientific4.format(thePoint.concY));
        }

        @Override
        protected void succeeded(Object result) {
            // Runs on the EDT.  Update the GUI based on
            // the result computed by doInBackground().
        }
    }

    @Action
    public void recordOutput() {
        // Append the current data point to the output data
        String dataPoint = "\n" + timeValueLabel.getText() + "\t" + concValueLabel.getText();
        outputTextArea.append(dataPoint);
    }

    @Action
    public void reset() {
        JFrame mainFrame = SingleIsoBatchReactorApp.getApplication().getMainFrame();
        int n = JOptionPane.showConfirmDialog(
                mainFrame, "This will erase the data window, continue?",
                "Reset Warning", JOptionPane.WARNING_MESSAGE,
                JOptionPane.YES_NO_OPTION);
        if (n == JOptionPane.YES_OPTION) {
            // Stop generating data
            exptTask.cancel(true);
            // Re-zero the time and concentration of Y
            timeValueLabel.setText("0.00");
            concValueLabel.setText("0.00");
            // Clear the output area
            outputTextArea.setText("");
            // Enable the starting concentration and reactor properties text fields
            concAFormattedTextField.setEnabled(true);
            concBFormattedTextField.setEnabled(true);
            concYFormattedTextField.setEnabled(true);
            concZFormattedTextField.setEnabled(true);
            tempFormattedTextField.setEnabled(true);
            volFormattedTextField.setEnabled(true);
            // Change the diagram
            diagramLabel.setIcon(beforeIcon);
            // disable the record data point button
            recordButton.setEnabled(false);
        } else if (n == JOptionPane.NO_OPTION) {
            return;
        } else {
            return;
        }
    }

    @Action
    public void saveData() throws IOException {
        // Open a file chooser
        JFrame mainFrame = SingleIsoBatchReactorApp.getApplication().getMainFrame();
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showSaveDialog(mainFrame);
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            // the user selected a file
            File dataFile = fc.getSelectedFile();
            // open the file
            FileWriter outputStream = new FileWriter(dataFile);
            // write the data in the outputTextArea to the file
            outputTextArea.write(outputStream);
            // close the file
            outputStream.close();
        } else {
            // the user canceled
            return;
        }

    }

    @Action
    public void showUserGuide() {
        if (userGuide == null) {
            JFrame mainFrame = SingleIsoBatchReactorApp.getApplication().getMainFrame();
            userGuide = new SingleIsoBatchReactorUserGuide(mainFrame);
            userGuide.setLocationRelativeTo(mainFrame);
        }
        SingleIsoBatchReactorApp.getApplication().show(userGuide);
    }

    @Action
    public void showAssumptions() {
        if (assumptions == null) {
            JFrame mainFrame = SingleIsoBatchReactorApp.getApplication().getMainFrame();
            assumptions = new SingleIsoBatchReactorAssumptions(mainFrame);
            assumptions.setLocationRelativeTo(mainFrame);
        }
        SingleIsoBatchReactorApp.getApplication().show(assumptions);

    }
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JMenuItem assumptionsMenuItem;
  private javax.swing.JFormattedTextField concAFormattedTextField;
  private javax.swing.JLabel concALabel;
  private javax.swing.JFormattedTextField concBFormattedTextField;
  private javax.swing.JLabel concBLabel;
  private javax.swing.JLabel concLabel;
  private javax.swing.JLabel concValueLabel;
  private javax.swing.JFormattedTextField concYFormattedTextField;
  private javax.swing.JLabel concYLabel;
  private javax.swing.JFormattedTextField concZFormattedTextField;
  private javax.swing.JLabel concZLabel;
  private javax.swing.JLabel diagramLabel;
  private javax.swing.JPanel jPanel1;
  private javax.swing.JScrollPane jScrollPane1;
  private javax.swing.JPanel mainPanel;
  private javax.swing.JMenuBar menuBar;
  private javax.swing.JTextArea outputTextArea;
  private javax.swing.JLabel reactionLabel;
  private javax.swing.JButton recordButton;
  private javax.swing.JButton resetButton;
  private javax.swing.JMenuItem saveMenuItem;
  private javax.swing.JButton startButton;
  private javax.swing.JPanel startValuesPanel;
  private javax.swing.JFormattedTextField tempFormattedTextField;
  private javax.swing.JLabel temperatureLabel;
  private javax.swing.JLabel temperatureLabel1;
  private javax.swing.JLabel timeLabel;
  private javax.swing.JLabel timeValueLabel;
  private javax.swing.JMenuItem userGuideMenuItem;
  private javax.swing.JFormattedTextField volFormattedTextField;
  // End of variables declaration//GEN-END:variables
    private JDialog aboutBox,  userGuide, assumptions;
    private double startConcA,  startConcB,  startConcY,  startConcZ,  T,  V;
    private Icon beforeIcon,  afterIcon;
}
