/*
 * Decompiled with CFR 0.152.
 */
package numeth;

import numeth.NMResult;
import numeth.NMSimplexFcn;
import numeth.NMSimplexListener;

public class NMSimplexOptimizer
implements NMSimplexListener {
    private NMSimplexFcn fcn;
    private int nParams;
    private boolean hasBounds = false;
    private boolean[] hasUpperBound;
    private boolean[] hasLowerBound;
    private double tol;
    private double[] upperBound;
    private double[] lowerBound;
    private double[][] vertex;
    private NMSimplexListener theListener;

    public NMResult minimize(int maxIts, double[] guess) {
        String[] eMsg = new String[]{" ", "NMSimplexOptimizer.minimize: too few vertices ", "NMSimplexOptimizer.minimize: error while adjusting simplex", "NMSimplexOptimizer.minimize: error evaluating objective function", "NMSimplexOptimizer.minimize: did not converge to within specified tolerance"};
        NMResult theResult = new NMResult();
        double bestSoFar = 1.0E99;
        int lowVert = 0;
        int highVert = 0;
        for (int i = 0; i < this.nParams + 1; ++i) {
            this.vertex[this.nParams][i] = guess[i];
        }
        NMResult checkResult = this.checkVertices();
        if (theResult.getStatus() > 0) {
            theResult.setStatus(1, eMsg[1], checkResult);
            return theResult;
        }
        for (int iter = 0; iter < maxIts; ++iter) {
            int j;
            int i;
            NMResult consResult;
            int i2;
            int i3;
            int i4;
            double lowVal;
            double highVal = lowVal = this.vertex[0][this.nParams];
            lowVert = 0;
            highVert = 0;
            for (int i5 = 1; i5 < this.nParams + 1; ++i5) {
                if (this.vertex[i5][this.nParams] > highVal) {
                    highVal = this.vertex[i5][this.nParams];
                    highVert = i5;
                }
                if (!(this.vertex[i5][this.nParams] < lowVal)) continue;
                lowVal = this.vertex[i5][this.nParams];
                lowVert = i5;
            }
            double nHighVal = lowVal;
            for (i4 = 0; i4 < this.nParams + 1; ++i4) {
                if (i4 == highVert || !(this.vertex[i4][this.nParams] > nHighVal)) continue;
                nHighVal = this.vertex[i4][this.nParams];
            }
            this.theListener.call(iter, this.vertex[lowVert][this.nParams]);
            for (i4 = 0; i4 < this.nParams + 1; ++i4) {
                guess[i4] = this.vertex[lowVert][i4];
            }
            double rtol = 2.0 * Math.abs(this.vertex[highVert][this.nParams] - this.vertex[lowVert][this.nParams]);
            if ((rtol /= Math.abs(this.vertex[highVert][this.nParams] + this.vertex[lowVert][this.nParams])) < this.tol) {
                for (int i6 = 0; i6 < this.nParams + 1; ++i6) {
                    guess[i6] = this.vertex[lowVert][i6];
                }
                return theResult;
            }
            double[] center = new double[this.nParams];
            for (i3 = 0; i3 < this.nParams; ++i3) {
                center[i3] = 0.0;
            }
            for (int j2 = 0; j2 < this.nParams; ++j2) {
                for (i2 = 0; i2 < this.nParams + 1; ++i2) {
                    if (i2 == highVert) continue;
                    int n = j2;
                    center[n] = center[n] + this.vertex[i2][j2];
                }
            }
            for (i3 = 0; i3 < this.nParams; ++i3) {
                center[i3] = center[i3] / (double)this.nParams;
            }
            double[] test1 = new double[this.nParams + 1];
            for (i2 = 0; i2 < this.nParams; ++i2) {
                test1[i2] = 2.0 * center[i2] - this.vertex[highVert][i2];
            }
            if (this.hasBounds && (consResult = this.constrain(this.vertex[highVert], test1)).getStatus() != 0) {
                theResult.setStatus(2, eMsg[2], consResult);
                return theResult;
            }
            NMResult evalResult = this.fcn.evalSimplexFcn(test1);
            if (evalResult.getStatus() > 0) {
                theResult.setStatus(3, eMsg[3], evalResult);
                return theResult;
            }
            if (lowVal <= test1[this.nParams] && test1[this.nParams] < nHighVal) {
                for (int i7 = 0; i7 < this.nParams + 1; ++i7) {
                    this.vertex[highVert][i7] = test1[i7];
                }
                continue;
            }
            if (test1[this.nParams] < lowVal) {
                double[] test2 = new double[this.nParams + 1];
                for (i = 0; i < this.nParams; ++i) {
                    test2[i] = 3.0 * center[i] - 2.0 * this.vertex[highVert][i];
                }
                if (this.hasBounds && (consResult = this.constrain(this.vertex[highVert], test2)).getStatus() != 0) {
                    theResult.setStatus(2, eMsg[2], consResult);
                    return theResult;
                }
                evalResult = this.fcn.evalSimplexFcn(test2);
                if (evalResult.getStatus() > 0) {
                    theResult.setStatus(3, eMsg[3], evalResult);
                    return theResult;
                }
                if (test2[this.nParams] < test1[this.nParams]) {
                    for (i = 0; i < this.nParams + 1; ++i) {
                        this.vertex[highVert][i] = test2[i];
                    }
                    continue;
                }
                for (i = 0; i < this.nParams + 1; ++i) {
                    this.vertex[highVert][i] = test1[i];
                }
                continue;
            }
            if (test1[this.nParams] < highVal) {
                double[] test2 = new double[this.nParams + 1];
                for (i = 0; i < this.nParams; ++i) {
                    test2[i] = 1.5 * center[i] - 0.5 * this.vertex[highVert][i];
                }
                if (this.hasBounds && (consResult = this.constrain(this.vertex[highVert], test2)).getStatus() != 0) {
                    theResult.setStatus(2, eMsg[2], consResult);
                    return theResult;
                }
                evalResult = this.fcn.evalSimplexFcn(test2);
                if (evalResult.getStatus() > 0) {
                    theResult.setStatus(3, eMsg[3], evalResult);
                    return theResult;
                }
                if (test2[this.nParams] <= test1[this.nParams]) {
                    for (i = 0; i < this.nParams + 1; ++i) {
                        this.vertex[highVert][i] = test2[i];
                    }
                    continue;
                }
                for (i = 0; i < this.nParams + 1; ++i) {
                    if (i == lowVert) continue;
                    for (j = 0; j < this.nParams; ++j) {
                        test2[j] = 0.5 * this.vertex[i][j] + 0.5 * this.vertex[lowVert][j];
                    }
                    evalResult = this.fcn.evalSimplexFcn(test1);
                    if (evalResult.getStatus() > 0) {
                        theResult.setStatus(3, eMsg[3], evalResult);
                        return theResult;
                    }
                    for (j = 0; j < this.nParams + 1; ++j) {
                        this.vertex[i][j] = test2[j];
                    }
                }
                continue;
            }
            if (!(test1[this.nParams] > highVal)) continue;
            double[] test2 = new double[this.nParams + 1];
            for (i = 0; i < this.nParams; ++i) {
                test2[i] = 0.5 * center[i] + 0.5 * this.vertex[highVert][i];
            }
            if (this.hasBounds && (consResult = this.constrain(this.vertex[highVert], test2)).getStatus() != 0) {
                theResult.setStatus(2, eMsg[2], consResult);
                return theResult;
            }
            evalResult = this.fcn.evalSimplexFcn(test2);
            if (evalResult.getStatus() > 0) {
                theResult.setStatus(3, eMsg[3], evalResult);
                return theResult;
            }
            if (test2[this.nParams] <= highVal) {
                for (i = 0; i < this.nParams + 1; ++i) {
                    this.vertex[highVert][i] = test2[i];
                }
                continue;
            }
            for (i = 0; i < this.nParams + 1; ++i) {
                if (i == lowVert) continue;
                for (j = 0; j < this.nParams; ++j) {
                    test2[j] = 0.5 * this.vertex[i][j] + 0.5 * this.vertex[lowVert][j];
                }
                evalResult = this.fcn.evalSimplexFcn(test1);
                if (evalResult.getStatus() > 0) {
                    theResult.setStatus(3, eMsg[3], evalResult);
                    return theResult;
                }
                for (j = 0; j < this.nParams + 1; ++j) {
                    this.vertex[i][j] = test2[j];
                }
            }
        }
        for (int i = 0; i < this.nParams + 1; ++i) {
            guess[i] = this.vertex[lowVert][i];
        }
        theResult.setStatus(4, eMsg[4]);
        return theResult;
    }

    public NMResult addVertex(int iParam, double[] fromVertex, double[] newVertex, double fraction) {
        String[] eMsg = new String[]{"", "NMSimplexOptimizer.addVertex: supplied vertex length not correct", "NMSimplexOptimizer.addVertex: new vertex length not correct", "NMSimplexOptimizer.addVertex: unable to apply constraints", "NMSimplexOptimizer.addVertex: failed to find appropriate perturbation"};
        NMResult theResult = new NMResult();
        if (fromVertex.length != this.nParams + 1) {
            theResult.setStatus(1, eMsg[1]);
            return theResult;
        }
        if (newVertex.length != this.nParams + 1) {
            theResult.setStatus(2, eMsg[2]);
            return theResult;
        }
        for (int i = 0; i < this.nParams; ++i) {
            newVertex[i] = fromVertex[i];
            this.vertex[iParam][i] = fromVertex[i];
        }
        double perturbation = newVertex[iParam] == 0.0 ? fraction : fraction * newVertex[iParam];
        boolean isGoodVertex = false;
        int pertCount = 0;
        while (!isGoodVertex) {
            NMResult consResult;
            NMResult consResult2;
            int n = iParam;
            newVertex[n] = newVertex[n] + perturbation;
            if (this.hasBounds && (consResult2 = this.constrain(fromVertex, newVertex)).getStatus() != 0) {
                theResult.setStatus(3, eMsg[3], consResult2);
                return theResult;
            }
            NMResult fcnResult = this.fcn.evalSimplexFcn(newVertex);
            if (fcnResult.getStatus() == 0) {
                isGoodVertex = true;
                continue;
            }
            int n2 = iParam;
            newVertex[n2] = newVertex[n2] - 2.0 * perturbation;
            if (this.hasBounds && (consResult = this.constrain(fromVertex, newVertex)).getStatus() != 0) {
                theResult.setStatus(3, eMsg[3], consResult);
                return theResult;
            }
            fcnResult = this.fcn.evalSimplexFcn(newVertex);
            if (fcnResult.getStatus() == 0) {
                isGoodVertex = true;
                continue;
            }
            int n3 = iParam;
            newVertex[n3] = newVertex[n3] + perturbation;
            perturbation *= 0.1;
            if (pertCount++ < 10) continue;
            theResult.setStatus(4, eMsg[4]);
            return theResult;
        }
        for (int j = 0; j < this.nParams + 1; ++j) {
            this.vertex[iParam][j] = newVertex[j];
        }
        return theResult;
    }

    public NMResult constrain(double[] oldParam, double[] newParam) {
        NMResult theResult = new NMResult();
        for (int i = 0; i < this.nParams; ++i) {
            if (this.hasUpperBound[i] && newParam[i] > this.upperBound[i]) {
                newParam[i] = oldParam == null ? this.upperBound[i] : oldParam[i] + 0.9 * (this.upperBound[i] - oldParam[i]);
            }
            if (!this.hasLowerBound[i] || !(newParam[i] < this.lowerBound[i])) continue;
            newParam[i] = oldParam == null ? this.lowerBound[i] : oldParam[i] - 0.9 * (this.lowerBound[i] - oldParam[i]);
        }
        return theResult;
    }

    public NMResult checkVertices() {
        String[] eMsg = new String[]{"", "NMSimplexOptimizer.checkVertices: vertex value is zero or missing"};
        NMResult theResult = new NMResult();
        for (int i = 0; i < this.nParams + 1; ++i) {
            if (this.vertex[i][this.nParams] != 0.0) continue;
            theResult.setStatus(1, eMsg[1]);
            return theResult;
        }
        return theResult;
    }

    public void registerListener(NMSimplexListener listener) {
        this.theListener = listener;
    }

    public void unregisterListener() {
        this.theListener = this;
    }

    public void call(int iteration, double sumOfSquares) {
    }

    public void setTol(double tol) {
        this.tol = tol;
    }

    public void clearBounds() {
        if (this.hasBounds) {
            this.hasBounds = false;
            this.hasUpperBound = new boolean[this.nParams];
            this.hasLowerBound = new boolean[this.nParams];
            this.upperBound = new double[this.nParams];
            this.lowerBound = new double[this.nParams];
            for (int i = 0; i < this.nParams; ++i) {
                this.hasUpperBound[i] = false;
                this.hasLowerBound[i] = false;
            }
        }
    }

    public void setBounds(boolean[] hasUpperBound, boolean[] hasLowerBound, double[] upperBound, double[] lowerBound) {
        this.hasBounds = true;
        for (int i = 0; i < this.nParams; ++i) {
            if (hasUpperBound[i]) {
                this.hasUpperBound[i] = hasUpperBound[i];
                this.upperBound[i] = upperBound[i];
            }
            if (!hasLowerBound[i]) continue;
            this.hasLowerBound[i] = hasLowerBound[i];
            this.lowerBound[i] = lowerBound[i];
        }
    }

    public NMSimplexOptimizer(int n, NMSimplexFcn nmfcn) {
        this.setTol(1.0E-4);
        this.theListener = this;
        this.nParams = n;
        this.fcn = nmfcn;
        this.hasUpperBound = new boolean[this.nParams];
        this.hasLowerBound = new boolean[this.nParams];
        this.upperBound = new double[this.nParams];
        this.lowerBound = new double[this.nParams];
        this.vertex = new double[this.nParams + 1][this.nParams + 1];
        for (int i = 0; i < this.nParams; ++i) {
            this.vertex[i][this.nParams] = 0.0;
            this.hasUpperBound[i] = false;
            this.hasLowerBound[i] = false;
        }
    }
}

