/*
 * Decompiled with CFR 0.152.
 */
package numeth;

import numeth.NMBracketerEqn;
import numeth.NMResult;

public class NMBracketer {
    private NMBracketerEqn theEqn;
    private double factor;
    private int maxExpansions;

    public NMResult oneSidedBracket(double[] endpoint) {
        String[] eMsg = new String[]{"", "NMBracketer.bracket: more than two endpoints provided", "NMBracketer.bracket: endpoints are equal", "NMBracketer.bracket: error evaluating the equation", "NMBracketer.bracket: performed maximum number of expansions without bracketing solution"};
        NMResult theResult = new NMResult();
        if (endpoint.length != 2) {
            theResult.setStatus(1, eMsg[1]);
            return theResult;
        }
        if (endpoint[0] == endpoint[1]) {
            theResult.setStatus(2, eMsg[2]);
            return theResult;
        }
        NMResult f1Result = this.theEqn.evalBracketerEqn(endpoint[0]);
        if (f1Result.getStatus() != 0) {
            theResult.setStatus(3, eMsg[3], f1Result);
            return theResult;
        }
        double f1 = f1Result.getDoubleValue();
        NMResult f2Result = this.theEqn.evalBracketerEqn(endpoint[1]);
        if (f2Result.getStatus() != 0) {
            theResult.setStatus(3, eMsg[3], f2Result);
            return theResult;
        }
        double f2 = f2Result.getDoubleValue();
        for (int j = 0; j < this.maxExpansions; ++j) {
            if (f1 * f2 < 0.0) {
                return theResult;
            }
            endpoint[1] = endpoint[1] + this.factor * (endpoint[1] - endpoint[0]);
            f2Result = this.theEqn.evalBracketerEqn(endpoint[1]);
            if (f2Result.getStatus() != 0) {
                theResult.setStatus(3, eMsg[3], f2Result);
                return theResult;
            }
            f2 = f2Result.getDoubleValue();
        }
        theResult.setStatus(4, eMsg[4]);
        return theResult;
    }

    public NMResult bracket(double[] endpoint) {
        String[] eMsg = new String[]{"", "NMBracketer.bracket: more than two endpoints provided", "NMBracketer.bracket: endpoints are equal", "NMBracketer.bracket: error evaluating the equation", "NMBracketer.bracket: performed maximum number of expansions without bracketing solution"};
        NMResult theResult = new NMResult();
        if (endpoint.length != 2) {
            theResult.setStatus(1, eMsg[1]);
            return theResult;
        }
        if (endpoint[0] == endpoint[1]) {
            theResult.setStatus(2, eMsg[2]);
            return theResult;
        }
        NMResult f1Result = this.theEqn.evalBracketerEqn(endpoint[0]);
        if (f1Result.getStatus() != 0) {
            theResult.setStatus(3, eMsg[3], f1Result);
            return theResult;
        }
        double f1 = f1Result.getDoubleValue();
        NMResult f2Result = this.theEqn.evalBracketerEqn(endpoint[1]);
        if (f2Result.getStatus() != 0) {
            theResult.setStatus(3, eMsg[3], f2Result);
            return theResult;
        }
        double f2 = f2Result.getDoubleValue();
        for (int j = 0; j < this.maxExpansions; ++j) {
            if (f1 * f2 < 0.0) {
                return theResult;
            }
            if (Math.abs(f1) < Math.abs(f2)) {
                endpoint[0] = endpoint[0] + this.factor * (endpoint[0] - endpoint[1]);
                f1Result = this.theEqn.evalBracketerEqn(endpoint[0]);
                if (f1Result.getStatus() != 0) {
                    theResult.setStatus(3, eMsg[3], f1Result);
                    return theResult;
                }
                f1 = f1Result.getDoubleValue();
                continue;
            }
            endpoint[1] = endpoint[1] + this.factor * (endpoint[1] - endpoint[0]);
            f2Result = this.theEqn.evalBracketerEqn(endpoint[1]);
            if (f2Result.getStatus() != 0) {
                theResult.setStatus(3, eMsg[3], f2Result);
                return theResult;
            }
            f2 = f2Result.getDoubleValue();
        }
        theResult.setStatus(4, eMsg[4]);
        return theResult;
    }

    public NMBracketer(NMBracketerEqn eqn) {
        this.theEqn = eqn;
        this.factor = 1.6;
        this.maxExpansions = 50;
    }

    public void setFactor(double factor) {
        this.factor = factor;
    }

    public void setMaxExpansions(int maxExpansions) {
        this.maxExpansions = maxExpansions;
    }
}

