/*
 * Decompiled with CFR 0.152.
 */
package rwgsequilibrator;

import chem.Shomate;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import numeth.NMJacEstEqns;
import numeth.NMJacEstimator;
import numeth.NMNewtRaphEqns;
import numeth.NMNewtRaphSolver;
import numeth.NMResult;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.layout.GroupLayout;
import rwgsequilibrator.RWGSEquilibratorAboutBox;
import rwgsequilibrator.RWGSEquilibratorApp;
import rwgsequilibrator.RWGSEquilibratorUserGuide;

public class RWGSEquilibratorView
extends FrameView {
    private JLabel conversionLabel;
    private JLabel enthalpyLabel;
    private JLabel entropyLabel;
    private JLabel equilConstantLabel;
    private JButton equilibrateButton;
    private JFormattedTextField feedRatioTextField;
    private JLabel freeEnergyLabel;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JMenuItem jMenuItem5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JLabel percentCO2Label;
    private JLabel percentCOLabel;
    private JLabel percentH2Label;
    private JLabel percentH2OLabel;
    private JFormattedTextField pressureTextField;
    private JProgressBar progressBar;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JFormattedTextField temperatureTextField;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;
    private JDialog userGuide;
    private double T;
    private double P;
    private double ratio;
    private double n0CO2;
    private double n0H2;
    private Shomate CO2;
    private Shomate H2;
    private Shomate CO;
    private Shomate H2O;
    private double percentCO2;
    private double percentH2;
    private double percentCO;
    private double percentH2O;

    public RWGSEquilibratorView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RWGSEquilibratorView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RWGSEquilibratorView.this.busyIconIndex = (RWGSEquilibratorView.this.busyIconIndex + 1) % RWGSEquilibratorView.this.busyIcons.length;
                RWGSEquilibratorView.this.statusAnimationLabel.setIcon(RWGSEquilibratorView.this.busyIcons[RWGSEquilibratorView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!RWGSEquilibratorView.this.busyIconTimer.isRunning()) {
                        RWGSEquilibratorView.this.statusAnimationLabel.setIcon(RWGSEquilibratorView.this.busyIcons[0]);
                        RWGSEquilibratorView.this.busyIconIndex = 0;
                        RWGSEquilibratorView.this.busyIconTimer.start();
                    }
                    RWGSEquilibratorView.this.progressBar.setVisible(true);
                    RWGSEquilibratorView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    RWGSEquilibratorView.this.busyIconTimer.stop();
                    RWGSEquilibratorView.this.statusAnimationLabel.setIcon(RWGSEquilibratorView.this.idleIcon);
                    RWGSEquilibratorView.this.progressBar.setVisible(false);
                    RWGSEquilibratorView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    RWGSEquilibratorView.this.statusMessageLabel.setText(text == null ? "" : text);
                    RWGSEquilibratorView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    RWGSEquilibratorView.this.progressBar.setVisible(true);
                    RWGSEquilibratorView.this.progressBar.setIndeterminate(false);
                    RWGSEquilibratorView.this.progressBar.setValue(value);
                }
            }
        });
        this.T = 400.0;
        this.P = 1.0;
        this.ratio = 1.0;
        this.temperatureTextField.setValue(this.T);
        this.pressureTextField.setValue(this.P);
        this.feedRatioTextField.setValue(this.ratio);
        String[] CO2Params = new String[]{"298\t1200\t24.997350\t55.186960\t-33.691370\t7.948387\t-0.136638\t-403.607500\t228.243100\t-393.522400", "1200\t6000\t58.166390\t2.720074\t-0.492289\t0.038844\t-6.447293\t-425.918600\t263.612500\t-393.522400"};
        this.CO2 = new Shomate(CO2Params);
        String[] H2Params = new String[]{"298\t1500\t33.107800\t-11.508000\t11.609300\t-2.844400\t-0.159665\t-9.991971\t172.788000\t0.000000", "1500\t6000\t34.143400\t0.503927\t0.372036\t-0.038599\t-8.074761\t-21.218800\t162.093000\t0.000000"};
        this.H2 = new Shomate(H2Params);
        String[] COParams = new String[]{"298\t1300\t25.567590\t6.096130\t4.054656\t-2.671301\t0.131021\t-118.008900\t227.366500\t-110.527100", "1300\t6000\t35.150700\t1.300095\t-0.205921\t0.013550\t-3.282780\t-127.837500\t231.712000\t-110.527100"};
        this.CO = new Shomate(COParams);
        String[] H2OParams = new String[]{"500\t1700\t30.092000\t6.832514\t6.793435\t-2.534480\t0.082139\t-250.881000\t223.396700\t-241.826400", "1700\t6000\t41.964260\t8.622053\t-1.499780\t0.098119\t-11.157640\t-272.179700\t219.780900\t-241.826400"};
        this.H2O = new Shomate(H2OParams);
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = RWGSEquilibratorApp.getApplication().getMainFrame();
            this.aboutBox = new RWGSEquilibratorAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        RWGSEquilibratorApp.getApplication().show(this.aboutBox);
    }

    @Action
    public void showUserGuide() {
        if (this.userGuide == null) {
            JFrame mainFrame = RWGSEquilibratorApp.getApplication().getMainFrame();
            this.userGuide = new RWGSEquilibratorUserGuide(mainFrame);
            this.userGuide.setLocationRelativeTo(mainFrame);
        }
        RWGSEquilibratorApp.getApplication().show(this.userGuide);
    }

    @Action
    public Task equilibrate() {
        return new EquilibrateTask(this.getApplication());
    }

    public void clearResults() {
        this.enthalpyLabel.setText("");
        this.entropyLabel.setText("");
        this.freeEnergyLabel.setText("");
        this.equilConstantLabel.setText("");
        this.percentCO2Label.setText("");
        this.percentH2Label.setText("");
        this.percentCOLabel.setText("");
        this.percentH2OLabel.setText("");
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.feedRatioTextField = new JFormattedTextField();
        this.pressureTextField = new JFormattedTextField();
        this.temperatureTextField = new JFormattedTextField();
        this.equilibrateButton = new JButton();
        this.jLabel14 = new JLabel();
        this.jPanel2 = new JPanel();
        this.enthalpyLabel = new JLabel();
        this.entropyLabel = new JLabel();
        this.freeEnergyLabel = new JLabel();
        this.equilConstantLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.percentCO2Label = new JLabel();
        this.percentH2Label = new JLabel();
        this.percentCOLabel = new JLabel();
        this.percentH2OLabel = new JLabel();
        this.conversionLabel = new JLabel();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.mainPanel.setName("mainPanel");
        ResourceMap resourceMap = Application.getInstance(RWGSEquilibratorApp.class).getContext().getResourceMap(RWGSEquilibratorView.class);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("jPanel1.border.title", new Object[0]), 0, 0, resourceMap.getFont("jPanel1.border.titleFont")));
        this.jPanel1.setForeground(resourceMap.getColor("jPanel1.foreground"));
        this.jPanel1.setName("jPanel1");
        this.jLabel11.setHorizontalAlignment(2);
        this.jLabel11.setText(resourceMap.getString("jLabel11.text", new Object[0]));
        this.jLabel11.setName("jLabel11");
        this.jLabel12.setHorizontalAlignment(2);
        this.jLabel12.setText(resourceMap.getString("jLabel12.text", new Object[0]));
        this.jLabel12.setName("jLabel12");
        this.jLabel13.setHorizontalAlignment(2);
        this.jLabel13.setText(resourceMap.getString("jLabel13.text", new Object[0]));
        this.jLabel13.setName("jLabel13");
        this.feedRatioTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter()));
        this.feedRatioTextField.setText(resourceMap.getString("feedRatioTextField.text", new Object[0]));
        this.feedRatioTextField.setToolTipText(resourceMap.getString("feedRatioTextField.toolTipText", new Object[0]));
        this.feedRatioTextField.setName("feedRatioTextField");
        this.feedRatioTextField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                RWGSEquilibratorView.this.newInitialFeedRatio(evt);
            }
        });
        this.pressureTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.pressureTextField.setText(resourceMap.getString("pressureTextField.text", new Object[0]));
        this.pressureTextField.setToolTipText(resourceMap.getString("pressureTextField.toolTipText", new Object[0]));
        this.pressureTextField.setName("pressureTextField");
        this.pressureTextField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                RWGSEquilibratorView.this.newInitialPressure(evt);
            }
        });
        this.temperatureTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.temperatureTextField.setText(resourceMap.getString("temperatureTextField.text", new Object[0]));
        this.temperatureTextField.setToolTipText(resourceMap.getString("temperatureTextField.toolTipText", new Object[0]));
        this.temperatureTextField.setName("temperatureTextField");
        this.temperatureTextField.setFocusLostBehavior(1);
        this.temperatureTextField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                RWGSEquilibratorView.this.newInitialTemperature(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel12).addPreferredGap(0).add((Component)this.pressureTextField, -1, 81, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel13).addPreferredGap(0).add((Component)this.feedRatioTextField, -1, 81, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel11).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.temperatureTextField, -2, 71, -2))).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.jLabel12, this.jLabel13}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel11).add((Component)this.temperatureTextField, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel12).add((Component)this.pressureTextField, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel13).add((Component)this.feedRatioTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        ApplicationActionMap actionMap = Application.getInstance(RWGSEquilibratorApp.class).getContext().getActionMap(RWGSEquilibratorView.class, this);
        this.equilibrateButton.setAction(actionMap.get("equilibrate"));
        this.equilibrateButton.setText(resourceMap.getString("equilibrateButton.text", new Object[0]));
        this.equilibrateButton.setName("equilibrateButton");
        this.jLabel14.setHorizontalAlignment(0);
        this.jLabel14.setText(resourceMap.getString("jLabel14.text", new Object[0]));
        this.jLabel14.setName("jLabel14");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("jPanel2.border.title", new Object[0]), 0, 0, resourceMap.getFont("jPanel2.border.titleFont")));
        this.jPanel2.setName("jPanel2");
        this.enthalpyLabel.setHorizontalAlignment(0);
        this.enthalpyLabel.setText(resourceMap.getString("enthalpyLabel.text", new Object[0]));
        this.enthalpyLabel.setName("enthalpyLabel");
        this.entropyLabel.setHorizontalAlignment(0);
        this.entropyLabel.setText(resourceMap.getString("entropyLabel.text", new Object[0]));
        this.entropyLabel.setName("entropyLabel");
        this.freeEnergyLabel.setHorizontalAlignment(0);
        this.freeEnergyLabel.setText(resourceMap.getString("freeEnergyLabel.text", new Object[0]));
        this.freeEnergyLabel.setName("freeEnergyLabel");
        this.equilConstantLabel.setHorizontalAlignment(0);
        this.equilConstantLabel.setText(resourceMap.getString("equilConstantLabel.text", new Object[0]));
        this.equilConstantLabel.setName("equilConstantLabel");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.enthalpyLabel, -1, 212, Short.MAX_VALUE).add(2, (Component)this.entropyLabel, -1, 212, Short.MAX_VALUE).add(2, (Component)this.freeEnergyLabel, -1, 212, Short.MAX_VALUE).add((Component)this.equilConstantLabel, -1, 212, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.enthalpyLabel).add(18, 18, 18).add((Component)this.entropyLabel).add(18, 18, 18).add((Component)this.freeEnergyLabel).addPreferredGap(0, 20, Short.MAX_VALUE).add((Component)this.equilConstantLabel).addContainerGap()));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("jPanel3.border.title", new Object[0]), 0, 0, resourceMap.getFont("jPanel3.border.titleFont")));
        this.jPanel3.setName("jPanel3");
        this.jLabel15.setText(resourceMap.getString("jLabel15.text", new Object[0]));
        this.jLabel15.setName("jLabel15");
        this.jLabel16.setText(resourceMap.getString("jLabel16.text", new Object[0]));
        this.jLabel16.setName("jLabel16");
        this.jLabel17.setText(resourceMap.getString("jLabel17.text", new Object[0]));
        this.jLabel17.setName("jLabel17");
        this.jLabel18.setText(resourceMap.getString("jLabel18.text", new Object[0]));
        this.jLabel18.setName("jLabel18");
        this.percentCO2Label.setHorizontalAlignment(2);
        this.percentCO2Label.setText(resourceMap.getString("percentCO2Label.text", new Object[0]));
        this.percentCO2Label.setHorizontalTextPosition(2);
        this.percentCO2Label.setName("percentCO2Label");
        this.percentH2Label.setHorizontalAlignment(2);
        this.percentH2Label.setText(resourceMap.getString("percentH2Label.text", new Object[0]));
        this.percentH2Label.setHorizontalTextPosition(2);
        this.percentH2Label.setName("percentH2Label");
        this.percentCOLabel.setHorizontalAlignment(2);
        this.percentCOLabel.setText(resourceMap.getString("percentCOLabel.text", new Object[0]));
        this.percentCOLabel.setHorizontalTextPosition(2);
        this.percentCOLabel.setName("percentCOLabel");
        this.percentH2OLabel.setHorizontalAlignment(2);
        this.percentH2OLabel.setText(resourceMap.getString("percentH2OLabel.text", new Object[0]));
        this.percentH2OLabel.setHorizontalTextPosition(2);
        this.percentH2OLabel.setName("percentH2OLabel");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel15).addPreferredGap(0).add((Component)this.percentCO2Label, -1, 134, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel16).addPreferredGap(0).add((Component)this.percentH2Label, -1, 143, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel17).addPreferredGap(0).add((Component)this.percentCOLabel, -1, 141, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel18).addPreferredGap(0).add((Component)this.percentH2OLabel, -1, 133, Short.MAX_VALUE))).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel15).add((Component)this.percentCO2Label)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel16).add((Component)this.percentH2Label)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel17).add((Component)this.percentCOLabel)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel18).add((Component)this.percentH2OLabel))));
        this.conversionLabel.setText(resourceMap.getString("conversionLabel.text", new Object[0]));
        this.conversionLabel.setName("conversionLabel");
        GroupLayout mainPanelLayout = new GroupLayout((Container)this.mainPanel);
        this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
        mainPanelLayout.setHorizontalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((Component)this.conversionLabel, -1, 458, Short.MAX_VALUE).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(2, false).add(1, (Component)this.jLabel14, -1, -1, Short.MAX_VALUE).add(1, (Component)this.equilibrateButton, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).add(18, 18, 18).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        mainPanelLayout.setVerticalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1, false).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(0, 7, Short.MAX_VALUE).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(4).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((Component)this.equilibrateButton).addPreferredGap(0).add((Component)this.jLabel14)).add((Component)this.jPanel3, -2, -1, -2)).addPreferredGap(0).add((Component)this.conversionLabel).addContainerGap()));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setToolTipText(resourceMap.getString("aboutMenuItem.toolTipText", new Object[0]));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.jMenuItem5.setAction(actionMap.get("showUserGuide"));
        this.jMenuItem5.setText(resourceMap.getString("jMenuItem5.text", new Object[0]));
        this.jMenuItem5.setToolTipText(resourceMap.getString("jMenuItem5.toolTipText", new Object[0]));
        this.jMenuItem5.setName("jMenuItem5");
        helpMenu.add(this.jMenuItem5);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout((Container)this.statusPanel);
        this.statusPanel.setLayout((LayoutManager)statusPanelLayout);
        statusPanelLayout.setHorizontalGroup((GroupLayout.Group)statusPanelLayout.createParallelGroup(1).add((Component)statusPanelSeparator, -1, 498, Short.MAX_VALUE).add(2, (GroupLayout.Group)statusPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.statusMessageLabel).addPreferredGap(0, 304, Short.MAX_VALUE).add((Component)this.statusAnimationLabel).addPreferredGap(0).add((Component)this.progressBar, -2, -1, -2).addContainerGap()));
        statusPanelLayout.setVerticalGroup((GroupLayout.Group)statusPanelLayout.createParallelGroup(1).add((GroupLayout.Group)statusPanelLayout.createSequentialGroup().add((Component)statusPanelSeparator, -2, 2, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)statusPanelLayout.createParallelGroup(2).add((GroupLayout.Group)statusPanelLayout.createSequentialGroup().add((GroupLayout.Group)statusPanelLayout.createParallelGroup(3).add((Component)this.statusMessageLabel).add((Component)this.statusAnimationLabel)).add(32, 32, 32)).add((GroupLayout.Group)statusPanelLayout.createSequentialGroup().add((Component)this.progressBar, -2, -1, -2).addContainerGap()))));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void newInitialTemperature(PropertyChangeEvent evt) {
        double newTemperature = ((Number)this.temperatureTextField.getValue()).doubleValue();
        if (newTemperature != this.T) {
            this.clearResults();
            this.T = newTemperature < 298.0 ? 298.0 : (newTemperature > 1200.0 ? 1200.0 : newTemperature);
            this.temperatureTextField.setValue(new Double(this.T));
        }
    }

    private void newInitialPressure(PropertyChangeEvent evt) {
        double newPressure = ((Number)this.pressureTextField.getValue()).doubleValue();
        if (newPressure != this.P) {
            this.clearResults();
            this.P = newPressure < 1.0 ? 1.0 : (newPressure > 100.0 ? 100.0 : newPressure);
            this.pressureTextField.setValue(new Double(this.P));
        }
    }

    private void newInitialFeedRatio(PropertyChangeEvent evt) {
        double newFeedRatio = ((Number)this.feedRatioTextField.getValue()).doubleValue();
        if (newFeedRatio != this.ratio) {
            this.clearResults();
            this.ratio = newFeedRatio < 0.01 ? 0.01 : (newFeedRatio > 100.0 ? 100.0 : newFeedRatio);
            this.feedRatioTextField.setValue(new Double(this.ratio));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EquilibrateTask
    extends Task<Object, Void>
    implements NMNewtRaphEqns,
    NMJacEstEqns {
        double temperature;
        double pressure;
        double feedRatio;
        double conversion;
        double sRxn;
        double hRxn;
        double gRxn;
        double K;
        double[] x;
        double[] y;

        EquilibrateTask(Application app) {
            super(app);
            this.temperature = ((Number)RWGSEquilibratorView.this.temperatureTextField.getValue()).doubleValue();
            this.pressure = ((Number)RWGSEquilibratorView.this.pressureTextField.getValue()).doubleValue();
            this.feedRatio = ((Number)RWGSEquilibratorView.this.feedRatioTextField.getValue()).doubleValue();
            RWGSEquilibratorView.this.equilibrateButton.setEnabled(false);
        }

        @Override
        protected Object doInBackground() {
            String txt = "Calculating Species Thermo";
            this.setMessage(txt);
            int progress = 0;
            this.setProgress(0);
            RWGSEquilibratorView.this.n0H2 = 1.0;
            RWGSEquilibratorView.this.n0CO2 = this.feedRatio;
            double sCO2 = RWGSEquilibratorView.this.CO2.sStd(this.temperature).getDoubleValue();
            double sH2 = RWGSEquilibratorView.this.H2.sStd(this.temperature).getDoubleValue();
            double sCO = RWGSEquilibratorView.this.CO.sStd(this.temperature).getDoubleValue();
            double sH2O = RWGSEquilibratorView.this.H2O.sStd(this.temperature).getDoubleValue();
            double hCO2 = RWGSEquilibratorView.this.CO2.hForm(this.temperature).getDoubleValue();
            double hH2 = RWGSEquilibratorView.this.H2.hForm(this.temperature).getDoubleValue();
            double hCO = RWGSEquilibratorView.this.CO.hForm(this.temperature).getDoubleValue();
            double hH2O = RWGSEquilibratorView.this.H2O.hForm(this.temperature).getDoubleValue();
            double gCO2 = RWGSEquilibratorView.this.CO2.gForm(this.temperature).getDoubleValue();
            double gH2 = RWGSEquilibratorView.this.H2.gForm(this.temperature).getDoubleValue();
            double gCO = RWGSEquilibratorView.this.CO.gForm(this.temperature).getDoubleValue();
            double gH2O = RWGSEquilibratorView.this.H2O.gForm(this.temperature).getDoubleValue();
            txt = "Calculating Reaction Thermo";
            this.setMessage(txt);
            progress = 25;
            this.setProgress(progress);
            this.sRxn = sCO + sH2O - sCO2 - sH2;
            this.hRxn = hCO + hH2O - hCO2 - hH2;
            this.gRxn = gCO + gH2O - gCO2 - gH2;
            this.K = Math.exp(-this.gRxn * 1000.0 / 8.3144 / this.temperature);
            txt = "Calculating Equilibrium Composition";
            this.setMessage(txt);
            progress = 50;
            this.setProgress(progress);
            this.x = new double[4];
            this.y = new double[4];
            this.x[0] = RWGSEquilibratorView.this.n0CO2;
            this.x[1] = RWGSEquilibratorView.this.n0H2;
            this.x[2] = 0.0;
            this.x[3] = 0.0;
            progress = 75;
            this.setProgress(progress);
            NMNewtRaphSolver theSolver = new NMNewtRaphSolver((NMNewtRaphEqns)this);
            theSolver.setTol(1.0E-4);
            theSolver.setTreatAsNonNegative(true);
            NMResult theResult = theSolver.solve(this.x, this.y);
            RWGSEquilibratorView.this.percentCO2 = 100.0 * this.x[0] / (RWGSEquilibratorView.this.n0CO2 + RWGSEquilibratorView.this.n0H2);
            RWGSEquilibratorView.this.percentH2 = 100.0 * this.x[1] / (RWGSEquilibratorView.this.n0CO2 + RWGSEquilibratorView.this.n0H2);
            RWGSEquilibratorView.this.percentCO = 100.0 * this.x[2] / (RWGSEquilibratorView.this.n0CO2 + RWGSEquilibratorView.this.n0H2);
            RWGSEquilibratorView.this.percentH2O = 100.0 * this.x[3] / (RWGSEquilibratorView.this.n0CO2 + RWGSEquilibratorView.this.n0H2);
            this.conversion = this.feedRatio <= 1.0 ? 100.0 * (RWGSEquilibratorView.this.n0CO2 - this.x[0]) / RWGSEquilibratorView.this.n0CO2 : 100.0 * (RWGSEquilibratorView.this.n0H2 - this.x[1]) / RWGSEquilibratorView.this.n0H2;
            txt = "";
            this.setMessage(txt);
            progress = 100;
            this.setProgress(progress);
            return null;
        }

        @Override
        protected void succeeded(Object result) {
            DecimalFormat noDecimal = new DecimalFormat("####");
            DecimalFormat threeSigFigs = new DecimalFormat("0.00E00");
            DecimalFormat notScientific = new DecimalFormat("##0.00");
            String txt = "<html>&#916;S(" + noDecimal.format(this.temperature);
            txt = txt + ") = ";
            txt = Math.abs(this.sRxn) < 0.1 ? txt + threeSigFigs.format(this.sRxn) + " J/(mol K)" : txt + notScientific.format(this.sRxn) + " J/(mol K)";
            RWGSEquilibratorView.this.entropyLabel.setText(txt);
            txt = "<html>&#916;H(" + noDecimal.format(this.temperature);
            txt = txt + ") = ";
            txt = Math.abs(this.hRxn) < 0.1 ? txt + threeSigFigs.format(this.hRxn) + " kJ/mol" : txt + notScientific.format(this.hRxn) + " kJ/mol";
            RWGSEquilibratorView.this.enthalpyLabel.setText(txt);
            txt = "<html>&#916;G(" + noDecimal.format(this.temperature);
            txt = txt + ") = ";
            txt = Math.abs(this.gRxn) < 0.1 ? txt + threeSigFigs.format(this.gRxn) + " kJ/mol" : txt + notScientific.format(this.gRxn) + " kJ/mol";
            RWGSEquilibratorView.this.freeEnergyLabel.setText(txt);
            txt = "<html>K(" + noDecimal.format(this.temperature);
            txt = txt + ") = " + threeSigFigs.format(this.K);
            RWGSEquilibratorView.this.equilConstantLabel.setText(txt);
            txt = RWGSEquilibratorView.this.percentCO2 < 0.1 ? threeSigFigs.format(RWGSEquilibratorView.this.percentCO2) : notScientific.format(RWGSEquilibratorView.this.percentCO2);
            txt = txt + " %";
            RWGSEquilibratorView.this.percentCO2Label.setText(txt);
            txt = RWGSEquilibratorView.this.percentH2 < 0.1 ? threeSigFigs.format(RWGSEquilibratorView.this.percentH2) : notScientific.format(RWGSEquilibratorView.this.percentH2);
            txt = txt + " %";
            RWGSEquilibratorView.this.percentH2Label.setText(txt);
            txt = RWGSEquilibratorView.this.percentCO < 0.1 ? threeSigFigs.format(RWGSEquilibratorView.this.percentCO) : notScientific.format(RWGSEquilibratorView.this.percentCO);
            txt = txt + " %";
            RWGSEquilibratorView.this.percentCOLabel.setText(txt);
            txt = RWGSEquilibratorView.this.percentH2O < 0.1 ? threeSigFigs.format(RWGSEquilibratorView.this.percentH2O) : notScientific.format(RWGSEquilibratorView.this.percentH2O);
            txt = txt + " %";
            RWGSEquilibratorView.this.percentH2OLabel.setText(txt);
            RWGSEquilibratorView.this.equilibrateButton.setEnabled(true);
            txt = "<html>Limiting Reagent ";
            if (this.feedRatio < 1.0) {
                txt = txt + "(CO<sub>2</sub>) ";
            }
            if (this.feedRatio > 1.0) {
                txt = txt + "(H<sub>2</sub>) ";
            }
            txt = txt + "Conversion is ";
            txt = this.conversion < 0.1 ? txt + threeSigFigs.format(this.conversion) : txt + notScientific.format(this.conversion);
            txt = txt + " %";
            RWGSEquilibratorView.this.conversionLabel.setText(txt);
            RWGSEquilibratorView.this.equilibrateButton.setEnabled(true);
        }

        public NMResult evalNewtRaphEqns(double[] x, double[] y) {
            NMResult theResult = new NMResult();
            y[0] = this.K * x[0] * x[1] - x[2] * x[3];
            y[1] = RWGSEquilibratorView.this.n0CO2 - x[2] - x[0];
            y[2] = RWGSEquilibratorView.this.n0H2 - x[1] - x[3];
            y[3] = 2.0 * RWGSEquilibratorView.this.n0CO2 - 2.0 * x[0] - x[2] - x[3];
            return theResult;
        }

        public NMResult evalNewtRaphJac(double[] x, double[][] jac) {
            NMJacEstimator jacEstimator = new NMJacEstimator((NMJacEstEqns)this);
            NMResult theResult = new NMResult();
            jacEstimator.estimate(4, x, jac, 1.0E-4);
            return theResult;
        }

        public NMResult evalJacEstEqns(double[] x, double[] y) {
            NMResult theResult = this.evalNewtRaphEqns(x, y);
            return theResult;
        }
    }
}

