/*
 * Decompiled with CFR 0.152.
 */
package numeth;

import numeth.NMResult;

public class NMMatrixOperator {
    public NMResult transpose(double[][] theMatrix, double[][] itsTranspose) {
        int nc;
        int irow;
        String[] eMsg = new String[]{"", "NMMatrix.transpose: number of rows in theMatrix not equal to number of columns in itsTranspose", "NMMatrix.transpose: number of columns in theMatrix not equal to number of rows in itsTranspose"};
        NMResult theResult = new NMResult();
        int nr = theMatrix.length;
        for (irow = 0; irow < itsTranspose.length; ++irow) {
            nc = itsTranspose[irow].length;
            if (nr == nc) continue;
            theResult.setStatus(1, eMsg[1]);
            return theResult;
        }
        nr = itsTranspose.length;
        for (irow = 0; irow < theMatrix.length; ++irow) {
            nc = theMatrix[irow].length;
            if (nr == nc) continue;
            theResult.setStatus(2, eMsg[2]);
            return theResult;
        }
        for (int i = 0; i < theMatrix.length; ++i) {
            for (int j = 0; j < theMatrix[0].length; ++j) {
                itsTranspose[j][i] = theMatrix[i][j];
            }
        }
        return theResult;
    }

    public NMResult mult(double[][] leftMatrix, double[][] rightMatrix, double[][] product) {
        int icol;
        String[] eMsg = new String[]{"", "NMMatrix.mult: number of columns in leftMatrix not equal to number of rows in rightMatrix", "NMMatrix.mult: number of rows in product matrix not equal to number of rows in leftMatrix", "NMMatrix.mult: number of columns in product matrix not equal to number of columns in rightMatrix"};
        NMResult theResult = new NMResult();
        for (icol = 0; icol < leftMatrix.length; ++icol) {
            if (leftMatrix[icol].length == rightMatrix.length) continue;
            theResult.setStatus(1, eMsg[1]);
            return theResult;
        }
        if (leftMatrix.length != product.length) {
            theResult.setStatus(2, eMsg[2]);
            return theResult;
        }
        for (icol = 0; icol < rightMatrix.length; ++icol) {
            for (int icol2 = 0; icol2 < product.length; ++icol2) {
                if (rightMatrix[icol].length == product[icol2].length) continue;
                theResult.setStatus(3, eMsg[3]);
                return theResult;
            }
        }
        for (int i = 0; i < product[0].length; ++i) {
            for (int j = 0; j < product.length; ++j) {
                product[i][j] = 0.0;
                for (int k = 0; k < leftMatrix[0].length; ++k) {
                    double[] dArray = product[i];
                    int n = j;
                    dArray[n] = dArray[n] + leftMatrix[i][k] * rightMatrix[k][j];
                }
            }
        }
        return theResult;
    }

    public NMResult mult(double[][] leftMatrix, double[] rightColVect, double[] productColVect) {
        int i;
        String[] eMsg = new String[]{"", "NMMatrix.mult: number of columns in leftMatrix not equal to length of rightColVect", "NMMatrix.mult: number of columns in leftMatrix not equal to length of productColVect"};
        NMResult theResult = new NMResult();
        for (i = 0; i < leftMatrix.length; ++i) {
            if (leftMatrix[i].length != rightColVect.length) {
                theResult.setStatus(1, eMsg[1]);
            }
            if (leftMatrix[i].length == productColVect.length) continue;
            theResult.setStatus(2, eMsg[2]);
            return theResult;
        }
        for (i = 0; i < productColVect.length; ++i) {
            productColVect[i] = 0.0;
            for (int j = 0; j < rightColVect.length; ++j) {
                int n = i;
                productColVect[n] = productColVect[n] + leftMatrix[i][j] * rightColVect[j];
            }
        }
        return theResult;
    }

    public NMResult mult(double[] rowVect, double[] colVect) {
        String[] eMsg = new String[]{"", "NMMatrix.mult: length of rowVect not equal to length of colVect"};
        NMResult theResult = new NMResult();
        if (rowVect.length != colVect.length) {
            theResult.setStatus(1, eMsg[1]);
            return theResult;
        }
        double result = 0.0;
        for (int i = 0; i < rowVect.length; ++i) {
            result += rowVect[i] * colVect[i];
        }
        theResult.setDoubleValue(result);
        return theResult;
    }

    public NMResult luDecomp(double[][] theMatrix, double[][] theLUMatrix, int[] indx) {
        String[] eMsg = new String[]{"", "NMMatrix.luDecomp: theMatrix is not square", "NMMatrix.luDecomp: theMatrix and theLUMatrix are not the same size", "NMMatrix.luDecomp: theMatrix and indx are not the same size", "NMMatrix.luDecomp: theMatrix is singular; can't recover", "NMMatrix.luDecomp: theMatrix is singular; attempting to continue"};
        NMResult theResult = new NMResult();
        int n = theMatrix.length;
        for (int i = 0; i < n; ++i) {
            if (n != theMatrix[i].length) {
                theResult.setStatus(1, eMsg[1]);
                return theResult;
            }
            if (n == theLUMatrix[i].length) continue;
            theResult.setStatus(2, eMsg[2]);
            return theResult;
        }
        if (n != theLUMatrix.length) {
            theResult.setStatus(2, eMsg[2]);
            return theResult;
        }
        if (n != indx.length) {
            theResult.setStatus(3, eMsg[3]);
            return theResult;
        }
        double[] v = new double[n];
        theResult.setIntValue(1);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                theLUMatrix[i][j] = theMatrix[i][j];
            }
        }
        for (int i = 0; i < n; ++i) {
            double big = 0.0;
            for (int j = 0; j < n; ++j) {
                double temp = Math.abs(theLUMatrix[i][j]);
                if (!(temp > big)) continue;
                big = temp;
            }
            if (big == 0.0) {
                theResult.setStatus(4, eMsg[4]);
                return theResult;
            }
            v[i] = 1.0 / big;
        }
        for (int j = 0; j < n; ++j) {
            int i;
            for (int i2 = 0; i2 < j; ++i2) {
                double sum = theLUMatrix[i2][j];
                for (int k = 0; k < i2; ++k) {
                    sum -= theLUMatrix[i2][k] * theLUMatrix[k][j];
                }
                theLUMatrix[i2][j] = sum;
            }
            double big = 0.0;
            int imax = j;
            for (i = j; i < n; ++i) {
                double sum = theLUMatrix[i][j];
                for (int k = 0; k < j; ++k) {
                    sum -= theLUMatrix[i][k] * theLUMatrix[k][j];
                }
                theLUMatrix[i][j] = sum;
                double temp = Math.abs(sum);
                double dum = v[i] * temp;
                if (!(dum >= big)) continue;
                big = dum;
                imax = i;
            }
            if (j != imax) {
                for (int k = 0; k < n; ++k) {
                    double dum = theLUMatrix[imax][k];
                    theLUMatrix[imax][k] = theLUMatrix[j][k];
                    theLUMatrix[j][k] = dum;
                }
                int ii = theResult.getIntValue();
                theResult.setIntValue(-ii);
                v[imax] = v[j];
            }
            indx[j] = imax;
            if (theLUMatrix[j][j] == 0.0) {
                theResult.setStatus(5, eMsg[5]);
                theLUMatrix[j][j] = 1.0E-20;
            }
            if (j == n) continue;
            double dum = 1.0 / theLUMatrix[j][j];
            for (i = j + 1; i < n; ++i) {
                double[] dArray = theLUMatrix[i];
                int n2 = j;
                dArray[n2] = dArray[n2] * dum;
            }
        }
        return theResult;
    }

    public NMResult luBacksub(double[][] theLUMatrix, int[] luIndx, double[] unknownRightVect, double[] knownRHSVect) {
        int j;
        double sum;
        int i;
        int i2;
        String[] eMsg = new String[]{"", "NMMatrix.luBacksub: theLUMatrix not square", "NMMatrix.luBacksub: length of unknownRightVect not equal to number of columns in theLUMatrix", "NMMatrix.luBacksub: number of rows in theLUMatirx not equal to length of luIndx", "NMMatrix.luBacksub: length of unknownRightVect not equal to length of knownRHSVect"};
        NMResult theResult = new NMResult();
        int n = theLUMatrix.length;
        for (i2 = 0; i2 < theLUMatrix.length; ++i2) {
            if (n == theLUMatrix[i2].length) continue;
            theResult.setStatus(1, eMsg[1]);
            return theResult;
        }
        if (n != unknownRightVect.length) {
            theResult.setStatus(2, eMsg[2]);
            return theResult;
        }
        if (n != luIndx.length) {
            theResult.setStatus(3, eMsg[3]);
            return theResult;
        }
        if (unknownRightVect.length != knownRHSVect.length) {
            theResult.setStatus(4, eMsg[4]);
            return theResult;
        }
        for (i2 = 0; i2 < n; ++i2) {
            unknownRightVect[i2] = knownRHSVect[i2];
        }
        int ii = -1;
        for (i = 0; i < n; ++i) {
            int ip = luIndx[i];
            sum = unknownRightVect[ip];
            unknownRightVect[ip] = unknownRightVect[i];
            if (ii >= 0) {
                for (j = ii; j <= i - 1; ++j) {
                    sum -= theLUMatrix[i][j] * unknownRightVect[j];
                }
            } else if (sum != 0.0) {
                ii = i;
            }
            unknownRightVect[i] = sum;
        }
        for (i = n - 1; i >= 0; --i) {
            sum = unknownRightVect[i];
            for (j = i + 1; j < n; ++j) {
                sum -= theLUMatrix[i][j] * unknownRightVect[j];
            }
            unknownRightVect[i] = sum / theLUMatrix[i][i];
        }
        return theResult;
    }

    public NMResult invert(double[][] theMatrix, double[][] itsInverse) {
        int i;
        String[] eMsg = new String[]{"", "NMMatrix.invert: theMatrix not square", "NMMatrix.invert: theMatrix and itsInverse not equal sizes", "NMMatrix.invert: inverse matrix not square", "NMMatrix.invert: error received during LU decomposition", "NMMatrix.invert: error received during LU backsubstitution"};
        NMResult theResult = new NMResult();
        int n = theMatrix.length;
        for (i = 0; i < theMatrix.length; ++i) {
            if (n == theMatrix[i].length) continue;
            theResult.setStatus(1, eMsg[1]);
            return theResult;
        }
        if (n != itsInverse.length) {
            theResult.setStatus(2, eMsg[2]);
            return theResult;
        }
        for (i = 0; i < itsInverse.length; ++i) {
            if (n == itsInverse[i].length) continue;
            theResult.setStatus(3, eMsg[3]);
            return theResult;
        }
        int[] indx = new int[n];
        double[][] theLUMatrix = new double[n][n];
        for (int i2 = 0; i2 < n; ++i2) {
            indx[i2] = 0;
            for (int j = 0; j < n; ++j) {
                theLUMatrix[i2][j] = 0.0;
            }
        }
        NMResult luResult = this.luDecomp(theMatrix, theLUMatrix, indx);
        if (luResult.getStatus() != 0) {
            theResult.setStatus(4, eMsg[4], luResult);
            return theResult;
        }
        double[] col = new double[n];
        double[] x = new double[n];
        for (int j = 0; j < n; ++j) {
            int i3;
            for (i3 = 0; i3 < n; ++i3) {
                col[i3] = 0.0;
            }
            col[j] = 1.0;
            luResult = this.luBacksub(theLUMatrix, indx, x, col);
            if (luResult.getStatus() != 0) {
                theResult.setStatus(5, eMsg[5], luResult);
                return theResult;
            }
            for (i3 = 0; i3 < n; ++i3) {
                itsInverse[i3][j] = x[i3];
            }
        }
        return theResult;
    }

    public NMResult det(double[][] theMatrix) {
        String[] eMsg = new String[]{"", "NMMatrix.det: theMatrix is not square", "NMMatrix.det: error during LU decomposition"};
        NMResult theResult = new NMResult();
        int n = theMatrix.length;
        for (int i = 0; i < theMatrix.length; ++i) {
            if (n == theMatrix[i].length) continue;
            theResult.setStatus(1, eMsg[1]);
            return theResult;
        }
        double[][] theLUMatrix = new double[n][n];
        int[] ind = new int[n];
        NMResult decompResult = this.luDecomp(theMatrix, theLUMatrix, ind);
        if (decompResult.getStatus() != 0) {
            theResult.setStatus(2, eMsg[2], decompResult);
            return theResult;
        }
        theResult.setDoubleValue(decompResult.getIntValue());
        for (int i = 0; i < n; ++i) {
            double dummy = theResult.getDoubleValue();
            theResult.setDoubleValue(dummy * theLUMatrix[i][i]);
        }
        return theResult;
    }

    public NMResult gaussElim(double[][] theMatrix, double[] unknownVect, double[] knownRHSVect) {
        int i;
        String[] eMsg = new String[]{"", "NMGauss.gaussElim: theMatrix is not square", "NMGauss.gaussElim: length of unknownVect not equal to number of columns in theMatrix", "NMGauss.gaussElim: length of unknownVect not equal to length of knownRHSVect", "NMGauss.gaussElim: theMatrix is singular"};
        NMResult theResult = new NMResult();
        int n = theMatrix.length;
        for (i = 0; i < theMatrix.length; ++i) {
            if (n == theMatrix[i].length) continue;
            theResult.setStatus(1, eMsg[1]);
            return theResult;
        }
        if (n != unknownVect.length) {
            theResult.setStatus(2, eMsg[2]);
            return theResult;
        }
        if (n != knownRHSVect.length) {
            theResult.setStatus(3, eMsg[3]);
            return theResult;
        }
        for (int j = 0; j < n - 1; ++j) {
            double tmp;
            int i2;
            int diag = j;
            for (i2 = j + 1; i2 < n; ++i2) {
                if (!(Math.abs(theMatrix[i2][j]) > Math.abs(theMatrix[diag][j]))) continue;
                diag = i2;
            }
            if (theMatrix[diag][j] == 0.0) {
                theResult.setStatus(4, eMsg[4]);
                return theResult;
            }
            if (diag != j) {
                for (int k = j; k < n; ++k) {
                    tmp = theMatrix[diag][k];
                    theMatrix[diag][k] = theMatrix[j][k];
                    theMatrix[j][k] = tmp;
                }
                double tmp2 = knownRHSVect[diag];
                knownRHSVect[diag] = knownRHSVect[j];
                knownRHSVect[j] = tmp2;
            }
            i2 = j + 1;
            while (i2 < n) {
                tmp = -theMatrix[i2][j] / theMatrix[j][j];
                for (int k = j + 1; k < n; ++k) {
                    double[] dArray = theMatrix[i2];
                    int n2 = k;
                    dArray[n2] = dArray[n2] + tmp * theMatrix[j][k];
                }
                int n3 = i2++;
                knownRHSVect[n3] = knownRHSVect[n3] + tmp * knownRHSVect[j];
            }
        }
        if (theMatrix[n - 1][n - 1] == 0.0) {
            theResult.setStatus(4, eMsg[4]);
            return theResult;
        }
        for (i = n - 1; i >= 0; --i) {
            if (i != n - 1) {
                for (int j = n - 1; j > i; --j) {
                    int n4 = i;
                    knownRHSVect[n4] = knownRHSVect[n4] + -theMatrix[i][j] * unknownVect[j];
                }
            }
            unknownVect[i] = knownRHSVect[i] / theMatrix[i][i];
        }
        return theResult;
    }
}

