/*
 * Decompiled with CFR 0.152.
 */
package numeth;

import numeth.NMHessEstEqn;
import numeth.NMResult;

public class NMHessEstimator {
    private NMHessEstEqn fcn;

    public NMResult estimate(double[] x, double[][] hess, double relErr) {
        int j;
        double y4;
        double y3;
        double y2;
        double y1;
        double hi;
        double x4;
        double x3;
        double x2;
        double x1;
        double bestEst;
        double est;
        double relChg;
        int i;
        String[] eMsg = new String[]{"", "NMHessEstimator.estimate: length of vector x not equal to number of rows in matrix hess", "NMHessEstimator.estimate: matrix hess is not square", "NMHessEstimator.estimate: requested relative error is less minimum allowed value (1.0E-15)", "NMHessEstimator.estimate: error evaluating theFunction", "NMHessEstimator.estimate: requested accuracy was not realized"};
        NMResult theResult = new NMResult();
        theResult.setIntValue(0);
        int nVars = x.length;
        if (hess.length != nVars) {
            theResult.setStatus(1, eMsg[1]);
            return theResult;
        }
        for (int i2 = 0; i2 < hess.length; ++i2) {
            if (hess[i2].length == nVars) continue;
            theResult.setStatus(2, eMsg[2]);
            return theResult;
        }
        if (relErr < 1.0E-15) {
            theResult.setStatus(3, eMsg[3]);
            return theResult;
        }
        boolean wasLowAccy = false;
        NMResult resultA = new NMResult();
        resultA = this.fcn.evalHessEstEqn(x);
        if (resultA.getStatus() > 0) {
            theResult.setStatus(4, eMsg[4], resultA);
            return theResult;
        }
        double y0 = resultA.getDoubleValue();
        for (i = 0; i < nVars; ++i) {
            double xi = x[i];
            relChg = 10.0 * relErr;
            est = 0.0;
            bestEst = 0.0;
            NMResult resultB = new NMResult();
            NMResult resultC = new NMResult();
            NMResult resultD = new NMResult();
            for (int nIter = 0; nIter < 10 && relChg > relErr; ++nIter) {
                if (xi == 0.0) {
                    x1 = 0.2 / Math.pow(2.0, nIter);
                    x2 = 0.1 / Math.pow(2.0, nIter);
                    x3 = -0.1 / Math.pow(2.0, nIter);
                    x4 = -0.2 / Math.pow(2.0, nIter);
                    hi = 0.1 / Math.pow(2.0, nIter);
                } else {
                    x1 = xi * (1.0 + 0.2 / Math.pow(2.0, nIter));
                    x2 = xi * (1.0 + 0.1 / Math.pow(2.0, nIter));
                    x3 = xi * (1.0 - 0.1 / Math.pow(2.0, nIter));
                    x4 = xi * (1.0 - 0.2 / Math.pow(2.0, nIter));
                    hi = xi * 0.1 / Math.pow(2.0, nIter);
                }
                x[i] = x1;
                resultA = this.fcn.evalHessEstEqn(x);
                y1 = resultA.getDoubleValue();
                x[i] = x2;
                resultB = this.fcn.evalHessEstEqn(x);
                y2 = resultB.getDoubleValue();
                x[i] = x3;
                resultC = this.fcn.evalHessEstEqn(x);
                y3 = resultC.getDoubleValue();
                x[i] = x4;
                resultD = this.fcn.evalHessEstEqn(x);
                y4 = resultD.getDoubleValue();
                bestEst = (-y1 + 16.0 * y2 - 30.0 * y0 + 16.0 * y3 - y4) / (12.0 * hi * hi);
                if (bestEst == 0.0) break;
                relChg = Math.abs(bestEst - est) / Math.abs(bestEst);
                est = bestEst;
            }
            if (resultA.getStatus() > 0) {
                theResult.setStatus(4, eMsg[4], resultA);
                return theResult;
            }
            if (resultB.getStatus() > 0) {
                theResult.setStatus(4, eMsg[4], resultB);
                return theResult;
            }
            if (resultC.getStatus() > 0) {
                theResult.setStatus(4, eMsg[4], resultC);
                return theResult;
            }
            if (resultD.getStatus() > 0) {
                theResult.setStatus(4, eMsg[4], resultD);
                return theResult;
            }
            x[i] = xi;
            hess[i][i] = bestEst;
            if (bestEst == 0.0 || !(relChg > relErr)) continue;
            wasLowAccy = true;
            int ii = theResult.getIntValue();
            theResult.setIntValue(ii + 1);
        }
        for (i = 0; i < nVars; ++i) {
            for (j = i + 1; j < nVars; ++j) {
                double xi = x[i];
                double xj = x[j];
                relChg = 10.0 * relErr;
                est = 0.0;
                bestEst = 0.0;
                NMResult resultB = new NMResult();
                NMResult resultC = new NMResult();
                NMResult resultD = new NMResult();
                for (int nIter = 0; nIter < 10 && relChg > relErr; ++nIter) {
                    double hj;
                    if (xi == 0.0) {
                        x1 = relErr / Math.pow(2.0, nIter);
                        x2 = -relErr / Math.pow(2.0, nIter);
                        hi = relErr / Math.pow(2.0, nIter);
                    } else {
                        x1 = xi * (1.0 + relErr / Math.pow(2.0, nIter));
                        x2 = xi * (1.0 - relErr / Math.pow(2.0, nIter));
                        hi = xi * relErr / Math.pow(2.0, nIter);
                    }
                    if (xj == 0.0) {
                        x3 = relErr / Math.pow(2.0, nIter);
                        x4 = -relErr / Math.pow(2.0, nIter);
                        hj = relErr / Math.pow(2.0, nIter);
                    } else {
                        x3 = xj * (1.0 + relErr / Math.pow(2.0, nIter));
                        x4 = xj * (1.0 - relErr / Math.pow(2.0, nIter));
                        hj = xj * relErr / Math.pow(2.0, nIter);
                    }
                    x[i] = x1;
                    x[j] = x3;
                    resultA = this.fcn.evalHessEstEqn(x);
                    y1 = resultA.getDoubleValue();
                    x[i] = x1;
                    x[j] = x4;
                    resultB = this.fcn.evalHessEstEqn(x);
                    y2 = resultB.getDoubleValue();
                    x[i] = x2;
                    x[j] = x3;
                    resultC = this.fcn.evalHessEstEqn(x);
                    y3 = resultC.getDoubleValue();
                    x[i] = x2;
                    x[j] = x4;
                    resultD = this.fcn.evalHessEstEqn(x);
                    y4 = resultD.getDoubleValue();
                    bestEst = (y1 - y2 - y3 + y4) / (4.0 * hi * hj);
                    if (bestEst == 0.0) break;
                    relChg = Math.abs(bestEst - est) / Math.abs(bestEst);
                    est = bestEst;
                }
                if (resultA.getStatus() > 0) {
                    theResult.setStatus(4, eMsg[4], resultA);
                    return theResult;
                }
                if (resultB.getStatus() > 0) {
                    theResult.setStatus(4, eMsg[4], resultB);
                    return theResult;
                }
                if (resultC.getStatus() > 0) {
                    theResult.setStatus(4, eMsg[4], resultC);
                    return theResult;
                }
                if (resultD.getStatus() > 0) {
                    theResult.setStatus(4, eMsg[4], resultD);
                    return theResult;
                }
                x[i] = xi;
                x[j] = xj;
                hess[i][j] = bestEst;
                if (bestEst == 0.0 || !(relChg > relErr)) continue;
                wasLowAccy = true;
                int ii = theResult.getIntValue();
                theResult.setIntValue(ii + 2);
            }
        }
        for (i = 1; i < nVars; ++i) {
            for (j = 0; j < i; ++j) {
                hess[i][j] = hess[j][i];
            }
        }
        if (wasLowAccy) {
            theResult.setStatus(5, eMsg[5]);
        }
        return theResult;
    }

    public NMHessEstimator(NMHessEstEqn eqn) {
        this.fcn = eqn;
    }
}

