/*
 * Decompiled with CFR 0.152.
 */
package numeth;

import numeth.NMEulerEqns;
import numeth.NMFixedEulerListener;
import numeth.NMNewtRaphEqns;
import numeth.NMNewtRaphSolver;
import numeth.NMResult;

public class NMFixedEulerSolver
implements NMNewtRaphEqns,
NMFixedEulerListener {
    private NMEulerEqns ivodes;
    private boolean implicit;
    private boolean treatAsNonNegative;
    private double minSigValue;
    private double tol;
    private int nEqns;
    private double h;
    private double xNow;
    private double[] yNow;
    private NMFixedEulerListener theListener;

    public NMResult integrate(double x0, double xf, double[] y, int nSteps) {
        String[] eMsg = new String[]{"", "NMFixedEulerSolver.integrate: Error evaluating ODEs", "NMFixedEulerSolver.integrate: Implicit Euler step did not converge"};
        NMResult theResult = new NMResult();
        this.nEqns = y.length;
        this.h = (xf - x0) / (double)nSteps;
        this.xNow = x0;
        this.yNow = new double[this.nEqns];
        for (int i = 0; i < this.nEqns; ++i) {
            this.yNow[i] = y[i];
        }
        double[] dydxNow = new double[this.nEqns];
        double[] dydx = new double[this.nEqns];
        NMNewtRaphSolver nlaeSolver = new NMNewtRaphSolver(this);
        nlaeSolver.setMinSigValue(this.minSigValue);
        nlaeSolver.setTol(this.tol);
        if (this.treatAsNonNegative) {
            nlaeSolver.setTreatAsNonNegative(true);
        }
        for (int steps = 0; steps < nSteps; ++steps) {
            int i;
            this.theListener.call(steps, this.xNow, this.yNow);
            NMResult evalResult = this.ivodes.evalEulerEqns(this.xNow, this.yNow, dydxNow);
            if (evalResult.getStatus() > 0) {
                theResult.setStatus(1, eMsg[1], evalResult);
                return theResult;
            }
            for (i = 0; i < this.nEqns; ++i) {
                y[i] = this.yNow[i] + this.h * dydxNow[i];
            }
            if (this.treatAsNonNegative) {
                for (i = 0; i < this.nEqns; ++i) {
                    if (!(y[i] < 0.0)) continue;
                    y[i] = 0.01 * this.minSigValue;
                }
            }
            if (this.implicit) {
                NMResult solveResult = nlaeSolver.solve(y, dydx);
                if (solveResult.getStatus() == 6) {
                    solveResult = nlaeSolver.solve(y, dydx);
                }
                if (solveResult.getStatus() > 0) {
                    theResult.setStatus(2, eMsg[2], solveResult);
                    return theResult;
                }
                if (this.treatAsNonNegative) {
                    for (int i2 = 0; i2 < this.nEqns; ++i2) {
                        if (!(y[i2] < 0.0)) continue;
                        y[i2] = 1.0E-20;
                    }
                }
            }
            this.xNow += this.h;
            for (i = 0; i < this.nEqns; ++i) {
                this.yNow[i] = y[i];
            }
        }
        return theResult;
    }

    public NMFixedEulerSolver(NMEulerEqns eqns) {
        this.ivodes = eqns;
        this.implicit = true;
        this.treatAsNonNegative = false;
        this.minSigValue = 1.0E-15;
        this.tol = 1.0E-4;
        this.theListener = this;
    }

    public NMResult evalNewtRaphEqns(double[] y, double[] z) {
        String[] eMsg = new String[]{"", "NMFixedEulerSolver.evalNewtRaphEqns: length of vector y not equal to number of equations", "NMFixedEulerSolver.evalNewtRaphEqns: length of vector z not equal to number of equations", "NMFixedEulerSolver.evalNewtRaphEqns: error evaluating the ODEs"};
        NMResult theResult = new NMResult();
        if (y.length != this.nEqns) {
            theResult.setStatus(1, eMsg[1]);
            return theResult;
        }
        if (z.length != this.nEqns) {
            theResult.setStatus(2, eMsg[2]);
            return theResult;
        }
        double x = this.xNow + this.h;
        double[] g = new double[this.nEqns];
        NMResult evalResult = this.ivodes.evalEulerEqns(x, y, g);
        if (evalResult.getStatus() > 0) {
            theResult.setStatus(3, eMsg[3], evalResult);
            return theResult;
        }
        for (int i = 0; i < this.nEqns; ++i) {
            z[i] = this.h * g[i] + this.yNow[i] - y[i];
        }
        return theResult;
    }

    public NMResult evalNewtRaphJac(double[] y, double[][] jac) {
        int i;
        String[] eMsg = new String[]{"", "NMFixedEulerSolver.evalNewtRaphJac: length of vector y not equal to number of equations", "NMFixedEulerSolver.evalNewtRaphJac: Jacobian not square", "NMFixedEulerSolver.evalNewtRaphJac: number of rows in Jacobian not equal to number of unknowns", "NMFixedEulerSolver.evalNewtRaphJac: error evaluating the Jacobian of the ODEs"};
        NMResult theResult = new NMResult();
        if (y.length != this.nEqns) {
            theResult.setStatus(1, eMsg[1]);
            return theResult;
        }
        for (int i2 = 0; i2 < jac.length; ++i2) {
            if (jac.length == jac[i2].length) continue;
            theResult.setStatus(2, eMsg[2]);
            return theResult;
        }
        if (jac.length != this.nEqns) {
            theResult.setStatus(3, eMsg[3]);
            return theResult;
        }
        double[][] gJac = new double[this.nEqns][this.nEqns];
        NMResult jacResult = this.ivodes.evalEulerJac(y, gJac);
        if (jacResult.getStatus() > 0) {
            theResult.setStatus(4, eMsg[4], jacResult);
            return theResult;
        }
        for (i = 0; i < this.nEqns; ++i) {
            for (int j = 0; j < this.nEqns; ++j) {
                jac[i][j] = this.h * gJac[i][j];
            }
        }
        for (i = 0; i < this.nEqns; ++i) {
            jac[i][i] = jac[i][i] - 1.0;
        }
        return theResult;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public void setTreatAsNonNegative(boolean treatAsNonNegative) {
        this.treatAsNonNegative = treatAsNonNegative;
    }

    public double getMinSigValue() {
        return this.minSigValue;
    }

    public void setMinSigValue(double minSigValue) {
        this.minSigValue = minSigValue;
    }

    public double getTol() {
        return this.tol;
    }

    public void setTol(double tol) {
        this.tol = tol;
    }

    public void registerListener(NMFixedEulerListener listener) {
        this.theListener = listener;
    }

    public void unregisterListener() {
        this.theListener = this;
    }

    public void call(int iteration, double indepVar, double[] depVar) {
    }
}

