/*
 * Decompiled with CFR 0.152.
 */
package meohequilibrator;

import chem.Shomate;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import meohequilibrator.MeOHEquilibratorAboutBox;
import meohequilibrator.MeOHEquilibratorApp;
import meohequilibrator.MeOHEquilibratorUserGuide;
import numeth.NMJacEstEqns;
import numeth.NMJacEstimator;
import numeth.NMNewtRaphEqns;
import numeth.NMNewtRaphSolver;
import numeth.NMResult;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.Task;
import org.jdesktop.layout.GroupLayout;

public class MeOHEquilibratorView
extends FrameView {
    private JLabel conversionLabel;
    private JLabel enthalpyLabel;
    private JLabel entropyLabel;
    private JLabel equilConstantLabel;
    private JButton equilibrateButton;
    private JFormattedTextField feedRatioTextField;
    private JLabel freeEnergyLabel;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel18;
    private JMenuItem jMenuItem5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JLabel percentCOLabel;
    private JLabel percentH2Label;
    private JLabel percentMeOHLabel;
    private JFormattedTextField pressureTextField;
    private JFormattedTextField temperatureTextField;
    private JDialog aboutBox;
    private JDialog userGuide;
    private double T;
    private double P;
    private double ratio;
    private double n0CO;
    private double n0H2;
    private Shomate H2;
    private Shomate CO;
    private Shomate MeOH;
    private double percentH2;
    private double percentCO;
    private double percentMeOH;

    public MeOHEquilibratorView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        ResourceMap resourceMap = this.getResourceMap();
        this.T = 400.0;
        this.P = 1.0;
        this.ratio = 1.0;
        this.temperatureTextField.setValue(this.T);
        this.pressureTextField.setValue(this.P);
        this.feedRatioTextField.setValue(this.ratio);
        String[] H2Params = new String[]{"298\t1500\t33.107800\t-11.508000\t11.609300\t-2.844400\t-0.159665\t-9.991971\t172.788000\t0.000000", "1500\t6000\t34.143400\t0.503927\t0.372036\t-0.038599\t-8.074761\t-21.218800\t162.093000\t0.000000"};
        this.H2 = new Shomate(H2Params);
        String[] COParams = new String[]{"298\t1300\t25.567590\t6.096130\t4.054656\t-2.671301\t0.131021\t-118.008900\t227.366500\t-110.527100", "1300\t6000\t35.150700\t1.300095\t-0.205921\t0.013550\t-3.282780\t-127.837500\t231.712000\t-110.527100"};
        this.CO = new Shomate(COParams);
        String[] MeOHParams = new String[]{"298\t6000\t21.138073\t70.878654\t25.853554\t-28.497905\t0.000000\t-210.789702\t243.296143\t-201.171528"};
        this.MeOH = new Shomate(MeOHParams);
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = MeOHEquilibratorApp.getApplication().getMainFrame();
            this.aboutBox = new MeOHEquilibratorAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        MeOHEquilibratorApp.getApplication().show(this.aboutBox);
    }

    @Action
    public void showUserGuide() {
        if (this.userGuide == null) {
            JFrame mainFrame = MeOHEquilibratorApp.getApplication().getMainFrame();
            this.userGuide = new MeOHEquilibratorUserGuide(mainFrame);
            this.userGuide.setLocationRelativeTo(mainFrame);
        }
        MeOHEquilibratorApp.getApplication().show(this.userGuide);
    }

    @Action
    public Task equilibrate() {
        return new EquilibrateTask(this.getApplication());
    }

    public void clearResults() {
        this.enthalpyLabel.setText("");
        this.entropyLabel.setText("");
        this.freeEnergyLabel.setText("");
        this.equilConstantLabel.setText("");
        this.percentCOLabel.setText("");
        this.percentH2Label.setText("");
        this.percentCOLabel.setText("");
        this.percentMeOHLabel.setText("");
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.feedRatioTextField = new JFormattedTextField();
        this.pressureTextField = new JFormattedTextField();
        this.temperatureTextField = new JFormattedTextField();
        this.equilibrateButton = new JButton();
        this.jLabel14 = new JLabel();
        this.jPanel2 = new JPanel();
        this.enthalpyLabel = new JLabel();
        this.entropyLabel = new JLabel();
        this.freeEnergyLabel = new JLabel();
        this.equilConstantLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel18 = new JLabel();
        this.percentCOLabel = new JLabel();
        this.percentH2Label = new JLabel();
        this.percentMeOHLabel = new JLabel();
        this.conversionLabel = new JLabel();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.mainPanel.setName("mainPanel");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Initial Conditions"));
        this.jPanel1.setName("jPanel1");
        this.jLabel11.setHorizontalAlignment(2);
        ResourceMap resourceMap = Application.getInstance(MeOHEquilibratorApp.class).getContext().getResourceMap(MeOHEquilibratorView.class);
        this.jLabel11.setText(resourceMap.getString("jLabel11.text", new Object[0]));
        this.jLabel11.setName("jLabel11");
        this.jLabel12.setHorizontalAlignment(2);
        this.jLabel12.setText(resourceMap.getString("jLabel12.text", new Object[0]));
        this.jLabel12.setName("jLabel12");
        this.jLabel13.setHorizontalAlignment(2);
        this.jLabel13.setText(resourceMap.getString("jLabel13.text", new Object[0]));
        this.jLabel13.setName("jLabel13");
        this.feedRatioTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter()));
        this.feedRatioTextField.setName("feedRatioTextField");
        this.feedRatioTextField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MeOHEquilibratorView.this.newInitialFeedRatio(evt);
            }
        });
        this.pressureTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.pressureTextField.setName("pressureTextField");
        this.pressureTextField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MeOHEquilibratorView.this.newInitialPressure(evt);
            }
        });
        this.temperatureTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.temperatureTextField.setName("temperatureTextField");
        this.temperatureTextField.setFocusLostBehavior(1);
        this.temperatureTextField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MeOHEquilibratorView.this.newInitialTemperature(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel12).addPreferredGap(0).add((Component)this.pressureTextField, -1, 98, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel13).addPreferredGap(0).add((Component)this.feedRatioTextField, -1, 98, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel11).addPreferredGap(0, 27, Short.MAX_VALUE).add((Component)this.temperatureTextField, -2, 71, -2))).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.jLabel12, this.jLabel13}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel11).add((Component)this.temperatureTextField, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel12).add((Component)this.pressureTextField, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel13).add((Component)this.feedRatioTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        ApplicationActionMap actionMap = Application.getInstance(MeOHEquilibratorApp.class).getContext().getActionMap(MeOHEquilibratorView.class, this);
        this.equilibrateButton.setAction(actionMap.get("equilibrate"));
        this.equilibrateButton.setName("equilibrateButton");
        this.jLabel14.setHorizontalAlignment(0);
        this.jLabel14.setText(resourceMap.getString("jLabel14.text", new Object[0]));
        this.jLabel14.setName("jLabel14");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel2.border.title", new Object[0])));
        this.jPanel2.setName("jPanel2");
        this.enthalpyLabel.setHorizontalAlignment(0);
        this.enthalpyLabel.setText(resourceMap.getString("enthalpyLabel.text", new Object[0]));
        this.enthalpyLabel.setName("enthalpyLabel");
        this.entropyLabel.setHorizontalAlignment(0);
        this.entropyLabel.setText(resourceMap.getString("entropyLabel.text", new Object[0]));
        this.entropyLabel.setName("entropyLabel");
        this.freeEnergyLabel.setHorizontalAlignment(0);
        this.freeEnergyLabel.setText(resourceMap.getString("freeEnergyLabel.text", new Object[0]));
        this.freeEnergyLabel.setName("freeEnergyLabel");
        this.equilConstantLabel.setHorizontalAlignment(0);
        this.equilConstantLabel.setText(resourceMap.getString("equilConstantLabel.text", new Object[0]));
        this.equilConstantLabel.setName("equilConstantLabel");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.enthalpyLabel, -1, 205, Short.MAX_VALUE).add(2, (Component)this.entropyLabel, -1, 205, Short.MAX_VALUE).add(2, (Component)this.freeEnergyLabel, -1, 205, Short.MAX_VALUE).add((Component)this.equilConstantLabel, -1, 205, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.enthalpyLabel).add(18, 18, 18).add((Component)this.entropyLabel).add(18, 18, 18).add((Component)this.freeEnergyLabel).addPreferredGap(0, 20, Short.MAX_VALUE).add((Component)this.equilConstantLabel).addContainerGap()));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Equilibrium Mole Percent"));
        this.jPanel3.setName("jPanel3");
        this.jLabel15.setText(resourceMap.getString("jLabel15.text", new Object[0]));
        this.jLabel15.setName("jLabel15");
        this.jLabel16.setText(resourceMap.getString("jLabel16.text", new Object[0]));
        this.jLabel16.setName("jLabel16");
        this.jLabel18.setText(resourceMap.getString("jLabel18.text", new Object[0]));
        this.jLabel18.setName("jLabel18");
        this.percentCOLabel.setHorizontalAlignment(2);
        this.percentCOLabel.setText(resourceMap.getString("percentCOLabel.text", new Object[0]));
        this.percentCOLabel.setHorizontalTextPosition(2);
        this.percentCOLabel.setName("percentCOLabel");
        this.percentH2Label.setHorizontalAlignment(2);
        this.percentH2Label.setText(resourceMap.getString("percentH2Label.text", new Object[0]));
        this.percentH2Label.setHorizontalTextPosition(2);
        this.percentH2Label.setName("percentH2Label");
        this.percentMeOHLabel.setHorizontalAlignment(2);
        this.percentMeOHLabel.setText(resourceMap.getString("percentMeOHLabel.text", new Object[0]));
        this.percentMeOHLabel.setHorizontalTextPosition(2);
        this.percentMeOHLabel.setName("percentMeOHLabel");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel15).addPreferredGap(0).add((Component)this.percentCOLabel, -1, 134, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel16).addPreferredGap(0).add((Component)this.percentH2Label, -1, 136, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel18).add(18, 18, 18).add((Component)this.percentMeOHLabel, -1, 97, Short.MAX_VALUE))).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel15).add((Component)this.percentCOLabel)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel16).add((Component)this.percentH2Label)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel18).add((Component)this.percentMeOHLabel)).add(20, 20, 20)));
        this.conversionLabel.setText(resourceMap.getString("conversionLabel.text", new Object[0]));
        this.conversionLabel.setName("conversionLabel");
        GroupLayout mainPanelLayout = new GroupLayout((Container)this.mainPanel);
        this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
        mainPanelLayout.setHorizontalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((Component)this.jPanel1, -2, -1, -2).add((Component)this.equilibrateButton, -1, 233, Short.MAX_VALUE).add((Component)this.jLabel14, -1, 233, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(2, false).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE))).add((Component)this.conversionLabel, -1, 459, Short.MAX_VALUE)).addContainerGap()));
        mainPanelLayout.setVerticalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0))).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add(24, 24, 24).add((Component)this.equilibrateButton).add(18, 18, 18).add((Component)this.jLabel14)).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().addPreferredGap(1).add((Component)this.jPanel3, -2, -1, -2))).addPreferredGap(0).add((Component)this.conversionLabel).addContainerGap()));
        this.jPanel2.getAccessibleContext().setAccessibleName(resourceMap.getString("jPanel2.AccessibleContext.accessibleName", new Object[0]));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.jMenuItem5.setAction(actionMap.get("showUserGuide"));
        this.jMenuItem5.setName("jMenuItem5");
        helpMenu.add(this.jMenuItem5);
        this.menuBar.add(helpMenu);
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
    }

    private void newInitialTemperature(PropertyChangeEvent evt) {
        double newTemperature = ((Number)this.temperatureTextField.getValue()).doubleValue();
        if (newTemperature != this.T) {
            this.clearResults();
            this.T = newTemperature < 298.0 ? 298.0 : (newTemperature > 1200.0 ? 1200.0 : newTemperature);
            this.temperatureTextField.setValue(new Double(this.T));
        }
    }

    private void newInitialPressure(PropertyChangeEvent evt) {
        double newPressure = ((Number)this.pressureTextField.getValue()).doubleValue();
        if (newPressure != this.P) {
            this.clearResults();
            this.P = newPressure < 1.0 ? 1.0 : (newPressure > 100.0 ? 100.0 : newPressure);
            this.pressureTextField.setValue(new Double(this.P));
        }
    }

    private void newInitialFeedRatio(PropertyChangeEvent evt) {
        double newFeedRatio = ((Number)this.feedRatioTextField.getValue()).doubleValue();
        if (newFeedRatio != this.ratio) {
            this.clearResults();
            this.ratio = newFeedRatio < 0.01 ? 0.01 : (newFeedRatio > 100.0 ? 100.0 : newFeedRatio);
            this.feedRatioTextField.setValue(new Double(this.ratio));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EquilibrateTask
    extends Task<Object, Void>
    implements NMNewtRaphEqns,
    NMJacEstEqns {
        double temperature;
        double pressure;
        double feedRatio;
        double conversion;
        double sRxn;
        double hRxn;
        double gRxn;
        double K;
        double[] x;
        double[] y;

        EquilibrateTask(Application app) {
            super(app);
            this.temperature = ((Number)MeOHEquilibratorView.this.temperatureTextField.getValue()).doubleValue();
            this.pressure = ((Number)MeOHEquilibratorView.this.pressureTextField.getValue()).doubleValue();
            this.feedRatio = ((Number)MeOHEquilibratorView.this.feedRatioTextField.getValue()).doubleValue();
            MeOHEquilibratorView.this.equilibrateButton.setEnabled(false);
        }

        @Override
        protected Object doInBackground() {
            MeOHEquilibratorView.this.n0H2 = 1.0;
            MeOHEquilibratorView.this.n0CO = this.feedRatio;
            double sH2 = MeOHEquilibratorView.this.H2.sStd(this.temperature).getDoubleValue();
            double sCO = MeOHEquilibratorView.this.CO.sStd(this.temperature).getDoubleValue();
            double sMeOH = MeOHEquilibratorView.this.MeOH.sStd(this.temperature).getDoubleValue();
            double hH2 = MeOHEquilibratorView.this.H2.hForm(this.temperature).getDoubleValue();
            double hCO = MeOHEquilibratorView.this.CO.hForm(this.temperature).getDoubleValue();
            double hMeOH = MeOHEquilibratorView.this.MeOH.hForm(this.temperature).getDoubleValue();
            double gH2 = MeOHEquilibratorView.this.H2.gForm(this.temperature).getDoubleValue();
            double gCO = MeOHEquilibratorView.this.CO.gForm(this.temperature).getDoubleValue();
            double gMeOH = MeOHEquilibratorView.this.MeOH.gForm(this.temperature).getDoubleValue();
            this.sRxn = sMeOH - sCO - 2.0 * sH2;
            this.hRxn = hMeOH - hCO - 2.0 * hH2;
            this.gRxn = gMeOH - gCO - 2.0 * gH2;
            this.K = Math.exp(-this.gRxn * 1000.0 / 8.3144 / this.temperature);
            this.x = new double[3];
            this.y = new double[3];
            this.x[0] = MeOHEquilibratorView.this.n0CO;
            this.x[1] = MeOHEquilibratorView.this.n0H2;
            this.x[2] = 0.0;
            NMNewtRaphSolver theSolver = new NMNewtRaphSolver((NMNewtRaphEqns)this);
            theSolver.setTol(1.0E-4);
            theSolver.setTreatAsNonNegative(true);
            NMResult theResult = theSolver.solve(this.x, this.y);
            MeOHEquilibratorView.this.percentCO = 100.0 * this.x[0] / (this.x[0] + this.x[1] + this.x[2]);
            MeOHEquilibratorView.this.percentH2 = 100.0 * this.x[1] / (this.x[0] + this.x[1] + this.x[2]);
            MeOHEquilibratorView.this.percentMeOH = 100.0 * this.x[2] / (this.x[0] + this.x[1] + this.x[2]);
            this.conversion = this.feedRatio <= 0.5 ? 100.0 * (MeOHEquilibratorView.this.n0CO - this.x[0]) / MeOHEquilibratorView.this.n0CO : 100.0 * (MeOHEquilibratorView.this.n0H2 - this.x[1]) / MeOHEquilibratorView.this.n0H2;
            return null;
        }

        @Override
        protected void succeeded(Object result) {
            DecimalFormat noDecimal = new DecimalFormat("####");
            DecimalFormat threeSigFigs = new DecimalFormat("0.00E00");
            DecimalFormat notScientific = new DecimalFormat("##0.00");
            String txt = "<html>&#916;S(" + noDecimal.format(this.temperature);
            txt = txt + ") = ";
            txt = Math.abs(this.sRxn) < 0.1 ? txt + threeSigFigs.format(this.sRxn) + " J/(mol K)" : txt + notScientific.format(this.sRxn) + " J/(mol K)";
            MeOHEquilibratorView.this.entropyLabel.setText(txt);
            txt = "<html>&#916;H(" + noDecimal.format(this.temperature);
            txt = txt + ") = ";
            txt = Math.abs(this.hRxn) < 0.1 ? txt + threeSigFigs.format(this.hRxn) + " kJ/mol" : txt + notScientific.format(this.hRxn) + " kJ/mol";
            MeOHEquilibratorView.this.enthalpyLabel.setText(txt);
            txt = "<html>&#916;G(" + noDecimal.format(this.temperature);
            txt = txt + ") = ";
            txt = Math.abs(this.gRxn) < 0.1 ? txt + threeSigFigs.format(this.gRxn) + " kJ/mol" : txt + notScientific.format(this.gRxn) + " kJ/mol";
            MeOHEquilibratorView.this.freeEnergyLabel.setText(txt);
            txt = "<html>K(" + noDecimal.format(this.temperature);
            txt = txt + ") = " + threeSigFigs.format(this.K);
            MeOHEquilibratorView.this.equilConstantLabel.setText(txt);
            txt = MeOHEquilibratorView.this.percentCO < 0.1 ? threeSigFigs.format(MeOHEquilibratorView.this.percentCO) : notScientific.format(MeOHEquilibratorView.this.percentCO);
            txt = txt + " %";
            MeOHEquilibratorView.this.percentCOLabel.setText(txt);
            txt = MeOHEquilibratorView.this.percentH2 < 0.1 ? threeSigFigs.format(MeOHEquilibratorView.this.percentH2) : notScientific.format(MeOHEquilibratorView.this.percentH2);
            txt = txt + " %";
            MeOHEquilibratorView.this.percentH2Label.setText(txt);
            txt = MeOHEquilibratorView.this.percentMeOH < 0.1 ? threeSigFigs.format(MeOHEquilibratorView.this.percentMeOH) : notScientific.format(MeOHEquilibratorView.this.percentMeOH);
            txt = txt + " %";
            MeOHEquilibratorView.this.percentMeOHLabel.setText(txt);
            MeOHEquilibratorView.this.equilibrateButton.setEnabled(true);
            txt = "<html>Limiting Reagent ";
            if (this.feedRatio < 0.5) {
                txt = txt + "(CO) ";
            }
            if (this.feedRatio > 0.5) {
                txt = txt + "(H<sub>2</sub>) ";
            }
            txt = txt + "Conversion is ";
            txt = this.conversion < 0.1 ? txt + threeSigFigs.format(this.conversion) : txt + notScientific.format(this.conversion);
            txt = txt + " %";
            MeOHEquilibratorView.this.conversionLabel.setText(txt);
            MeOHEquilibratorView.this.equilibrateButton.setEnabled(true);
        }

        public NMResult evalNewtRaphEqns(double[] x, double[] y) {
            NMResult theResult = new NMResult();
            y[0] = this.K * x[0] * x[1] * x[1] * this.pressure * this.pressure - x[2] * (x[0] + x[1] + x[2]) * (x[0] + x[1] + x[2]);
            y[1] = MeOHEquilibratorView.this.n0CO - x[2] - x[0];
            y[2] = 2.0 * MeOHEquilibratorView.this.n0H2 - 2.0 * x[1] - 4.0 * x[2];
            return theResult;
        }

        public NMResult evalNewtRaphJac(double[] x, double[][] jac) {
            NMJacEstimator jacEstimator = new NMJacEstimator((NMJacEstEqns)this);
            NMResult theResult = new NMResult();
            jacEstimator.estimate(3, x, jac, 1.0E-4);
            return theResult;
        }

        public NMResult evalJacEstEqns(double[] x, double[] y) {
            NMResult theResult = this.evalNewtRaphEqns(x, y);
            return theResult;
        }
    }
}

