/*
 * Decompiled with CFR 0.152.
 */
package numeth;

import numeth.NMJacEstEqns;
import numeth.NMResult;

public class NMJacEstimator {
    private NMJacEstEqns eqnSet;

    public NMResult estimate(int nEqns, double[] x, double[][] jac, double relErr) {
        String[] eMsg = new String[]{"", "NMJacEstimator.estimate: number of rows in the jacobian matrix not equal to number of equations", "NMJacEstimator.estimate: number of columns in the jacobian matrix not equal to length of x vector", "NMJacEstimator.estimate: error estimating derivative", "NMJacEstimator.estimate: specified relative error was not realized"};
        NMResult theResult = new NMResult();
        if (nEqns != jac.length) {
            theResult.setStatus(1, eMsg[1]);
            return theResult;
        }
        for (int i = 0; i < jac.length; ++i) {
            if (x.length == jac[i].length) continue;
            theResult.setStatus(2, eMsg[2]);
            return theResult;
        }
        boolean wasLowAccy = false;
        double[] y = new double[nEqns];
        for (int i = 0; i < nEqns; ++i) {
            for (int j = 0; j < x.length; ++j) {
                double xSave = x[j];
                double relChg = 10.0 * relErr;
                double est = 0.0;
                double bestEst = 0.0;
                NMResult resultA = new NMResult();
                NMResult resultB = new NMResult();
                for (int nIter = 0; nIter < 10 && relChg > relErr; ++nIter) {
                    double x2;
                    double x1;
                    if (xSave == 0.0) {
                        x1 = relErr / Math.pow(2.0, nIter);
                        x2 = -x1;
                    } else {
                        x1 = xSave * (1.0 + relErr / Math.pow(2.0, nIter));
                        x2 = xSave * (1.0 - relErr / Math.pow(2.0, nIter));
                    }
                    x[j] = x1;
                    resultA = this.eqnSet.evalJacEstEqns(x, y);
                    double y1 = y[i];
                    x[j] = x2;
                    resultB = this.eqnSet.evalJacEstEqns(x, y);
                    double y2 = y[i];
                    bestEst = (y2 - y1) / (x2 - x1);
                    if (bestEst == 0.0) break;
                    if (nIter > 0) {
                        relChg = Math.abs(bestEst - est) / Math.abs(bestEst);
                    }
                    est = bestEst;
                }
                if (resultA.getStatus() > 0) {
                    theResult.setStatus(3, eMsg[3], resultA);
                    return theResult;
                }
                if (resultB.getStatus() > 0) {
                    theResult.setStatus(3, eMsg[3], resultB);
                    return theResult;
                }
                x[j] = xSave;
                jac[i][j] = bestEst;
                if (bestEst == 0.0 || !(relChg > relErr)) continue;
                wasLowAccy = true;
            }
        }
        if (wasLowAccy) {
            theResult.setStatus(4, eMsg[4]);
        }
        return theResult;
    }

    public NMJacEstimator(NMJacEstEqns set) {
        this.eqnSet = set;
    }
}

