/*
 * Decompiled with CFR 0.152.
 */
package chem;

import clutils.IOUtils;
import java.io.BufferedReader;
import java.text.DecimalFormat;
import numeth.NMResult;

public class Shomate {
    public int nParamSets;
    public double[] Tmin;
    public double[] Tmax;
    public double[] a;
    public double[] b;
    public double[] c;
    public double[] d;
    public double[] e;
    public double[] f;
    public double[] g;
    public double[] h;
    DecimalFormat myformat = new DecimalFormat("0.00000E00");

    public NMResult heatCap(double T) {
        String[] eMsg = new String[]{"", "Shomate.heatCap: extrapolated outside specified parameter range"};
        NMResult theResult = new NMResult();
        double tr = T / 1000.0;
        int ii = this.pickParamSet(T);
        if (ii < 0) {
            ii = -ii;
            theResult.setStatus(1, eMsg[1]);
        }
        double hCap = this.a[--ii] + this.b[ii] * tr + this.c[ii] * tr * tr + this.d[ii] * tr * tr * tr + this.e[ii] / tr / tr;
        theResult.setDoubleValue(hCap);
        return theResult;
    }

    public NMResult hRel(double T) {
        String[] eMsg = new String[]{"", "Shomate.hRel: extrapolated outside specified parameter range"};
        NMResult theResult = new NMResult();
        double tr = T / 1000.0;
        int ii = this.pickParamSet(T);
        if (ii < 0) {
            ii = -ii;
            theResult.setStatus(1, eMsg[1]);
        }
        double hRel = this.a[--ii] * tr + this.b[ii] * tr * tr / 2.0 + this.c[ii] * tr * tr * tr / 3.0 + this.d[ii] * tr * tr * tr * tr / 4.0 - this.e[ii] / tr + this.f[ii] - this.h[ii];
        theResult.setDoubleValue(hRel);
        return theResult;
    }

    public NMResult hForm(double T) {
        String[] eMsg = new String[]{"", "Shomate.hForm: extrapolated outside specified parameter range"};
        NMResult theResult = new NMResult();
        double tr = T / 1000.0;
        int ii = this.pickParamSet(T);
        if (ii < 0) {
            ii = -ii;
            theResult.setStatus(1, eMsg[1]);
        }
        double hf = this.a[--ii] * tr + this.b[ii] * tr * tr / 2.0 + this.c[ii] * tr * tr * tr / 3.0 + this.d[ii] * tr * tr * tr * tr / 4.0 - this.e[ii] / tr + this.f[ii];
        theResult.setDoubleValue(hf);
        return theResult;
    }

    public NMResult sStd(double T) {
        String[] eMsg = new String[]{"", "Shomate.sStd: extrapolated outside specified parameter range"};
        NMResult theResult = new NMResult();
        double tr = T / 1000.0;
        int ii = this.pickParamSet(T);
        if (ii < 0) {
            ii = -ii;
            theResult.setStatus(1, eMsg[1]);
        }
        double entropy = this.a[--ii] * Math.log(tr) + this.b[ii] * tr + this.c[ii] * tr * tr / 2.0 + this.d[ii] * tr * tr * tr / 3.0 - this.e[ii] / tr / tr / 2.0 + this.g[ii];
        theResult.setDoubleValue(entropy);
        return theResult;
    }

    public NMResult gForm(double T) {
        String[] eMsg = new String[]{"", "Shomate.gForm: extrapolated outside specified parameter range"};
        NMResult gResult = new NMResult();
        NMResult theResult = this.hForm(T);
        if (theResult.getStatus() > 0) {
            gResult.setStatus(1, eMsg[1], theResult);
        }
        gResult.setDoubleValue(theResult.getDoubleValue());
        theResult = this.sStd(T);
        if (theResult.getStatus() > 0) {
            gResult.setStatus(1, eMsg[1], theResult);
        }
        double gg = gResult.getDoubleValue() - T * theResult.getDoubleValue() / 1000.0;
        gResult.setDoubleValue(gg);
        return gResult;
    }

    int pickParamSet(double T) {
        int i;
        if (T < this.Tmin[0]) {
            return -1;
        }
        for (i = 0; i < this.nParamSets; ++i) {
            if (!(T >= this.Tmin[i]) || !(T <= this.Tmax[i])) continue;
            return i + 1;
        }
        for (i = this.nParamSets - 1; i >= 0; --i) {
            if (!(T >= this.Tmax[i])) continue;
            return -(i + 1);
        }
        return 0;
    }

    void allocateSets() {
        this.Tmin = new double[this.nParamSets];
        this.Tmax = new double[this.nParamSets];
        this.a = new double[this.nParamSets];
        this.b = new double[this.nParamSets];
        this.c = new double[this.nParamSets];
        this.d = new double[this.nParamSets];
        this.e = new double[this.nParamSets];
        this.f = new double[this.nParamSets];
        this.g = new double[this.nParamSets];
        this.h = new double[this.nParamSets];
    }

    void orderSets() {
        for (int nextSet = 0; nextSet < this.nParamSets - 2; ++nextSet) {
            int minSet = nextSet;
            double minT = this.Tmin[nextSet];
            for (int i = nextSet + 1; i < this.nParamSets; ++i) {
                if (!(this.Tmin[i] < minT)) continue;
                minSet = i;
                minT = this.Tmin[i];
            }
            if (minSet == nextSet) continue;
            this.swapSets(minSet, nextSet);
        }
    }

    void swapSets(int i, int j) {
        double tmp = this.Tmin[i];
        this.Tmin[i] = this.Tmin[j];
        this.Tmin[j] = tmp;
        tmp = this.Tmax[i];
        this.Tmax[i] = this.Tmax[j];
        this.Tmax[j] = tmp;
        tmp = this.a[i];
        this.a[i] = this.a[j];
        this.a[j] = tmp;
        tmp = this.b[i];
        this.b[i] = this.b[j];
        this.b[j] = tmp;
        tmp = this.c[i];
        this.c[i] = this.c[j];
        this.c[j] = tmp;
        tmp = this.d[i];
        this.d[i] = this.d[j];
        this.d[j] = tmp;
        tmp = this.e[i];
        this.e[i] = this.e[j];
        this.e[j] = tmp;
        tmp = this.f[i];
        this.f[i] = this.f[j];
        this.f[j] = tmp;
        tmp = this.g[i];
        this.g[i] = this.g[j];
        this.g[j] = tmp;
        tmp = this.h[i];
        this.h[i] = this.h[j];
        this.h[j] = tmp;
    }

    public String writeShomate() {
        String txt = Integer.toString(this.nParamSets) + "\n";
        for (int i = 0; i < this.nParamSets; ++i) {
            txt = txt + this.myformat.format(this.Tmin[i]) + " ";
            txt = txt + this.myformat.format(this.Tmax[i]) + " ";
            txt = txt + this.myformat.format(this.a[i]) + " ";
            txt = txt + this.myformat.format(this.b[i]) + " ";
            txt = txt + this.myformat.format(this.c[i]) + " ";
            txt = txt + this.myformat.format(this.d[i]) + " ";
            txt = txt + this.myformat.format(this.e[i]) + " ";
            txt = txt + this.myformat.format(this.f[i]) + " ";
            txt = txt + this.myformat.format(this.g[i]) + " ";
            txt = txt + this.myformat.format(this.h[i]) + "\n";
        }
        return txt;
    }

    public Shomate(String[] set) {
        this.nParamSets = set.length;
        this.allocateSets();
        for (int i = 0; i < this.nParamSets; ++i) {
            set[i] = set[i].trim();
            String[] lineItem = set[i].split("\\s+");
            this.Tmin[i] = Double.parseDouble(lineItem[0]);
            this.Tmax[i] = Double.parseDouble(lineItem[1]);
            this.a[i] = Double.parseDouble(lineItem[2]);
            this.b[i] = Double.parseDouble(lineItem[3]);
            this.c[i] = Double.parseDouble(lineItem[4]);
            this.d[i] = Double.parseDouble(lineItem[5]);
            this.e[i] = Double.parseDouble(lineItem[6]);
            this.f[i] = Double.parseDouble(lineItem[7]);
            this.g[i] = Double.parseDouble(lineItem[8]);
            this.h[i] = Double.parseDouble(lineItem[9]);
        }
        this.orderSets();
    }

    public Shomate(BufferedReader infile) {
        String[] lineItem = IOUtils.getInputLineItems((BufferedReader)infile);
        this.nParamSets = Integer.parseInt(lineItem[0]);
        this.allocateSets();
        for (int i = 0; i < this.nParamSets; ++i) {
            lineItem = IOUtils.getInputLineItems((BufferedReader)infile);
            this.Tmin[i] = Double.parseDouble(lineItem[0]);
            this.Tmax[i] = Double.parseDouble(lineItem[1]);
            this.a[i] = Double.parseDouble(lineItem[2]);
            this.b[i] = Double.parseDouble(lineItem[3]);
            this.c[i] = Double.parseDouble(lineItem[4]);
            this.d[i] = Double.parseDouble(lineItem[5]);
            this.e[i] = Double.parseDouble(lineItem[6]);
            this.f[i] = Double.parseDouble(lineItem[7]);
            this.g[i] = Double.parseDouble(lineItem[8]);
            this.h[i] = Double.parseDouble(lineItem[9]);
        }
        this.orderSets();
    }
}

