/*
 * Decompiled with CFR 0.152.
 */
package numeth;

import numeth.NMAdjustEulerListener;
import numeth.NMEulerEqns;
import numeth.NMFixedEulerSolver;
import numeth.NMResult;

public class NMAdjustEulerSolver
implements NMAdjustEulerListener {
    private NMEulerEqns ivodes;
    private boolean treatAsNonNegative;
    private double minSigValue;
    private double tol;
    private int nEqns;
    private double h;
    private double xNow;
    private double[] yFull;
    private double[] yHalves;
    private NMAdjustEulerListener theListener;
    private double callAboveIncrement;
    private int callIntervals;

    public NMResult integrate(double x0, double xf, double[] y, double minStep) {
        String[] eMsg = new String[]{"", "NMAdjustEulerSolver.integrate: Error evaluating ODEs", "NMAdjustEulerSolver.integrate: Implicit Euler step did not converge", "NMAdjustEulerSolver.integrate: Step size limited to specified minimum"};
        NMResult theResult = new NMResult();
        this.nEqns = y.length;
        this.h = (xf - x0) / 100.0;
        this.yFull = new double[this.nEqns];
        this.yHalves = new double[this.nEqns];
        boolean xIncreasing = this.h > 0.0;
        double callAbove = x0;
        this.callAboveIncrement = (xf - x0) / (double)this.callIntervals;
        this.xNow = x0;
        for (int i = 0; i < this.nEqns; ++i) {
            this.yFull[i] = y[i];
            this.yHalves[i] = y[i];
        }
        boolean doneIntegrating = false;
        NMFixedEulerSolver theSolver = new NMFixedEulerSolver(this.ivodes);
        theSolver.setImplicit(true);
        theSolver.setMinSigValue(this.minSigValue);
        theSolver.setTol(this.tol);
        theSolver.setTreatAsNonNegative(this.treatAsNonNegative);
        while (!doneIntegrating) {
            int i;
            if (this.xNow >= callAbove) {
                this.theListener.call(this.xNow, y);
                callAbove += this.callAboveIncrement;
            }
            NMResult fullStepResult = theSolver.integrate(this.xNow, this.xNow + this.h, this.yFull, 1);
            NMResult halfStepsResult = theSolver.integrate(this.xNow, this.xNow + this.h, this.yHalves, 2);
            if (fullStepResult.getStatus() > 0) {
                theResult.setStatus(fullStepResult.getStatus(), fullStepResult.getMessage());
                return theResult;
            }
            if (halfStepsResult.getStatus() > 0) {
                theResult.setStatus(halfStepsResult.getStatus(), halfStepsResult.getMessage());
                return theResult;
            }
            double largestDiff = 0.0;
            for (i = 0; i < this.nEqns; ++i) {
                double diff;
                if (!(Math.abs(this.yFull[i]) > this.minSigValue) || !(Math.abs(this.yHalves[i]) > this.minSigValue) || !((diff = Math.abs((this.yHalves[i] - this.yFull[i]) / this.yHalves[i])) > largestDiff)) continue;
                largestDiff = diff;
            }
            if (largestDiff > 0.001) {
                this.h /= 2.0;
                if (xIncreasing) {
                    if (!(this.h < minStep)) continue;
                    theResult.setStatus(3, eMsg[3]);
                    this.h = minStep;
                    continue;
                }
                if (!(this.h > minStep)) continue;
                theResult.setStatus(3, eMsg[3]);
                this.h = minStep;
                continue;
            }
            if (xIncreasing && this.xNow + this.h >= xf || !xIncreasing && this.xNow + this.h <= xf) {
                double factor = (xf - this.xNow) / this.h;
                for (int i2 = 0; i2 < this.nEqns; ++i2) {
                    y[i2] = factor * (this.yHalves[i2] - y[i2]);
                }
                doneIntegrating = true;
                continue;
            }
            this.xNow += this.h;
            for (i = 0; i < this.nEqns; ++i) {
                y[i] = this.yHalves[i];
                this.yFull[i] = this.yHalves[i];
            }
            if (!(largestDiff < 1.0E-4)) continue;
            this.h = 2.0 * this.h;
        }
        return theResult;
    }

    public NMAdjustEulerSolver(NMEulerEqns theEqns) {
        this.ivodes = theEqns;
        this.treatAsNonNegative = false;
        this.minSigValue = 1.0E-15;
        this.tol = 1.0E-4;
        this.theListener = this;
        this.callIntervals = 1;
    }

    public double getMinSigValue() {
        return this.minSigValue;
    }

    public void setMinSigValue(double minSigValue) {
        this.minSigValue = minSigValue;
    }

    public double getTol() {
        return this.tol;
    }

    public void setTol(double tol) {
        this.tol = tol;
    }

    public void setTreatAsNonNegative(boolean treatAsNonNegative) {
        this.treatAsNonNegative = treatAsNonNegative;
    }

    public void registerListener(NMAdjustEulerListener listener) {
        this.theListener = listener;
    }

    public void unregisterListener() {
        this.theListener = this;
    }

    public void call(double indepVar, double[] depVar) {
    }

    public int getCallIntervals() {
        return this.callIntervals;
    }

    public void setCallIntervals(int callIntervals) {
        this.callIntervals = callIntervals;
    }
}

