/*
 * Decompiled with CFR 0.152.
 */
package meclequilibrator;

import chem.Shomate;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import meclequilibrator.MeClEquilibratorAboutBox;
import meclequilibrator.MeClEquilibratorApp;
import meclequilibrator.MeClEquilibratorUserGuide;
import numeth.NMJacEstEqns;
import numeth.NMJacEstimator;
import numeth.NMNewtRaphEqns;
import numeth.NMNewtRaphSolver;
import numeth.NMResult;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.layout.GroupLayout;

public class MeClEquilibratorView
extends FrameView {
    private JLabel conversionLabel;
    private JLabel enthalpyLabel;
    private JLabel entropyLabel;
    private JLabel equilConstantLabel;
    private JButton equilibrateButton;
    private JFormattedTextField feedRatioTextField;
    private JLabel freeEnergyLabel;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JMenuItem jMenuItem5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JLabel percentCH3ClLabel;
    private JLabel percentCH3OHLabel;
    private JLabel percentH2OLabel;
    private JLabel percentHClLabel;
    private JFormattedTextField pressureTextField;
    private JProgressBar progressBar;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JFormattedTextField temperatureTextField;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;
    private JDialog userGuide;
    private double T;
    private double P;
    private double ratio;
    private double n0CH3OH;
    private double n0HCl;
    private Shomate CH3Cl;
    private Shomate H2O;
    private Shomate HCl;
    private Shomate CH3OH;
    private double percentCH3Cl;
    private double percentH2O;
    private double percentHCl;
    private double percentCH3OH;

    public MeClEquilibratorView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MeClEquilibratorView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MeClEquilibratorView.this.busyIconIndex = (MeClEquilibratorView.this.busyIconIndex + 1) % MeClEquilibratorView.this.busyIcons.length;
                MeClEquilibratorView.this.statusAnimationLabel.setIcon(MeClEquilibratorView.this.busyIcons[MeClEquilibratorView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!MeClEquilibratorView.this.busyIconTimer.isRunning()) {
                        MeClEquilibratorView.this.statusAnimationLabel.setIcon(MeClEquilibratorView.this.busyIcons[0]);
                        MeClEquilibratorView.this.busyIconIndex = 0;
                        MeClEquilibratorView.this.busyIconTimer.start();
                    }
                    MeClEquilibratorView.this.progressBar.setVisible(true);
                    MeClEquilibratorView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    MeClEquilibratorView.this.busyIconTimer.stop();
                    MeClEquilibratorView.this.statusAnimationLabel.setIcon(MeClEquilibratorView.this.idleIcon);
                    MeClEquilibratorView.this.progressBar.setVisible(false);
                    MeClEquilibratorView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    MeClEquilibratorView.this.statusMessageLabel.setText(text == null ? "" : text);
                    MeClEquilibratorView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    MeClEquilibratorView.this.progressBar.setVisible(true);
                    MeClEquilibratorView.this.progressBar.setIndeterminate(false);
                    MeClEquilibratorView.this.progressBar.setValue(value);
                }
            }
        });
        this.T = 400.0;
        this.P = 1.0;
        this.ratio = 1.0;
        this.temperatureTextField.setValue(this.T);
        this.pressureTextField.setValue(this.P);
        this.feedRatioTextField.setValue(this.ratio);
        String[] CH3ClParams = new String[]{"298\t1200\t3.524690\t136.927700\t-82.141960\t20.227970\t0.278032\t-89.199950\t202.839100\t-83.680000", "1200\t6000\t88.666910\t10.068340\t-1.928737\t0.128191\t-19.768400\t-152.531100\t286.401500\t-83.680000"};
        this.CH3Cl = new Shomate(CH3ClParams);
        String[] H2OParams = new String[]{"500\t1700\t30.092000\t6.832514\t6.793435\t-2.534480\t0.082139\t-250.881000\t223.396700\t-241.826400", "1700\t6000\t41.964260\t8.622053\t-1.499780\t0.098119\t-11.157640\t-272.179700\t219.780900\t-241.826400"};
        this.H2O = new Shomate(H2OParams);
        String[] HClParams = new String[]{"298\t1200\t32.123920\t-13.458050\t19.868520\t-6.853936\t-0.049672\t-101.620600\t228.686600\t-92.312010", "1200\t6000\t31.919230\t3.203184\t-0.541539\t0.035925\t-3.438525\t-108.015000\t218.276800\t-92.312010"};
        this.HCl = new Shomate(HClParams);
        String[] CH3OHParams = new String[]{"298\t6000\t21.138073\t70.878654\t25.853554\t-28.497905\t0.000000\t-210.789702\t243.296143\t-201.171528"};
        this.CH3OH = new Shomate(CH3OHParams);
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = MeClEquilibratorApp.getApplication().getMainFrame();
            this.aboutBox = new MeClEquilibratorAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        MeClEquilibratorApp.getApplication().show(this.aboutBox);
    }

    @Action
    public void showUserGuide() {
        if (this.userGuide == null) {
            JFrame mainFrame = MeClEquilibratorApp.getApplication().getMainFrame();
            this.userGuide = new MeClEquilibratorUserGuide(mainFrame);
            this.userGuide.setLocationRelativeTo(mainFrame);
        }
        MeClEquilibratorApp.getApplication().show(this.userGuide);
    }

    @Action
    public Task equilibrate() {
        return new EquilibrateTask(this.getApplication());
    }

    public void clearResults() {
        this.enthalpyLabel.setText("");
        this.entropyLabel.setText("");
        this.freeEnergyLabel.setText("");
        this.equilConstantLabel.setText("");
        this.percentCH3OHLabel.setText("");
        this.percentHClLabel.setText("");
        this.percentH2OLabel.setText("");
        this.percentCH3ClLabel.setText("");
        this.conversionLabel.setText("");
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.feedRatioTextField = new JFormattedTextField();
        this.pressureTextField = new JFormattedTextField();
        this.temperatureTextField = new JFormattedTextField();
        this.equilibrateButton = new JButton();
        this.jLabel14 = new JLabel();
        this.jPanel2 = new JPanel();
        this.enthalpyLabel = new JLabel();
        this.entropyLabel = new JLabel();
        this.freeEnergyLabel = new JLabel();
        this.equilConstantLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.percentCH3OHLabel = new JLabel();
        this.percentHClLabel = new JLabel();
        this.percentH2OLabel = new JLabel();
        this.percentCH3ClLabel = new JLabel();
        this.conversionLabel = new JLabel();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.mainPanel.setName("mainPanel");
        ResourceMap resourceMap = Application.getInstance(MeClEquilibratorApp.class).getContext().getResourceMap(MeClEquilibratorView.class);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("jPanel1.border.title", new Object[0]), 0, 0, resourceMap.getFont("jPanel1.border.titleFont")));
        this.jPanel1.setForeground(resourceMap.getColor("jPanel1.foreground"));
        this.jPanel1.setName("jPanel1");
        this.jLabel11.setHorizontalAlignment(2);
        this.jLabel11.setText(resourceMap.getString("jLabel11.text", new Object[0]));
        this.jLabel11.setName("jLabel11");
        this.jLabel12.setHorizontalAlignment(2);
        this.jLabel12.setText(resourceMap.getString("jLabel12.text", new Object[0]));
        this.jLabel12.setName("jLabel12");
        this.jLabel13.setHorizontalAlignment(2);
        this.jLabel13.setText(resourceMap.getString("jLabel13.text", new Object[0]));
        this.jLabel13.setName("jLabel13");
        this.feedRatioTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter()));
        this.feedRatioTextField.setText(resourceMap.getString("feedRatioTextField.text", new Object[0]));
        this.feedRatioTextField.setToolTipText(resourceMap.getString("feedRatioTextField.toolTipText", new Object[0]));
        this.feedRatioTextField.setName("feedRatioTextField");
        this.feedRatioTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MeClEquilibratorView.this.newInitialFeedRatio(evt);
            }
        });
        this.pressureTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.pressureTextField.setText(resourceMap.getString("pressureTextField.text", new Object[0]));
        this.pressureTextField.setToolTipText(resourceMap.getString("pressureTextField.toolTipText", new Object[0]));
        this.pressureTextField.setName("pressureTextField");
        this.pressureTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MeClEquilibratorView.this.newInitialPressure(evt);
            }
        });
        this.temperatureTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.temperatureTextField.setText(resourceMap.getString("temperatureTextField.text", new Object[0]));
        this.temperatureTextField.setToolTipText(resourceMap.getString("temperatureTextField.toolTipText", new Object[0]));
        this.temperatureTextField.setName("temperatureTextField");
        this.temperatureTextField.setFocusLostBehavior(1);
        this.temperatureTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MeClEquilibratorView.this.newInitialTemperature(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel12).addPreferredGap(0).add((Component)this.pressureTextField, -1, 97, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel13).addPreferredGap(0).add((Component)this.feedRatioTextField, -1, 97, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel11).addPreferredGap(0, 49, Short.MAX_VALUE).add((Component)this.temperatureTextField, -2, 71, -2))).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.jLabel12, this.jLabel13}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel11).add((Component)this.temperatureTextField, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel12).add((Component)this.pressureTextField, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel13).add((Component)this.feedRatioTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        ApplicationActionMap actionMap = Application.getInstance(MeClEquilibratorApp.class).getContext().getActionMap(MeClEquilibratorView.class, this);
        this.equilibrateButton.setAction(actionMap.get("equilibrate"));
        this.equilibrateButton.setText(resourceMap.getString("equilibrateButton.text", new Object[0]));
        this.equilibrateButton.setName("equilibrateButton");
        this.jLabel14.setHorizontalAlignment(0);
        this.jLabel14.setText(resourceMap.getString("jLabel14.text", new Object[0]));
        this.jLabel14.setName("jLabel14");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("jPanel2.border.title", new Object[0]), 0, 0, resourceMap.getFont("jPanel2.border.titleFont")));
        this.jPanel2.setName("jPanel2");
        this.enthalpyLabel.setHorizontalAlignment(0);
        this.enthalpyLabel.setText(resourceMap.getString("enthalpyLabel.text", new Object[0]));
        this.enthalpyLabel.setName("enthalpyLabel");
        this.entropyLabel.setHorizontalAlignment(0);
        this.entropyLabel.setText(resourceMap.getString("entropyLabel.text", new Object[0]));
        this.entropyLabel.setName("entropyLabel");
        this.freeEnergyLabel.setHorizontalAlignment(0);
        this.freeEnergyLabel.setText(resourceMap.getString("freeEnergyLabel.text", new Object[0]));
        this.freeEnergyLabel.setName("freeEnergyLabel");
        this.equilConstantLabel.setHorizontalAlignment(0);
        this.equilConstantLabel.setText(resourceMap.getString("equilConstantLabel.text", new Object[0]));
        this.equilConstantLabel.setName("equilConstantLabel");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.enthalpyLabel, -1, 192, Short.MAX_VALUE).add(2, (Component)this.entropyLabel, -1, 192, Short.MAX_VALUE).add(2, (Component)this.freeEnergyLabel, -1, 192, Short.MAX_VALUE).add((Component)this.equilConstantLabel, -1, 192, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.enthalpyLabel).add(18, 18, 18).add((Component)this.entropyLabel).add(18, 18, 18).add((Component)this.freeEnergyLabel).addPreferredGap(0, 20, Short.MAX_VALUE).add((Component)this.equilConstantLabel).addContainerGap()));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("jPanel3.border.title", new Object[0]), 0, 0, resourceMap.getFont("jPanel3.border.titleFont")));
        this.jPanel3.setName("jPanel3");
        this.jLabel15.setText(resourceMap.getString("jLabel15.text", new Object[0]));
        this.jLabel15.setName("jLabel15");
        this.jLabel16.setText(resourceMap.getString("jLabel16.text", new Object[0]));
        this.jLabel16.setName("jLabel16");
        this.jLabel17.setText(resourceMap.getString("jLabel17.text", new Object[0]));
        this.jLabel17.setName("jLabel17");
        this.jLabel18.setText(resourceMap.getString("jLabel18.text", new Object[0]));
        this.jLabel18.setName("jLabel18");
        this.percentCH3OHLabel.setText(resourceMap.getString("percentCH3OHLabel.text", new Object[0]));
        this.percentCH3OHLabel.setName("percentCH3OHLabel");
        this.percentHClLabel.setText(resourceMap.getString("percentHClLabel.text", new Object[0]));
        this.percentHClLabel.setName("percentHClLabel");
        this.percentH2OLabel.setText(resourceMap.getString("percentH2OLabel.text", new Object[0]));
        this.percentH2OLabel.setName("percentH2OLabel");
        this.percentCH3ClLabel.setText(resourceMap.getString("percentCH3ClLabel.text", new Object[0]));
        this.percentCH3ClLabel.setName("percentCH3ClLabel");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel15).addPreferredGap(0).add((Component)this.percentCH3OHLabel, -1, 94, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel16).addPreferredGap(0).add((Component)this.percentHClLabel, -1, 117, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel17).addPreferredGap(0).add((Component)this.percentH2OLabel, -1, 113, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel18).addPreferredGap(0).add((Component)this.percentCH3ClLabel, -1, 101, Short.MAX_VALUE))).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel15).add((Component)this.percentCH3OHLabel)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel16).add((Component)this.percentHClLabel)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel17).add((Component)this.percentH2OLabel)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel18).add((Component)this.percentCH3ClLabel))));
        this.conversionLabel.setText(resourceMap.getString("conversionLabel.text", new Object[0]));
        this.conversionLabel.setName("conversionLabel");
        GroupLayout mainPanelLayout = new GroupLayout((Container)this.mainPanel);
        this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
        mainPanelLayout.setHorizontalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(2).add(1, (Component)this.conversionLabel, -1, 477, Short.MAX_VALUE).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(2, false).add(1, (Component)this.jLabel14, -1, -1, Short.MAX_VALUE).add(1, (Component)this.equilibrateButton, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).add(18, 18, 18).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        mainPanelLayout.setVerticalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1, false).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(0, 7, Short.MAX_VALUE).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(4).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((Component)this.equilibrateButton).addPreferredGap(0).add((Component)this.jLabel14)).add((Component)this.jPanel3, -2, -1, -2)).add(18, 18, 18).add((Component)this.conversionLabel, -2, 17, -2)));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setToolTipText(resourceMap.getString("aboutMenuItem.toolTipText", new Object[0]));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.jMenuItem5.setAction(actionMap.get("showUserGuide"));
        this.jMenuItem5.setText(resourceMap.getString("jMenuItem5.text", new Object[0]));
        this.jMenuItem5.setToolTipText(resourceMap.getString("jMenuItem5.toolTipText", new Object[0]));
        this.jMenuItem5.setName("jMenuItem5");
        helpMenu.add(this.jMenuItem5);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout((Container)this.statusPanel);
        this.statusPanel.setLayout((LayoutManager)statusPanelLayout);
        statusPanelLayout.setHorizontalGroup((GroupLayout.Group)statusPanelLayout.createParallelGroup(1).add((Component)statusPanelSeparator, -1, 517, Short.MAX_VALUE).add(2, (GroupLayout.Group)statusPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.statusMessageLabel).addPreferredGap(0, 323, Short.MAX_VALUE).add((Component)this.statusAnimationLabel).addPreferredGap(0).add((Component)this.progressBar, -2, -1, -2).addContainerGap()));
        statusPanelLayout.setVerticalGroup((GroupLayout.Group)statusPanelLayout.createParallelGroup(1).add((GroupLayout.Group)statusPanelLayout.createSequentialGroup().add((Component)statusPanelSeparator, -2, 2, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)statusPanelLayout.createParallelGroup(2).add((GroupLayout.Group)statusPanelLayout.createSequentialGroup().add((GroupLayout.Group)statusPanelLayout.createParallelGroup(3).add((Component)this.statusMessageLabel).add((Component)this.statusAnimationLabel)).add(32, 32, 32)).add((GroupLayout.Group)statusPanelLayout.createSequentialGroup().add((Component)this.progressBar, -2, -1, -2).addContainerGap()))));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void newInitialTemperature(PropertyChangeEvent evt) {
        double newTemperature = ((Number)this.temperatureTextField.getValue()).doubleValue();
        if (newTemperature != this.T) {
            this.clearResults();
            this.T = newTemperature < 373.0 ? 373.0 : (newTemperature > 1200.0 ? 1200.0 : newTemperature);
            this.temperatureTextField.setValue(new Double(this.T));
        }
    }

    private void newInitialPressure(PropertyChangeEvent evt) {
        double newPressure = ((Number)this.pressureTextField.getValue()).doubleValue();
        if (newPressure != this.P) {
            this.clearResults();
            this.P = newPressure < 1.0 ? 1.0 : (newPressure > 100.0 ? 100.0 : newPressure);
            this.pressureTextField.setValue(new Double(this.P));
        }
    }

    private void newInitialFeedRatio(PropertyChangeEvent evt) {
        double newFeedRatio = ((Number)this.feedRatioTextField.getValue()).doubleValue();
        if (newFeedRatio != this.ratio) {
            this.clearResults();
            this.ratio = newFeedRatio < 0.01 ? 0.01 : (newFeedRatio > 100.0 ? 100.0 : newFeedRatio);
            this.feedRatioTextField.setValue(new Double(this.ratio));
        }
    }

    private class EquilibrateTask
    extends Task<Object, Void>
    implements NMNewtRaphEqns,
    NMJacEstEqns {
        double temperature;
        double pressure;
        double feedRatio;
        double conversion;
        double sRxn;
        double hRxn;
        double gRxn;
        double K;
        double[] x;
        double[] y;

        EquilibrateTask(Application app) {
            super(app);
            this.temperature = ((Number)MeClEquilibratorView.this.temperatureTextField.getValue()).doubleValue();
            this.pressure = ((Number)MeClEquilibratorView.this.pressureTextField.getValue()).doubleValue();
            this.feedRatio = ((Number)MeClEquilibratorView.this.feedRatioTextField.getValue()).doubleValue();
            MeClEquilibratorView.this.equilibrateButton.setEnabled(false);
        }

        @Override
        protected Object doInBackground() {
            String txt = "Calculating Species Thermo";
            this.setMessage(txt);
            int progress = 0;
            this.setProgress(0);
            MeClEquilibratorView.this.n0HCl = 1.0;
            MeClEquilibratorView.this.n0CH3OH = this.feedRatio;
            double sCH3Cl = MeClEquilibratorView.this.CH3Cl.sStd(this.temperature).getDoubleValue();
            double sH2O = MeClEquilibratorView.this.H2O.sStd(this.temperature).getDoubleValue();
            double sHCl = MeClEquilibratorView.this.HCl.sStd(this.temperature).getDoubleValue();
            double sCH3OH = MeClEquilibratorView.this.CH3OH.sStd(this.temperature).getDoubleValue();
            double hCH3Cl = MeClEquilibratorView.this.CH3Cl.hForm(this.temperature).getDoubleValue();
            double hH2O = MeClEquilibratorView.this.H2O.hForm(this.temperature).getDoubleValue();
            double hHCl = MeClEquilibratorView.this.HCl.hForm(this.temperature).getDoubleValue();
            double hCH3OH = MeClEquilibratorView.this.CH3OH.hForm(this.temperature).getDoubleValue();
            double gCH3Cl = MeClEquilibratorView.this.CH3Cl.gForm(this.temperature).getDoubleValue();
            double gH2O = MeClEquilibratorView.this.H2O.gForm(this.temperature).getDoubleValue();
            double gHCl = MeClEquilibratorView.this.HCl.gForm(this.temperature).getDoubleValue();
            double gCH3OH = MeClEquilibratorView.this.CH3OH.gForm(this.temperature).getDoubleValue();
            txt = "Calculating Reaction Thermo";
            this.setMessage(txt);
            progress = 25;
            this.setProgress(progress);
            this.sRxn = sCH3Cl + sH2O - sHCl - sCH3OH;
            this.hRxn = hCH3Cl + hH2O - hHCl - hCH3OH;
            this.gRxn = gCH3Cl + gH2O - gHCl - gCH3OH;
            this.K = Math.exp(-this.gRxn * 1000.0 / 8.3144 / this.temperature);
            txt = "Calculating Equilibrium Composition";
            this.setMessage(txt);
            progress = 50;
            this.setProgress(progress);
            this.x = new double[4];
            this.y = new double[4];
            this.x[0] = MeClEquilibratorView.this.n0CH3OH;
            this.x[1] = MeClEquilibratorView.this.n0HCl;
            this.x[2] = 0.0;
            this.x[3] = 0.0;
            progress = 75;
            this.setProgress(progress);
            NMNewtRaphSolver theSolver = new NMNewtRaphSolver((NMNewtRaphEqns)this);
            theSolver.setTol(1.0E-4);
            theSolver.setTreatAsNonNegative(true);
            NMResult theResult = theSolver.solve(this.x, this.y);
            MeClEquilibratorView.this.percentCH3Cl = 100.0 * this.x[3] / (MeClEquilibratorView.this.n0CH3OH + MeClEquilibratorView.this.n0HCl);
            MeClEquilibratorView.this.percentH2O = 100.0 * this.x[2] / (MeClEquilibratorView.this.n0CH3OH + MeClEquilibratorView.this.n0HCl);
            MeClEquilibratorView.this.percentHCl = 100.0 * this.x[1] / (MeClEquilibratorView.this.n0CH3OH + MeClEquilibratorView.this.n0HCl);
            MeClEquilibratorView.this.percentCH3OH = 100.0 * this.x[0] / (MeClEquilibratorView.this.n0CH3OH + MeClEquilibratorView.this.n0HCl);
            this.conversion = this.feedRatio <= 1.0 ? 100.0 * (MeClEquilibratorView.this.n0CH3OH - this.x[0]) / MeClEquilibratorView.this.n0CH3OH : 100.0 * (MeClEquilibratorView.this.n0HCl - this.x[1]) / MeClEquilibratorView.this.n0HCl;
            txt = "";
            this.setMessage(txt);
            progress = 100;
            this.setProgress(progress);
            return null;
        }

        @Override
        protected void succeeded(Object result) {
            DecimalFormat noDecimal = new DecimalFormat("####");
            DecimalFormat threeSigFigs = new DecimalFormat("0.00E00");
            DecimalFormat notScientific = new DecimalFormat("##0.00");
            String txt = "<html>&#916;S(" + noDecimal.format(this.temperature);
            txt = txt + ") = ";
            txt = Math.abs(this.sRxn) < 0.1 ? txt + threeSigFigs.format(this.sRxn) + " J/(mol K)" : txt + notScientific.format(this.sRxn) + " J/(mol K)";
            MeClEquilibratorView.this.entropyLabel.setText(txt);
            txt = "<html>&#916;H(" + noDecimal.format(this.temperature);
            txt = txt + ") = ";
            txt = Math.abs(this.hRxn) < 0.1 ? txt + threeSigFigs.format(this.hRxn) + " kJ/mol" : txt + notScientific.format(this.hRxn) + " kJ/mol";
            MeClEquilibratorView.this.enthalpyLabel.setText(txt);
            txt = "<html>&#916;G(" + noDecimal.format(this.temperature);
            txt = txt + ") = ";
            txt = Math.abs(this.gRxn) < 0.1 ? txt + threeSigFigs.format(this.gRxn) + " kJ/mol" : txt + notScientific.format(this.gRxn) + " kJ/mol";
            MeClEquilibratorView.this.freeEnergyLabel.setText(txt);
            txt = "<html>K(" + noDecimal.format(this.temperature);
            txt = txt + ") = " + threeSigFigs.format(this.K);
            MeClEquilibratorView.this.equilConstantLabel.setText(txt);
            txt = MeClEquilibratorView.this.percentCH3OH < 0.1 ? threeSigFigs.format(MeClEquilibratorView.this.percentCH3OH) : notScientific.format(MeClEquilibratorView.this.percentCH3OH);
            txt = txt + " %";
            MeClEquilibratorView.this.percentCH3OHLabel.setText(txt);
            txt = MeClEquilibratorView.this.percentHCl < 0.1 ? threeSigFigs.format(MeClEquilibratorView.this.percentHCl) : notScientific.format(MeClEquilibratorView.this.percentHCl);
            txt = txt + " %";
            MeClEquilibratorView.this.percentHClLabel.setText(txt);
            txt = MeClEquilibratorView.this.percentH2O < 0.1 ? threeSigFigs.format(MeClEquilibratorView.this.percentH2O) : notScientific.format(MeClEquilibratorView.this.percentH2O);
            txt = txt + " %";
            MeClEquilibratorView.this.percentH2OLabel.setText(txt);
            txt = MeClEquilibratorView.this.percentCH3Cl < 0.1 ? threeSigFigs.format(MeClEquilibratorView.this.percentCH3Cl) : notScientific.format(MeClEquilibratorView.this.percentCH3Cl);
            txt = txt + " %";
            MeClEquilibratorView.this.percentCH3ClLabel.setText(txt);
            txt = "<html>Limiting Reagent ";
            if (this.feedRatio < 1.0) {
                txt = txt + "(CH<sub>3</sub>OH) ";
            }
            if (this.feedRatio > 1.0) {
                txt = txt + "(HCl) ";
            }
            txt = txt + "Conversion is ";
            txt = this.conversion < 0.1 ? txt + threeSigFigs.format(this.conversion) : txt + notScientific.format(this.conversion);
            txt = txt + " %";
            MeClEquilibratorView.this.conversionLabel.setText(txt);
            MeClEquilibratorView.this.equilibrateButton.setEnabled(true);
        }

        public NMResult evalNewtRaphEqns(double[] x, double[] y) {
            NMResult theResult = new NMResult();
            y[0] = this.K * x[0] * x[1] - x[2] * x[3];
            y[1] = MeClEquilibratorView.this.n0CH3OH - x[0] - x[3];
            y[2] = 4.0 * MeClEquilibratorView.this.n0CH3OH + MeClEquilibratorView.this.n0HCl - 4.0 * x[0] - x[1] - 2.0 * x[2] - 3.0 * x[3];
            y[3] = MeClEquilibratorView.this.n0CH3OH - x[0] - x[2];
            return theResult;
        }

        public NMResult evalNewtRaphJac(double[] x, double[][] jac) {
            NMJacEstimator jacEstimator = new NMJacEstimator((NMJacEstEqns)this);
            NMResult theResult = new NMResult();
            jacEstimator.estimate(4, x, jac, 1.0E-4);
            return theResult;
        }

        public NMResult evalJacEstEqns(double[] x, double[] y) {
            NMResult theResult = this.evalNewtRaphEqns(x, y);
            return theResult;
        }
    }
}

