/*
 * Decompiled with CFR 0.152.
 */
package staticreactors;

import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import numeth.NMBisectionEqn;
import numeth.NMBisectionSolver;
import numeth.NMResult;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.Task;
import staticreactors.StaticReactorsAboutBox;
import staticreactors.StaticReactorsApp;
import staticreactors.StaticReactorsUserGuide;

public class StaticReactorsView
extends FrameView {
    DecimalFormat threeSigFigs = new DecimalFormat("0.00E00");
    DecimalFormat notScientific0 = new DecimalFormat("##0");
    DecimalFormat notScientific2 = new DecimalFormat("##0.00");
    DecimalFormat notScientific4 = new DecimalFormat("##0.0000");
    StartExperimentTask exptTask;
    private JButton clearButton;
    private JFormattedTextField concAFormattedTextField;
    private JLabel concALabel;
    private JFormattedTextField concBFormattedTextField;
    private JLabel concBLabel;
    private JFormattedTextField concYFormattedTextField;
    private JLabel concYLabel;
    private JFormattedTextField concZFormattedTextField;
    private JLabel concZLabel;
    private JLabel concentrationLabel;
    private JLabel dataSetLabel;
    private JLabel diagramLabel;
    private JFormattedTextField flowRateFormattedTextField;
    private JLabel flowRateLabel;
    private JPanel inletSettingsPanel;
    private JLabel inletTemperatureLabel;
    private JScrollPane jScrollPane1;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JLabel outletConcLabel;
    private JLabel outletConcValueLabel;
    private JPanel outletPanel;
    private JLabel outletTemperatureLabel;
    private JLabel outletTemperatureValueLabel;
    private JTextArea outputTextArea;
    private JButton recordDataButton;
    private JButton saveButton;
    private JButton startExptButton;
    private JFormattedTextField temperatureFormattedTextField;
    private JMenuItem userGuideMenuItem;
    private JDialog aboutBox;
    private JDialog userGuide;
    private double inletTemperature;
    private double inletFlowRate;
    private double inletConcA;
    private double inletConcB;
    private double inletConcY;
    private double inletConcZ;
    private double vReactor;
    private double k0;
    private double actE;
    private double deltaH;
    private double rho;
    private double heatCapacity;
    private double gasConst;
    private double outletConcY;
    private double outletTemperature;
    private double concUncertainty;
    private double temperatureUncertainty;
    private double minimumInletT;
    private double maximumInletT;
    private double minimumInletFlow;
    private double maximumInletFlow;
    private double minimumInletConcA;
    private double maximumInletConcA;
    private double minimumInletConcB;
    private double maximumInletConcB;
    private double minimumInletConcY;
    private double maximumInletConcY;
    private double minimumInletConcZ;
    private double maximumInletConcZ;
    private int alpha;
    private int beta;
    private String unsteady1 = "The system has not yet";
    private String unsteady2 = "reached steady-state.";
    private String steady1 = "Concentration of Y (M)";
    private String steady2 = "Temperature (K)";
    private String calcFailed1 = "Something went wrong";
    private String calcFailed2 = "in the simulator.";
    private String calcFailed3 = "Try again with";
    private String calcFailed4 = "different inlet settings.";
    private String space = " ";
    private String header;
    private String reactorType;
    private double defaultInletTemperature;
    private double defaultInletFlowRate;
    private double defaultInletConcA;
    private double defaultInletConcB;
    private double defaultInletConcY;
    private double defaultInletConcZ;

    public StaticReactorsView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        this.vReactor = 100.0;
        this.alpha = 1;
        this.beta = 1;
        this.k0 = 7.32E7;
        this.actE = 50000.0;
        this.deltaH = -60000.0;
        this.rho = 1.0;
        this.heatCapacity = 4186.0;
        this.reactorType = "Isothermal CSTR";
        this.concUncertainty = 0.0025;
        this.temperatureUncertainty = 1.65;
        this.minimumInletT = 270.0;
        this.maximumInletT = 360.0;
        this.minimumInletFlow = 1.0;
        this.maximumInletFlow = 1000.0;
        this.minimumInletConcA = 0.01;
        this.maximumInletConcA = 5.0;
        this.minimumInletConcB = 0.01;
        this.maximumInletConcB = 5.0;
        this.minimumInletConcY = 0.0;
        this.maximumInletConcY = 5.0;
        this.minimumInletConcZ = 0.0;
        this.maximumInletConcZ = 5.0;
        this.defaultInletTemperature = 298.15;
        this.defaultInletFlowRate = 5.0;
        this.defaultInletConcA = 0.5;
        this.defaultInletConcB = 0.5;
        this.defaultInletConcY = 0.0;
        this.defaultInletConcZ = 0.0;
        this.gasConst = 8.3144;
        this.inletTemperature = this.defaultInletTemperature;
        this.inletFlowRate = this.defaultInletFlowRate;
        this.inletConcA = this.defaultInletConcA;
        this.inletConcB = this.defaultInletConcB;
        this.inletConcY = this.defaultInletConcY;
        this.inletConcZ = this.defaultInletConcZ;
        this.outletConcY = this.defaultInletConcY;
        this.outletTemperature = this.defaultInletTemperature;
        this.temperatureFormattedTextField.setValue(this.inletTemperature);
        this.flowRateFormattedTextField.setValue(this.inletFlowRate);
        this.concAFormattedTextField.setValue(this.inletConcA);
        this.concBFormattedTextField.setValue(this.inletConcB);
        this.concYFormattedTextField.setValue(this.inletConcY);
        this.concZFormattedTextField.setValue(this.inletConcZ);
        String text = this.notScientific0.format(this.minimumInletT) + " to ";
        text = text + this.notScientific0.format(this.maximumInletT);
        this.temperatureFormattedTextField.setToolTipText(text);
        text = this.notScientific2.format(this.minimumInletFlow) + " to ";
        text = text + this.notScientific2.format(this.maximumInletFlow);
        this.flowRateFormattedTextField.setToolTipText(text);
        text = this.notScientific2.format(this.minimumInletConcA) + " to ";
        text = text + this.notScientific2.format(this.maximumInletConcA);
        this.concAFormattedTextField.setToolTipText(text);
        text = this.notScientific2.format(this.minimumInletConcB) + " to ";
        text = text + this.notScientific2.format(this.maximumInletConcB);
        this.concBFormattedTextField.setToolTipText(text);
        text = this.notScientific2.format(this.minimumInletConcY) + " to ";
        text = text + this.notScientific2.format(this.maximumInletConcY);
        this.concYFormattedTextField.setToolTipText(text);
        text = this.notScientific2.format(this.minimumInletConcZ) + " to ";
        text = text + this.notScientific2.format(this.maximumInletConcZ);
        this.concZFormattedTextField.setToolTipText(text);
        this.recordDataButton.setEnabled(false);
        this.outletConcLabel.setText(this.unsteady1);
        this.outletConcValueLabel.setText(this.space);
        this.outletTemperatureLabel.setText(this.unsteady2);
        this.outletTemperatureValueLabel.setText(this.space);
        this.header = this.reactorType + " Reactor Data for the reaction A + B --> Y + Z\n";
        this.header = this.header + "Total Reactor Volume: " + this.notScientific0.format(this.vReactor);
        this.header = this.header + " L\n";
        this.header = this.header + "Inlet\tInlet\tInlet\tInlet\tInlet\tInlet\tOutlet\tOutlet\n";
        this.header = this.header + "T (K)\tFlow (L/min)\tConc. A (M)\tConc. B (M)\tConc. Y (M)\t";
        this.header = this.header + "Conc. Z (M)\tT (K)\tConc. Y (M)\n";
        this.outputTextArea.setText(this.header);
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = StaticReactorsApp.getApplication().getMainFrame();
            this.aboutBox = new StaticReactorsAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        StaticReactorsApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.inletSettingsPanel = new JPanel();
        this.inletTemperatureLabel = new JLabel();
        this.flowRateLabel = new JLabel();
        this.temperatureFormattedTextField = new JFormattedTextField();
        this.flowRateFormattedTextField = new JFormattedTextField();
        this.concentrationLabel = new JLabel();
        this.concALabel = new JLabel();
        this.concAFormattedTextField = new JFormattedTextField();
        this.concBLabel = new JLabel();
        this.concBFormattedTextField = new JFormattedTextField();
        this.concYLabel = new JLabel();
        this.concYFormattedTextField = new JFormattedTextField();
        this.concZLabel = new JLabel();
        this.concZFormattedTextField = new JFormattedTextField();
        this.diagramLabel = new JLabel();
        this.startExptButton = new JButton();
        this.outletPanel = new JPanel();
        this.outletConcLabel = new JLabel();
        this.outletConcValueLabel = new JLabel();
        this.outletTemperatureLabel = new JLabel();
        this.outletTemperatureValueLabel = new JLabel();
        this.recordDataButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.outputTextArea = new JTextArea();
        this.saveButton = new JButton();
        this.clearButton = new JButton();
        this.dataSetLabel = new JLabel();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.userGuideMenuItem = new JMenuItem();
        this.mainPanel.setName("mainPanel");
        this.mainPanel.setPreferredSize(new Dimension(900, 600));
        ResourceMap resourceMap = Application.getInstance(StaticReactorsApp.class).getContext().getResourceMap(StaticReactorsView.class);
        this.inletSettingsPanel.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("inletSettingsPanel.border.title", new Object[0])));
        this.inletSettingsPanel.setName("inletSettingsPanel");
        this.inletSettingsPanel.setPreferredSize(new Dimension(300, 300));
        this.inletTemperatureLabel.setText(resourceMap.getString("inletTemperatureLabel.text", new Object[0]));
        this.inletTemperatureLabel.setName("inletTemperatureLabel");
        this.flowRateLabel.setText(resourceMap.getString("flowRateLabel.text", new Object[0]));
        this.flowRateLabel.setName("flowRateLabel");
        this.temperatureFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0"))));
        this.temperatureFormattedTextField.setHorizontalAlignment(0);
        this.temperatureFormattedTextField.setText(resourceMap.getString("temperatureFormattedTextField.text", new Object[0]));
        this.temperatureFormattedTextField.setName("temperatureFormattedTextField");
        this.temperatureFormattedTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                StaticReactorsView.this.temperatureFormattedTextFieldFocusGained(evt);
            }
        });
        this.temperatureFormattedTextField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                StaticReactorsView.this.newInletTemperature(evt);
            }
        });
        this.flowRateFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0.00"))));
        this.flowRateFormattedTextField.setHorizontalAlignment(0);
        this.flowRateFormattedTextField.setText(resourceMap.getString("flowRateFormattedTextField.text", new Object[0]));
        this.flowRateFormattedTextField.setName("flowRateFormattedTextField");
        this.flowRateFormattedTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                StaticReactorsView.this.flowRateFormattedTextFieldFocusGained(evt);
            }
        });
        this.flowRateFormattedTextField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                StaticReactorsView.this.newInletFlowRate(evt);
            }
        });
        this.concentrationLabel.setHorizontalAlignment(0);
        this.concentrationLabel.setText(resourceMap.getString("concentrationLabel.text", new Object[0]));
        this.concentrationLabel.setName("concentrationLabel");
        this.concALabel.setText(resourceMap.getString("concALabel.text", new Object[0]));
        this.concALabel.setName("concALabel");
        this.concAFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0.00"))));
        this.concAFormattedTextField.setHorizontalAlignment(0);
        this.concAFormattedTextField.setText(resourceMap.getString("concAFormattedTextField.text", new Object[0]));
        this.concAFormattedTextField.setName("concAFormattedTextField");
        this.concAFormattedTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                StaticReactorsView.this.concAFormattedTextFieldFocusGained(evt);
            }
        });
        this.concAFormattedTextField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                StaticReactorsView.this.newInletConcA(evt);
            }
        });
        this.concBLabel.setText(resourceMap.getString("concBLabel.text", new Object[0]));
        this.concBLabel.setName("concBLabel");
        this.concBFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0.00"))));
        this.concBFormattedTextField.setHorizontalAlignment(0);
        this.concBFormattedTextField.setText(resourceMap.getString("concBFormattedTextField.text", new Object[0]));
        this.concBFormattedTextField.setName("concBFormattedTextField");
        this.concBFormattedTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                StaticReactorsView.this.concBFormattedTextFieldFocusGained(evt);
            }
        });
        this.concBFormattedTextField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                StaticReactorsView.this.newInletConcB(evt);
            }
        });
        this.concYLabel.setText(resourceMap.getString("concYLabel.text", new Object[0]));
        this.concYLabel.setName("concYLabel");
        this.concYFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0.00"))));
        this.concYFormattedTextField.setHorizontalAlignment(0);
        this.concYFormattedTextField.setText(resourceMap.getString("concYFormattedTextField.text", new Object[0]));
        this.concYFormattedTextField.setName("concYFormattedTextField");
        this.concYFormattedTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                StaticReactorsView.this.concYFormattedTextFieldFocusGained(evt);
            }
        });
        this.concYFormattedTextField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                StaticReactorsView.this.newInletConcY(evt);
            }
        });
        this.concZLabel.setText(resourceMap.getString("concZLabel.text", new Object[0]));
        this.concZLabel.setName("concZLabel");
        this.concZFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0.00"))));
        this.concZFormattedTextField.setHorizontalAlignment(0);
        this.concZFormattedTextField.setText(resourceMap.getString("concZFormattedTextField.text", new Object[0]));
        this.concZFormattedTextField.setName("concZFormattedTextField");
        this.concZFormattedTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                StaticReactorsView.this.concZFormattedTextFieldFocusGained(evt);
            }
        });
        this.concZFormattedTextField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                StaticReactorsView.this.newInletConcZ(evt);
            }
        });
        GroupLayout inletSettingsPanelLayout = new GroupLayout(this.inletSettingsPanel);
        this.inletSettingsPanel.setLayout(inletSettingsPanelLayout);
        inletSettingsPanelLayout.setHorizontalGroup(inletSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inletSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(inletSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inletSettingsPanelLayout.createSequentialGroup().addGroup(inletSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.flowRateLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.inletTemperatureLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(inletSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.flowRateFormattedTextField, -1, 98, Short.MAX_VALUE).addComponent(this.temperatureFormattedTextField, -1, 98, Short.MAX_VALUE))).addComponent(this.concentrationLabel, -1, 214, Short.MAX_VALUE).addGroup(inletSettingsPanelLayout.createSequentialGroup().addComponent(this.concALabel, -1, 87, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.concAFormattedTextField, -1, 121, Short.MAX_VALUE)).addGroup(inletSettingsPanelLayout.createSequentialGroup().addComponent(this.concBLabel, -1, 87, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.concBFormattedTextField, -1, 121, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, inletSettingsPanelLayout.createSequentialGroup().addComponent(this.concYLabel, -1, 87, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.concYFormattedTextField, -1, 121, Short.MAX_VALUE)).addGroup(inletSettingsPanelLayout.createSequentialGroup().addComponent(this.concZLabel, -1, 87, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.concZFormattedTextField, -1, 121, Short.MAX_VALUE))).addContainerGap()));
        inletSettingsPanelLayout.setVerticalGroup(inletSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inletSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(inletSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inletTemperatureLabel).addComponent(this.temperatureFormattedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(inletSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.flowRateLabel).addComponent(this.flowRateFormattedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.concentrationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(inletSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.concALabel).addComponent(this.concAFormattedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(inletSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.concBLabel).addComponent(this.concBFormattedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(inletSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.concYLabel).addComponent(this.concYFormattedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(inletSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.concZLabel).addComponent(this.concZFormattedTextField, -2, -1, -2)).addGap(17, 17, 17)));
        this.diagramLabel.setHorizontalAlignment(0);
        this.diagramLabel.setIcon(resourceMap.getIcon("diagramLabel.icon"));
        this.diagramLabel.setText(resourceMap.getString("diagramLabel.text", new Object[0]));
        this.diagramLabel.setName("diagramLabel");
        ApplicationActionMap actionMap = Application.getInstance(StaticReactorsApp.class).getContext().getActionMap(StaticReactorsView.class, this);
        this.startExptButton.setAction(actionMap.get("startExperiment"));
        this.startExptButton.setText(resourceMap.getString("startExptButton.text", new Object[0]));
        this.startExptButton.setName("startExptButton");
        this.outletPanel.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("outletPanel.border.title", new Object[0])));
        this.outletPanel.setName("outletPanel");
        this.outletConcLabel.setHorizontalAlignment(0);
        this.outletConcLabel.setText(resourceMap.getString("outletConcLabel.text", new Object[0]));
        this.outletConcLabel.setName("outletConcLabel");
        this.outletConcValueLabel.setHorizontalAlignment(0);
        this.outletConcValueLabel.setText(resourceMap.getString("outletConcValueLabel.text", new Object[0]));
        this.outletConcValueLabel.setName("outletConcValueLabel");
        this.outletTemperatureLabel.setHorizontalAlignment(0);
        this.outletTemperatureLabel.setText(resourceMap.getString("outletTemperatureLabel.text", new Object[0]));
        this.outletTemperatureLabel.setName("outletTemperatureLabel");
        this.outletTemperatureValueLabel.setHorizontalAlignment(0);
        this.outletTemperatureValueLabel.setText(resourceMap.getString("outletTemperatureValueLabel.text", new Object[0]));
        this.outletTemperatureValueLabel.setName("outletTemperatureValueLabel");
        GroupLayout outletPanelLayout = new GroupLayout(this.outletPanel);
        this.outletPanel.setLayout(outletPanelLayout);
        outletPanelLayout.setHorizontalGroup(outletPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outletPanelLayout.createSequentialGroup().addContainerGap().addGroup(outletPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outletTemperatureLabel, -1, 230, Short.MAX_VALUE).addGroup(outletPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.outletConcValueLabel, -1, 224, Short.MAX_VALUE)).addComponent(this.outletConcLabel, -1, 230, Short.MAX_VALUE).addComponent(this.outletTemperatureValueLabel, -1, 230, Short.MAX_VALUE)).addContainerGap()));
        outletPanelLayout.setVerticalGroup(outletPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outletPanelLayout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.outletConcLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outletConcValueLabel).addGap(30, 30, 30).addComponent(this.outletTemperatureLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outletTemperatureValueLabel).addContainerGap(39, Short.MAX_VALUE)));
        this.recordDataButton.setAction(actionMap.get("addExperimentToDataSet"));
        this.recordDataButton.setText(resourceMap.getString("recordDataButton.text", new Object[0]));
        this.recordDataButton.setName("recordDataButton");
        this.jScrollPane1.setName("jScrollPane1");
        this.outputTextArea.setColumns(20);
        this.outputTextArea.setFont(resourceMap.getFont("outputTextArea.font"));
        this.outputTextArea.setRows(5);
        this.outputTextArea.setName("outputTextArea");
        this.jScrollPane1.setViewportView(this.outputTextArea);
        this.saveButton.setAction(actionMap.get("saveDataSet"));
        this.saveButton.setText(resourceMap.getString("saveButton.text", new Object[0]));
        this.saveButton.setName("saveButton");
        this.clearButton.setAction(actionMap.get("clearDataSet"));
        this.clearButton.setText(resourceMap.getString("clearButton.text", new Object[0]));
        this.clearButton.setName("clearButton");
        this.dataSetLabel.setFont(resourceMap.getFont("dataSetLabel.font"));
        this.dataSetLabel.setHorizontalAlignment(0);
        this.dataSetLabel.setText(resourceMap.getString("dataSetLabel.text", new Object[0]));
        this.dataSetLabel.setName("dataSetLabel");
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(113, 113, 113).addComponent(this.saveButton, -2, 188, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 284, Short.MAX_VALUE).addComponent(this.clearButton, -2, 188, -2).addGap(131, 131, 131)).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 892, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.inletSettingsPanel, -2, 238, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.diagramLabel, -1, 388, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.recordDataButton, -1, -1, Short.MAX_VALUE).addComponent(this.startExptButton, -1, -1, Short.MAX_VALUE).addComponent(this.outletPanel, -1, -1, Short.MAX_VALUE)))).addContainerGap()).addComponent(this.dataSetLabel, -1, 904, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.diagramLabel, -1, 277, Short.MAX_VALUE).addComponent(this.inletSettingsPanel, GroupLayout.Alignment.TRAILING, -1, 277, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.startExptButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outletPanel, -2, -1, -2).addGap(13, 13, 13).addComponent(this.recordDataButton))).addGap(18, 18, 18).addComponent(this.dataSetLabel).addGap(16, 16, 16).addComponent(this.jScrollPane1, -2, 242, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveButton).addComponent(this.clearButton)).addGap(163, 163, 163)));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.userGuideMenuItem.setAction(actionMap.get("showUserGuide"));
        this.userGuideMenuItem.setText(resourceMap.getString("userGuideMenuItem.text", new Object[0]));
        this.userGuideMenuItem.setName("userGuideMenuItem");
        helpMenu.add(this.userGuideMenuItem);
        this.menuBar.add(helpMenu);
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
    }

    private void newInletTemperature(PropertyChangeEvent evt) {
        this.enableAddExpt(false);
        this.setOutletUnsteady();
        double newValue = ((Number)this.temperatureFormattedTextField.getValue()).doubleValue();
        if (newValue != this.inletTemperature) {
            this.inletTemperature = newValue < this.minimumInletT ? this.minimumInletT : (newValue > this.maximumInletT ? this.maximumInletT : newValue);
            this.temperatureFormattedTextField.setValue(new Double(this.inletTemperature));
        }
    }

    private void newInletFlowRate(PropertyChangeEvent evt) {
        this.enableAddExpt(false);
        this.setOutletUnsteady();
        double newValue = ((Number)this.flowRateFormattedTextField.getValue()).doubleValue();
        if (newValue != this.inletFlowRate) {
            this.inletFlowRate = newValue < this.minimumInletFlow ? this.minimumInletFlow : (newValue > this.maximumInletFlow ? this.maximumInletFlow : newValue);
            this.flowRateFormattedTextField.setValue(new Double(this.inletFlowRate));
        }
    }

    private void newInletConcA(PropertyChangeEvent evt) {
        this.enableAddExpt(false);
        this.setOutletUnsteady();
        double newValue = ((Number)this.concAFormattedTextField.getValue()).doubleValue();
        if (newValue != this.inletConcA) {
            this.inletConcA = newValue < this.minimumInletConcA ? this.minimumInletConcA : (newValue > this.maximumInletConcA ? this.maximumInletConcA : newValue);
            this.concAFormattedTextField.setValue(new Double(this.inletConcA));
        }
    }

    private void newInletConcB(PropertyChangeEvent evt) {
        this.enableAddExpt(false);
        this.setOutletUnsteady();
        double newValue = ((Number)this.concBFormattedTextField.getValue()).doubleValue();
        if (newValue != this.inletConcB) {
            this.inletConcB = newValue < this.minimumInletConcB ? this.minimumInletConcB : (newValue > this.maximumInletConcB ? this.maximumInletConcB : newValue);
            this.concBFormattedTextField.setValue(new Double(this.inletConcB));
        }
    }

    private void newInletConcY(PropertyChangeEvent evt) {
        this.enableAddExpt(false);
        this.setOutletUnsteady();
        double newValue = ((Number)this.concYFormattedTextField.getValue()).doubleValue();
        if (newValue != this.inletConcY) {
            this.inletConcY = newValue < this.minimumInletConcY ? this.minimumInletConcY : (newValue > this.maximumInletConcY ? this.maximumInletConcY : newValue);
            this.concYFormattedTextField.setValue(new Double(this.inletConcY));
        }
    }

    private void newInletConcZ(PropertyChangeEvent evt) {
        this.enableAddExpt(false);
        this.setOutletUnsteady();
        double newValue = ((Number)this.concZFormattedTextField.getValue()).doubleValue();
        if (newValue != this.inletConcZ) {
            if (newValue < this.minimumInletConcZ) {
                this.inletConcA = this.minimumInletConcA;
            } else {
                this.inletConcZ = newValue > this.maximumInletConcZ ? this.maximumInletConcZ : newValue;
            }
            this.concZFormattedTextField.setValue(new Double(this.inletConcZ));
        }
    }

    private void temperatureFormattedTextFieldFocusGained(FocusEvent evt) {
        this.enableAddExpt(false);
    }

    private void flowRateFormattedTextFieldFocusGained(FocusEvent evt) {
        this.enableAddExpt(false);
    }

    private void concAFormattedTextFieldFocusGained(FocusEvent evt) {
        this.enableAddExpt(false);
    }

    private void concBFormattedTextFieldFocusGained(FocusEvent evt) {
        this.enableAddExpt(false);
    }

    private void concYFormattedTextFieldFocusGained(FocusEvent evt) {
        this.enableAddExpt(false);
    }

    private void concZFormattedTextFieldFocusGained(FocusEvent evt) {
        this.enableAddExpt(false);
    }

    @Action
    public void showUserGuide() {
        if (this.userGuide == null) {
            JFrame mainFrame = StaticReactorsApp.getApplication().getMainFrame();
            this.userGuide = new StaticReactorsUserGuide(mainFrame);
            this.userGuide.setLocationRelativeTo(mainFrame);
        }
        StaticReactorsApp.getApplication().show(this.userGuide);
    }

    @Action
    public Task startExperiment() {
        this.exptTask = new StartExperimentTask(this.getApplication());
        return this.exptTask;
    }

    @Action
    public void clearDataSet() {
        JFrame mainFrame = StaticReactorsApp.getApplication().getMainFrame();
        int n = JOptionPane.showConfirmDialog(mainFrame, "The data set will be lost if not saved, continue?", "Reset Warning", 2, 0);
        if (n == 0) {
            if (this.exptTask != null) {
                this.exptTask.cancel(true);
            }
            this.inletTemperature = this.defaultInletTemperature;
            this.inletFlowRate = this.defaultInletFlowRate;
            this.inletConcA = this.defaultInletConcA;
            this.inletConcB = this.defaultInletConcB;
            this.inletConcY = this.defaultInletConcY;
            this.inletConcZ = this.defaultInletConcZ;
            this.temperatureFormattedTextField.setValue(this.inletTemperature);
            this.temperatureFormattedTextField.setEnabled(true);
            this.flowRateFormattedTextField.setValue(this.inletFlowRate);
            this.flowRateFormattedTextField.setEnabled(true);
            this.concAFormattedTextField.setValue(this.inletConcA);
            this.concAFormattedTextField.setEnabled(true);
            this.concBFormattedTextField.setValue(this.inletConcB);
            this.concBFormattedTextField.setEnabled(true);
            this.concYFormattedTextField.setValue(this.inletConcY);
            this.concYFormattedTextField.setEnabled(true);
            this.concZFormattedTextField.setValue(this.inletConcZ);
            this.concZFormattedTextField.setEnabled(true);
            this.enableStartExpt(true);
            this.enableAddExpt(false);
            this.setOutletUnsteady();
            this.header = this.reactorType + " Reactor Data for the reaction A + B --> Y + Z\n";
            this.header = this.header + "Total Reactor Volume: " + this.notScientific0.format(this.vReactor);
            this.header = this.header + " L\n";
            this.header = this.header + "Inlet\tInlet\tInlet\tInlet\tInlet\tInlet\tOutlet\tOutlet\n";
            this.header = this.header + "T (K)\tFlow (L/min)\tConc. A (M)\tConc. B (M)\tConc. Y (M)\t";
            this.header = this.header + "Conc. Z (M)\tT (K)\tConc. Y (M)\n";
            this.outputTextArea.setText(this.header);
        }
    }

    @Action
    public void addExperimentToDataSet() {
        String newData = this.notScientific0.format(this.inletTemperature) + "\t";
        newData = newData + this.notScientific2.format(this.inletFlowRate) + "\t";
        newData = newData + this.notScientific2.format(this.inletConcA) + "\t";
        newData = newData + this.notScientific2.format(this.inletConcB) + "\t";
        newData = newData + this.notScientific2.format(this.inletConcY) + "\t";
        newData = newData + this.notScientific2.format(this.inletConcZ) + "\t";
        newData = newData + this.outletTemperatureValueLabel.getText() + "\t";
        newData = newData + this.outletConcValueLabel.getText() + "\n";
        this.outputTextArea.append(newData);
    }

    @Action
    public void saveDataSet() throws IOException {
        JFileChooser fc = new JFileChooser();
        JFrame mainFrame = StaticReactorsApp.getApplication().getMainFrame();
        int returnVal = fc.showSaveDialog(mainFrame);
        if (returnVal != 0) {
            return;
        }
        File dataFile = fc.getSelectedFile();
        FileWriter outputStream = new FileWriter(dataFile);
        this.outputTextArea.write(outputStream);
        outputStream.close();
    }

    public void enableAddExpt(boolean enable) {
        if (enable != this.recordDataButton.isEnabled()) {
            this.recordDataButton.setEnabled(enable);
        }
    }

    public void enableStartExpt(boolean enable) {
        if (enable != this.startExptButton.isEnabled()) {
            this.startExptButton.setEnabled(enable);
        }
    }

    public void setOutletUnsteady() {
        this.outletConcLabel.setText(this.unsteady1);
        this.outletConcValueLabel.setText(this.space);
        this.outletTemperatureLabel.setText(this.unsteady2);
        this.outletTemperatureValueLabel.setText(this.space);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StartExperimentTask
    extends Task<Object, Void>
    implements NMBisectionEqn {
        double T0;
        double VFR0;
        double CA0;
        double CB0;
        double CY0;
        double CZ0;
        double tau;
        double k;
        boolean converged;

        StartExperimentTask(Application app) {
            super(app);
            this.T0 = ((Number)StaticReactorsView.this.temperatureFormattedTextField.getValue()).doubleValue();
            this.VFR0 = ((Number)StaticReactorsView.this.flowRateFormattedTextField.getValue()).doubleValue();
            this.CA0 = ((Number)StaticReactorsView.this.concAFormattedTextField.getValue()).doubleValue();
            this.CB0 = ((Number)StaticReactorsView.this.concBFormattedTextField.getValue()).doubleValue();
            this.CY0 = ((Number)StaticReactorsView.this.concYFormattedTextField.getValue()).doubleValue();
            this.CZ0 = ((Number)StaticReactorsView.this.concZFormattedTextField.getValue()).doubleValue();
            this.tau = StaticReactorsView.this.vReactor / this.VFR0;
            this.k = StaticReactorsView.this.k0 * Math.exp(-StaticReactorsView.this.actE / StaticReactorsView.this.gasConst / this.T0);
            StaticReactorsView.this.enableStartExpt(false);
            StaticReactorsView.this.enableAddExpt(false);
            StaticReactorsView.this.temperatureFormattedTextField.setEnabled(false);
            StaticReactorsView.this.flowRateFormattedTextField.setEnabled(false);
            StaticReactorsView.this.concAFormattedTextField.setEnabled(false);
            StaticReactorsView.this.concBFormattedTextField.setEnabled(false);
            StaticReactorsView.this.concYFormattedTextField.setEnabled(false);
            StaticReactorsView.this.concZFormattedTextField.setEnabled(false);
            StaticReactorsView.this.setOutletUnsteady();
        }

        @Override
        protected Object doInBackground() {
            this.converged = false;
            NMBisectionSolver theSolver = new NMBisectionSolver((NMBisectionEqn)this);
            double accuracy = 1.0E-7;
            double[] limit = new double[]{this.CA0, this.CA0 > this.CB0 ? this.CA0 - this.CB0 : 0.0};
            NMResult theResult = theSolver.solve(limit, accuracy);
            if (theResult.getStatus() != 0) {
                this.converged = false;
                return null;
            }
            this.converged = true;
            StaticReactorsView.this.outletConcY = this.CY0 + this.CA0 - theResult.getDoubleValue();
            StaticReactorsView.this.outletTemperature = this.T0;
            StaticReactorsView.this.outletTemperature += StaticReactorsView.this.temperatureUncertainty * (Math.random() * 2.0 - 1.0);
            StaticReactorsView.this.outletConcY += StaticReactorsView.this.concUncertainty * (Math.random() * 2.0 - 1.0);
            return null;
        }

        @Override
        protected void succeeded(Object result) {
            StaticReactorsView.this.temperatureFormattedTextField.setEnabled(true);
            StaticReactorsView.this.flowRateFormattedTextField.setEnabled(true);
            StaticReactorsView.this.concAFormattedTextField.setEnabled(true);
            StaticReactorsView.this.concBFormattedTextField.setEnabled(true);
            StaticReactorsView.this.concYFormattedTextField.setEnabled(true);
            StaticReactorsView.this.concZFormattedTextField.setEnabled(true);
            StaticReactorsView.this.enableStartExpt(true);
            if (this.converged) {
                StaticReactorsView.this.outletConcLabel.setText(StaticReactorsView.this.steady1);
                StaticReactorsView.this.outletConcValueLabel.setText(StaticReactorsView.this.notScientific4.format(StaticReactorsView.this.outletConcY));
                StaticReactorsView.this.outletTemperatureLabel.setText(StaticReactorsView.this.steady2);
                StaticReactorsView.this.outletTemperatureValueLabel.setText(StaticReactorsView.this.notScientific0.format(StaticReactorsView.this.outletTemperature));
                StaticReactorsView.this.enableAddExpt(true);
            } else {
                StaticReactorsView.this.outletConcLabel.setText(StaticReactorsView.this.calcFailed1);
                StaticReactorsView.this.outletConcValueLabel.setText(StaticReactorsView.this.calcFailed2);
                StaticReactorsView.this.outletTemperatureLabel.setText(StaticReactorsView.this.calcFailed3);
                StaticReactorsView.this.outletTemperatureValueLabel.setText(StaticReactorsView.this.calcFailed4);
                StaticReactorsView.this.enableAddExpt(false);
            }
        }

        public NMResult evalBisectionEqn(double x) {
            double CA = x;
            double CB = this.CB0 - this.CA0 + x;
            double CY = this.CY0 + this.CA0 - x;
            double CZ = this.CZ0 + this.CA0 - x;
            double rate = this.k;
            if (StaticReactorsView.this.alpha == 2) {
                rate *= CA * CA;
            } else if (StaticReactorsView.this.alpha == 1) {
                rate *= CA;
            }
            if (StaticReactorsView.this.beta == 2) {
                rate *= CB * CB;
            } else if (StaticReactorsView.this.beta == 1) {
                rate *= CB;
            }
            NMResult theResult = new NMResult();
            theResult.setDoubleValue(this.CA0 - CA - this.tau * rate);
            return theResult;
        }
    }
}

