/*
 * Decompiled with CFR 0.152.
 */
package numeth;

import numeth.NMBisectionEqn;
import numeth.NMResult;

public class NMBisectionSolver {
    private NMBisectionEqn theEqn;
    private int maxIterations;

    public NMResult solve(double[] endpoint, double accuracy) {
        double x;
        double dx;
        String[] eMsg = new String[]{"", "NMBisectionSolver.solve: more than two endpoints provided", "NMBisectionSolver.solve: initial endpoints do not bracket the solution", "NMBisectionSolver.solve: error evaluating the equation", "NMBisectionSolver.solve: performed maximum number of iterations without finding solution"};
        NMResult theResult = new NMResult();
        if (endpoint.length != 2) {
            theResult.setStatus(1, eMsg[1]);
            return theResult;
        }
        NMResult fResult = this.theEqn.evalBisectionEqn(endpoint[0]);
        if (fResult.getStatus() != 0) {
            theResult.setStatus(3, eMsg[3], fResult);
            return theResult;
        }
        double f = fResult.getDoubleValue();
        NMResult fmidResult = this.theEqn.evalBisectionEqn(endpoint[1]);
        if (fmidResult.getStatus() != 0) {
            theResult.setStatus(3, eMsg[3], fmidResult);
            return theResult;
        }
        double fmid = fmidResult.getDoubleValue();
        if (f * fmid >= 0.0) {
            theResult.setStatus(2, eMsg[2]);
            return theResult;
        }
        if (f < 0.0) {
            dx = endpoint[1] - endpoint[0];
            x = endpoint[0];
        } else {
            dx = endpoint[0] - endpoint[1];
            x = endpoint[1];
        }
        for (int j = 0; j < this.maxIterations; ++j) {
            double xmid = x + (dx *= 0.5);
            fmidResult = this.theEqn.evalBisectionEqn(xmid);
            if (fmidResult.getStatus() != 0) {
                theResult.setStatus(3, eMsg[3], fmidResult);
                return theResult;
            }
            fmid = fmidResult.getDoubleValue();
            if (fmid <= 0.0) {
                x = xmid;
            }
            if (!(Math.abs(dx) < accuracy) && fmid != 0.0) continue;
            theResult.setDoubleValue(xmid);
            return theResult;
        }
        theResult.setDoubleValue(x);
        theResult.setStatus(4, eMsg[4]);
        return theResult;
    }

    public NMBisectionSolver(NMBisectionEqn eqn) {
        this.theEqn = eqn;
        this.maxIterations = 50;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }
}

