/*
 * CSTRStepResponseView.java
 */
package cstrstepresponse;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.Icon;
import org.jdesktop.application.Action;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.FrameView;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;

/**
 * The application's main frame.
 */
public class CSTRStepResponseView extends FrameView {
  // A few output formats

  DecimalFormat threeSigFigs = new DecimalFormat("0.00E00");
  DecimalFormat notScientific2 = new DecimalFormat("##0.00");
  DecimalFormat notScientific4 = new DecimalFormat("##0.0000");

  public CSTRStepResponseView(SingleFrameApplication app) {
    super(app);

    initComponents();

    // Set default values
    vFlow = 5.0;
    flowRateFormattedTextField.setValue(vFlow);
    ResourceMap resourceMap = getResourceMap();
    afterStepIcon = resourceMap.getIcon("altDiagramLabel.icon");
    beforeStepIcon = resourceMap.getIcon("diagramLabel.icon");
    tracerFlowLabel.setText("at 1% of Process Flow");
    recordButton.setEnabled(false);
  }

  @Action
  public void showAboutBox() {
    if (aboutBox == null) {
      JFrame mainFrame = CSTRStepResponseApp.getApplication().getMainFrame();
      aboutBox = new CSTRStepResponseAboutBox(mainFrame);
      aboutBox.setLocationRelativeTo(mainFrame);
    }
    CSTRStepResponseApp.getApplication().show(aboutBox);
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    mainPanel = new javax.swing.JPanel();
    diagramLabel = new javax.swing.JLabel();
    timeLabel = new javax.swing.JLabel();
    volumePercentLabel = new javax.swing.JLabel();
    timeValueLabel = new javax.swing.JLabel();
    volumePercentValueLabel = new javax.swing.JLabel();
    recordButton = new javax.swing.JButton();
    startTracerButton = new javax.swing.JButton();
    resetButton = new javax.swing.JButton();
    flowLabel = new javax.swing.JLabel();
    jScrollPane1 = new javax.swing.JScrollPane();
    outputTextArea = new javax.swing.JTextArea();
    tracerFlowLabel = new javax.swing.JLabel();
    flowRateFormattedTextField = new javax.swing.JFormattedTextField();
    menuBar = new javax.swing.JMenuBar();
    javax.swing.JMenu fileMenu = new javax.swing.JMenu();
    saveMenuItem = new javax.swing.JMenuItem();
    javax.swing.JMenuItem exitMenuItem = new javax.swing.JMenuItem();
    javax.swing.JMenu helpMenu = new javax.swing.JMenu();
    javax.swing.JMenuItem aboutMenuItem = new javax.swing.JMenuItem();
    userGuideMenuItem = new javax.swing.JMenuItem();

    mainPanel.setName("mainPanel"); // NOI18N

    org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(cstrstepresponse.CSTRStepResponseApp.class).getContext().getResourceMap(CSTRStepResponseView.class);
    diagramLabel.setIcon(resourceMap.getIcon("diagramLabel.icon")); // NOI18N
    diagramLabel.setText(resourceMap.getString("diagramLabel.text")); // NOI18N
    diagramLabel.setName("diagramLabel"); // NOI18N

    timeLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    timeLabel.setText(resourceMap.getString("timeLabel.text")); // NOI18N
    timeLabel.setName("timeLabel"); // NOI18N

    volumePercentLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    volumePercentLabel.setText(resourceMap.getString("volumePercentLabel.text")); // NOI18N
    volumePercentLabel.setName("volumePercentLabel"); // NOI18N

    timeValueLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    timeValueLabel.setText(resourceMap.getString("timeValueLabel.text")); // NOI18N
    timeValueLabel.setName("timeValueLabel"); // NOI18N

    volumePercentValueLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    volumePercentValueLabel.setText(resourceMap.getString("volumePercentValueLabel.text")); // NOI18N
    volumePercentValueLabel.setName("volumePercentValueLabel"); // NOI18N

    javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(cstrstepresponse.CSTRStepResponseApp.class).getContext().getActionMap(CSTRStepResponseView.class, this);
    recordButton.setAction(actionMap.get("recordOutput")); // NOI18N
    recordButton.setText(resourceMap.getString("recordButton.text")); // NOI18N
    recordButton.setName("recordButton"); // NOI18N

    startTracerButton.setAction(actionMap.get("startTracerFlow")); // NOI18N
    startTracerButton.setText(resourceMap.getString("startTracerButton.text")); // NOI18N
    startTracerButton.setName("startTracerButton"); // NOI18N

    resetButton.setAction(actionMap.get("reset")); // NOI18N
    resetButton.setText(resourceMap.getString("resetButton.text")); // NOI18N
    resetButton.setName("resetButton"); // NOI18N

    flowLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    flowLabel.setText(resourceMap.getString("flowLabel.text")); // NOI18N
    flowLabel.setName("flowLabel"); // NOI18N

    jScrollPane1.setName("jScrollPane1"); // NOI18N

    outputTextArea.setColumns(20);
    outputTextArea.setRows(5);
    outputTextArea.setName("outputTextArea"); // NOI18N
    jScrollPane1.setViewportView(outputTextArea);

    tracerFlowLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    tracerFlowLabel.setText(resourceMap.getString("tracerFlowLabel.text")); // NOI18N
    tracerFlowLabel.setName("tracerFlowLabel"); // NOI18N

    flowRateFormattedTextField.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0.0"))));
    flowRateFormattedTextField.setHorizontalAlignment(javax.swing.JTextField.CENTER);
    flowRateFormattedTextField.setText(resourceMap.getString("flowRateFormattedTextField.text")); // NOI18N
    flowRateFormattedTextField.setToolTipText(resourceMap.getString("flowRateFormattedTextField.toolTipText")); // NOI18N
    flowRateFormattedTextField.setName("flowRateFormattedTextField"); // NOI18N
    flowRateFormattedTextField.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
      public void propertyChange(java.beans.PropertyChangeEvent evt) {
        newFlowRate(evt);
      }
    });

    org.jdesktop.layout.GroupLayout mainPanelLayout = new org.jdesktop.layout.GroupLayout(mainPanel);
    mainPanel.setLayout(mainPanelLayout);
    mainPanelLayout.setHorizontalGroup(
      mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(mainPanelLayout.createSequentialGroup()
        .addContainerGap()
        .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
          .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 678, Short.MAX_VALUE)
          .add(mainPanelLayout.createSequentialGroup()
            .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
              .add(flowLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
              .add(startTracerButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
              .add(resetButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
              .add(tracerFlowLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 145, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
              .add(flowRateFormattedTextField))
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(diagramLabel)
            .add(18, 18, 18)
            .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
              .add(recordButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
              .add(volumePercentValueLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
              .add(timeLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
              .add(timeValueLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
              .add(volumePercentLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
        .addContainerGap())
    );
    mainPanelLayout.setVerticalGroup(
      mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(mainPanelLayout.createSequentialGroup()
        .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
          .add(diagramLabel)
          .add(mainPanelLayout.createSequentialGroup()
            .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
              .add(mainPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(timeLabel)
                .add(18, 18, 18)
                .add(timeValueLabel))
              .add(mainPanelLayout.createSequentialGroup()
                .add(35, 35, 35)
                .add(flowLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(flowRateFormattedTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
            .add(6, 6, 6)
            .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
              .add(mainPanelLayout.createSequentialGroup()
                .add(13, 13, 13)
                .add(volumePercentLabel)
                .add(18, 18, 18)
                .add(volumePercentValueLabel))
              .add(mainPanelLayout.createSequentialGroup()
                .add(39, 39, 39)
                .add(startTracerButton)))
            .add(6, 6, 6)
            .add(tracerFlowLabel)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
              .add(recordButton)
              .add(resetButton))))
        .add(18, 18, 18)
        .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 134, Short.MAX_VALUE)
        .addContainerGap())
    );

    menuBar.setName("menuBar"); // NOI18N

    fileMenu.setText(resourceMap.getString("fileMenu.text")); // NOI18N
    fileMenu.setName("fileMenu"); // NOI18N

    saveMenuItem.setAction(actionMap.get("saveData")); // NOI18N
    saveMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_S, java.awt.event.InputEvent.SHIFT_MASK | java.awt.event.InputEvent.META_MASK));
    saveMenuItem.setName("saveMenuItem"); // NOI18N
    fileMenu.add(saveMenuItem);

    exitMenuItem.setAction(actionMap.get("quit")); // NOI18N
    exitMenuItem.setName("exitMenuItem"); // NOI18N
    fileMenu.add(exitMenuItem);

    menuBar.add(fileMenu);

    helpMenu.setText(resourceMap.getString("helpMenu.text")); // NOI18N
    helpMenu.setName("helpMenu"); // NOI18N

    aboutMenuItem.setAction(actionMap.get("showAboutBox")); // NOI18N
    aboutMenuItem.setName("aboutMenuItem"); // NOI18N
    helpMenu.add(aboutMenuItem);

    userGuideMenuItem.setAction(actionMap.get("showUserGuide")); // NOI18N
    userGuideMenuItem.setText(resourceMap.getString("userGuideMenuItem.text")); // NOI18N
    userGuideMenuItem.setName("userGuideMenuItem"); // NOI18N
    helpMenu.add(userGuideMenuItem);

    menuBar.add(helpMenu);

    setComponent(mainPanel);
    setMenuBar(menuBar);
  }// </editor-fold>//GEN-END:initComponents

    private void newFlowRate(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_newFlowRate
      // see whether the value has really changed
      double newFlowRate = ((Number) flowRateFormattedTextField.getValue()).doubleValue();
      if (newFlowRate != vFlow) {
        // the value has changed ; make sure it is in range
        if (newFlowRate < 1.0) {
          vFlow = 1.0;
        } else if (newFlowRate > 50.) {
          vFlow = 50.0;
        } else {
          vFlow = newFlowRate;
        }
        flowRateFormattedTextField.setValue(new Double(vFlow));
      }
    }//GEN-LAST:event_newFlowRate
  StartTracerFlowTask flowTask;

  @Action(block = Task.BlockingScope.COMPONENT)
  public Task startTracerFlow() {
    return flowTask = new StartTracerFlowTask(getApplication());
  }

  public class MyDataPoint {
      double et, pct;
  }

  private class StartTracerFlowTask extends org.jdesktop.application.Task<Object, MyDataPoint> {
    double flowRate;
    MyDataPoint point;

    StartTracerFlowTask(org.jdesktop.application.Application app) {
      // Runs on the EDT.  Copy GUI state that
      // doInBackground() depends on from parameters
      // to StartTracerFlowTask fields, here.
      super(app);
      // disable the flow rate text field
      flowRateFormattedTextField.setEnabled(false);
      recordButton.setEnabled(true);
      // get flow rate
      flowRate = ((Number) flowRateFormattedTextField.getValue()).doubleValue();
      // change the diagram
      diagramLabel.setIcon(afterStepIcon);
      // set the tracer inlet flow rate label
      tracerFlowLabel.setText(notScientific2.format(0.01 * flowRate) + " L/min");
      // write the initial output
      String txt = "CSTR Step Response Data";
      txt += "\nNo tracer in flow prior to step.";
      txt += "\nTotal feed flow after step: " + notScientific2.format(1.01 * flowRate) + " L/min";
      txt += " containing " + notScientific4.format(1.0/1.01) + " volume percent tracer";
      txt += "\nElapsed time (min)\tOutlet Tracer Volume Percent";
      txt += "\n" + notScientific2.format(0.00) + "\t" + notScientific4.format(0.00);
      outputTextArea.setText(txt);
    }

    @Override
    protected Object doInBackground() {
      // Runs on a background thread, so don't reference
      // the Swing GUI from here.

      // allocate and initialize
      point = new MyDataPoint();
      double tau = 10.0/1.01/flowRate;
      long t0 = System.currentTimeMillis();
      double w0 = 1.0/1.01;

      // start an infinite loop
      while(true) {
        // calculate the elapsed time and the outlet volume percent
        point.et = ((double)(System.currentTimeMillis() - t0))/1000./60.;
        point.pct = w0*(1.0-Math.exp(-point.et/tau));
        point.pct += ((Math.random()*2.0)-1.0)*0.025*w0;
        publish(point);
        try {
          Thread.sleep(1000);
        } catch (InterruptedException ex) {
          return null;
        }

      }
    }

    @Override
    protected void process(List<MyDataPoint> pointList) {
      // only use the last point in the list if there is more than one
      MyDataPoint thePoint = pointList.get(pointList.size()-1);
      // update the time value label
      timeValueLabel.setText(notScientific2.format(thePoint.et));
      volumePercentValueLabel.setText(notScientific4.format(thePoint.pct));
    }

    @Override
    protected void succeeded(Object result) {
      // Runs on the EDT.  Update the GUI based on
      // the result computed by doInBackground().
    }
  }

  @Action
  public void reset() {
    JFrame mainFrame = CSTRStepResponseApp.getApplication().getMainFrame();
    int n = JOptionPane.showConfirmDialog(
            mainFrame, "This will erase the data window, continue?",
            "Reset Warning", JOptionPane.WARNING_MESSAGE,
            JOptionPane.YES_NO_OPTION);
    if (n == JOptionPane.YES_OPTION) {
      // Stop generating data
      flowTask.cancel(true);
      // Re-zero the time and volume percent values
      timeValueLabel.setText("0.00");
      volumePercentValueLabel.setText("0.00");
      // Clear the output area
      outputTextArea.setText("");
      // Reset the default values and enable the flow rate text field
      flowRateFormattedTextField.setEnabled(true);
      vFlow = 5.0;
      flowRateFormattedTextField.setValue(new Double(vFlow));
      // Change the diagram
      diagramLabel.setIcon(beforeStepIcon);
      // Remove the tracer inlet flow label
      tracerFlowLabel.setText("at 1% of Process Flow");
      recordButton.setEnabled(false);
    } else if (n == JOptionPane.NO_OPTION) {
      return;
    } else {
      return;
    }
  }

  @Action
  public void recordOutput() {
    // Append the current data point to the output data
    String dataPoint = "\n" + timeValueLabel.getText() + "\t" + volumePercentValueLabel.getText();
    outputTextArea.append(dataPoint);
  }

  @Action
  public void showUserGuide() {
    if (userGuide == null) {
      JFrame mainFrame = CSTRStepResponseApp.getApplication().getMainFrame();
      userGuide = new CSTRStepResponseUserGuide(mainFrame);
      userGuide.setLocationRelativeTo(mainFrame);
    }
    CSTRStepResponseApp.getApplication().show(userGuide);
  }

  @Action
  public void saveData() throws IOException {
    // Open a file chooser
    JFrame mainFrame = CSTRStepResponseApp.getApplication().getMainFrame();
    JFileChooser fc = new JFileChooser();
    int returnVal = fc.showSaveDialog(mainFrame);
    if (returnVal == JFileChooser.APPROVE_OPTION) {
      // the user selected a file
      File dataFile = fc.getSelectedFile();
      // open the file
      FileWriter outputStream = new FileWriter(dataFile);
      // write the data in the outputTextArea to the file
      outputTextArea.write(outputStream);
      // close the file
      outputStream.close();
    } else {
      // the user canceled
      return;
    }
  }

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JLabel diagramLabel;
  private javax.swing.JLabel flowLabel;
  private javax.swing.JFormattedTextField flowRateFormattedTextField;
  private javax.swing.JScrollPane jScrollPane1;
  private javax.swing.JPanel mainPanel;
  private javax.swing.JMenuBar menuBar;
  private javax.swing.JTextArea outputTextArea;
  private javax.swing.JButton recordButton;
  private javax.swing.JButton resetButton;
  private javax.swing.JMenuItem saveMenuItem;
  private javax.swing.JButton startTracerButton;
  private javax.swing.JLabel timeLabel;
  private javax.swing.JLabel timeValueLabel;
  private javax.swing.JLabel tracerFlowLabel;
  private javax.swing.JMenuItem userGuideMenuItem;
  private javax.swing.JLabel volumePercentLabel;
  private javax.swing.JLabel volumePercentValueLabel;
  // End of variables declaration//GEN-END:variables
  private JDialog aboutBox, userGuide;
  private double vFlow;
  private Icon beforeStepIcon,  afterStepIcon;
}
