/*
 * Decompiled with CFR 0.152.
 */
package cstrstepresponse;

import cstrstepresponse.CSTRStepResponseAboutBox;
import cstrstepresponse.CSTRStepResponseApp;
import cstrstepresponse.CSTRStepResponseUserGuide;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.Task;
import org.jdesktop.layout.GroupLayout;

public class CSTRStepResponseView
extends FrameView {
    DecimalFormat threeSigFigs = new DecimalFormat("0.00E00");
    DecimalFormat notScientific2 = new DecimalFormat("##0.00");
    DecimalFormat notScientific4 = new DecimalFormat("##0.0000");
    StartTracerFlowTask flowTask;
    private JLabel diagramLabel;
    private JLabel flowLabel;
    private JFormattedTextField flowRateFormattedTextField;
    private JScrollPane jScrollPane1;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JTextArea outputTextArea;
    private JButton recordButton;
    private JButton resetButton;
    private JMenuItem saveMenuItem;
    private JButton startTracerButton;
    private JLabel timeLabel;
    private JLabel timeValueLabel;
    private JLabel tracerFlowLabel;
    private JMenuItem userGuideMenuItem;
    private JLabel volumePercentLabel;
    private JLabel volumePercentValueLabel;
    private JDialog aboutBox;
    private JDialog userGuide;
    private double vFlow;
    private Icon beforeStepIcon;
    private Icon afterStepIcon;

    public CSTRStepResponseView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        this.vFlow = 5.0;
        this.flowRateFormattedTextField.setValue(this.vFlow);
        ResourceMap resourceMap = this.getResourceMap();
        this.afterStepIcon = resourceMap.getIcon("altDiagramLabel.icon");
        this.beforeStepIcon = resourceMap.getIcon("diagramLabel.icon");
        this.tracerFlowLabel.setText("at 1% of Process Flow");
        this.recordButton.setEnabled(false);
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = CSTRStepResponseApp.getApplication().getMainFrame();
            this.aboutBox = new CSTRStepResponseAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        CSTRStepResponseApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.diagramLabel = new JLabel();
        this.timeLabel = new JLabel();
        this.volumePercentLabel = new JLabel();
        this.timeValueLabel = new JLabel();
        this.volumePercentValueLabel = new JLabel();
        this.recordButton = new JButton();
        this.startTracerButton = new JButton();
        this.resetButton = new JButton();
        this.flowLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.outputTextArea = new JTextArea();
        this.tracerFlowLabel = new JLabel();
        this.flowRateFormattedTextField = new JFormattedTextField();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.saveMenuItem = new JMenuItem();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.userGuideMenuItem = new JMenuItem();
        this.mainPanel.setName("mainPanel");
        ResourceMap resourceMap = Application.getInstance(CSTRStepResponseApp.class).getContext().getResourceMap(CSTRStepResponseView.class);
        this.diagramLabel.setIcon(resourceMap.getIcon("diagramLabel.icon"));
        this.diagramLabel.setText(resourceMap.getString("diagramLabel.text", new Object[0]));
        this.diagramLabel.setName("diagramLabel");
        this.timeLabel.setHorizontalAlignment(0);
        this.timeLabel.setText(resourceMap.getString("timeLabel.text", new Object[0]));
        this.timeLabel.setName("timeLabel");
        this.volumePercentLabel.setHorizontalAlignment(0);
        this.volumePercentLabel.setText(resourceMap.getString("volumePercentLabel.text", new Object[0]));
        this.volumePercentLabel.setName("volumePercentLabel");
        this.timeValueLabel.setHorizontalAlignment(0);
        this.timeValueLabel.setText(resourceMap.getString("timeValueLabel.text", new Object[0]));
        this.timeValueLabel.setName("timeValueLabel");
        this.volumePercentValueLabel.setHorizontalAlignment(0);
        this.volumePercentValueLabel.setText(resourceMap.getString("volumePercentValueLabel.text", new Object[0]));
        this.volumePercentValueLabel.setName("volumePercentValueLabel");
        ApplicationActionMap actionMap = Application.getInstance(CSTRStepResponseApp.class).getContext().getActionMap(CSTRStepResponseView.class, this);
        this.recordButton.setAction(actionMap.get("recordOutput"));
        this.recordButton.setText(resourceMap.getString("recordButton.text", new Object[0]));
        this.recordButton.setName("recordButton");
        this.startTracerButton.setAction(actionMap.get("startTracerFlow"));
        this.startTracerButton.setText(resourceMap.getString("startTracerButton.text", new Object[0]));
        this.startTracerButton.setName("startTracerButton");
        this.resetButton.setAction(actionMap.get("reset"));
        this.resetButton.setText(resourceMap.getString("resetButton.text", new Object[0]));
        this.resetButton.setName("resetButton");
        this.flowLabel.setHorizontalAlignment(0);
        this.flowLabel.setText(resourceMap.getString("flowLabel.text", new Object[0]));
        this.flowLabel.setName("flowLabel");
        this.jScrollPane1.setName("jScrollPane1");
        this.outputTextArea.setColumns(20);
        this.outputTextArea.setRows(5);
        this.outputTextArea.setName("outputTextArea");
        this.jScrollPane1.setViewportView(this.outputTextArea);
        this.tracerFlowLabel.setHorizontalAlignment(0);
        this.tracerFlowLabel.setText(resourceMap.getString("tracerFlowLabel.text", new Object[0]));
        this.tracerFlowLabel.setName("tracerFlowLabel");
        this.flowRateFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.0"))));
        this.flowRateFormattedTextField.setHorizontalAlignment(0);
        this.flowRateFormattedTextField.setText(resourceMap.getString("flowRateFormattedTextField.text", new Object[0]));
        this.flowRateFormattedTextField.setToolTipText(resourceMap.getString("flowRateFormattedTextField.toolTipText", new Object[0]));
        this.flowRateFormattedTextField.setName("flowRateFormattedTextField");
        this.flowRateFormattedTextField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                CSTRStepResponseView.this.newFlowRate(evt);
            }
        });
        GroupLayout mainPanelLayout = new GroupLayout((Container)this.mainPanel);
        this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
        mainPanelLayout.setHorizontalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 678, Short.MAX_VALUE).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1, false).add((Component)this.flowLabel, -1, -1, Short.MAX_VALUE).add((Component)this.startTracerButton, -1, -1, Short.MAX_VALUE).add((Component)this.resetButton, -1, -1, Short.MAX_VALUE).add((Component)this.tracerFlowLabel, -2, 145, -2).add((Component)this.flowRateFormattedTextField)).addPreferredGap(0).add((Component)this.diagramLabel).add(18, 18, 18).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1, false).add((Component)this.recordButton, -1, -1, Short.MAX_VALUE).add((Component)this.volumePercentValueLabel, -1, -1, Short.MAX_VALUE).add((Component)this.timeLabel, -1, -1, Short.MAX_VALUE).add((Component)this.timeValueLabel, -1, -1, Short.MAX_VALUE).add((Component)this.volumePercentLabel, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        mainPanelLayout.setVerticalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((Component)this.diagramLabel).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.timeLabel).add(18, 18, 18).add((Component)this.timeValueLabel)).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add(35, 35, 35).add((Component)this.flowLabel).addPreferredGap(0).add((Component)this.flowRateFormattedTextField, -2, -1, -2))).add(6, 6, 6).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add(13, 13, 13).add((Component)this.volumePercentLabel).add(18, 18, 18).add((Component)this.volumePercentValueLabel)).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add(39, 39, 39).add((Component)this.startTracerButton))).add(6, 6, 6).add((Component)this.tracerFlowLabel).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.recordButton).add((Component)this.resetButton)))).add(18, 18, 18).add((Component)this.jScrollPane1, -1, 134, Short.MAX_VALUE).addContainerGap()));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        this.saveMenuItem.setAction(actionMap.get("saveData"));
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 5));
        this.saveMenuItem.setName("saveMenuItem");
        fileMenu.add(this.saveMenuItem);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.userGuideMenuItem.setAction(actionMap.get("showUserGuide"));
        this.userGuideMenuItem.setText(resourceMap.getString("userGuideMenuItem.text", new Object[0]));
        this.userGuideMenuItem.setName("userGuideMenuItem");
        helpMenu.add(this.userGuideMenuItem);
        this.menuBar.add(helpMenu);
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
    }

    private void newFlowRate(PropertyChangeEvent evt) {
        double newFlowRate = ((Number)this.flowRateFormattedTextField.getValue()).doubleValue();
        if (newFlowRate != this.vFlow) {
            this.vFlow = newFlowRate < 1.0 ? 1.0 : (newFlowRate > 50.0 ? 50.0 : newFlowRate);
            this.flowRateFormattedTextField.setValue(new Double(this.vFlow));
        }
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task startTracerFlow() {
        this.flowTask = new StartTracerFlowTask(this.getApplication());
        return this.flowTask;
    }

    @Action
    public void reset() {
        JFrame mainFrame = CSTRStepResponseApp.getApplication().getMainFrame();
        int n = JOptionPane.showConfirmDialog(mainFrame, "This will erase the data window, continue?", "Reset Warning", 2, 0);
        if (n != 0) {
            if (n == 1) {
                return;
            }
            return;
        }
        this.flowTask.cancel(true);
        this.timeValueLabel.setText("0.00");
        this.volumePercentValueLabel.setText("0.00");
        this.outputTextArea.setText("");
        this.flowRateFormattedTextField.setEnabled(true);
        this.vFlow = 5.0;
        this.flowRateFormattedTextField.setValue(new Double(this.vFlow));
        this.diagramLabel.setIcon(this.beforeStepIcon);
        this.tracerFlowLabel.setText("at 1% of Process Flow");
        this.recordButton.setEnabled(false);
    }

    @Action
    public void recordOutput() {
        String dataPoint = "\n" + this.timeValueLabel.getText() + "\t" + this.volumePercentValueLabel.getText();
        this.outputTextArea.append(dataPoint);
    }

    @Action
    public void showUserGuide() {
        if (this.userGuide == null) {
            JFrame mainFrame = CSTRStepResponseApp.getApplication().getMainFrame();
            this.userGuide = new CSTRStepResponseUserGuide(mainFrame);
            this.userGuide.setLocationRelativeTo(mainFrame);
        }
        CSTRStepResponseApp.getApplication().show(this.userGuide);
    }

    @Action
    public void saveData() throws IOException {
        JFileChooser fc = new JFileChooser();
        JFrame mainFrame = CSTRStepResponseApp.getApplication().getMainFrame();
        int returnVal = fc.showSaveDialog(mainFrame);
        if (returnVal != 0) {
            return;
        }
        File dataFile = fc.getSelectedFile();
        FileWriter outputStream = new FileWriter(dataFile);
        this.outputTextArea.write(outputStream);
        outputStream.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StartTracerFlowTask
    extends Task<Object, MyDataPoint> {
        double flowRate;
        MyDataPoint point;

        StartTracerFlowTask(Application app) {
            super(app);
            CSTRStepResponseView.this.flowRateFormattedTextField.setEnabled(false);
            CSTRStepResponseView.this.recordButton.setEnabled(true);
            this.flowRate = ((Number)CSTRStepResponseView.this.flowRateFormattedTextField.getValue()).doubleValue();
            CSTRStepResponseView.this.diagramLabel.setIcon(CSTRStepResponseView.this.afterStepIcon);
            CSTRStepResponseView.this.tracerFlowLabel.setText(CSTRStepResponseView.this.notScientific2.format(0.01 * this.flowRate) + " L/min");
            String txt = "CSTR Step Response Data";
            txt = txt + "\nNo tracer in flow prior to step.";
            txt = txt + "\nTotal feed flow after step: " + CSTRStepResponseView.this.notScientific2.format(1.01 * this.flowRate) + " L/min";
            txt = txt + " containing " + CSTRStepResponseView.this.notScientific4.format(0.9900990099009901) + " volume percent tracer";
            txt = txt + "\nElapsed time (min)\tOutlet Tracer Volume Percent";
            txt = txt + "\n" + CSTRStepResponseView.this.notScientific2.format(0.0) + "\t" + CSTRStepResponseView.this.notScientific4.format(0.0);
            CSTRStepResponseView.this.outputTextArea.setText(txt);
        }

        @Override
        protected Object doInBackground() {
            this.point = new MyDataPoint();
            double tau = 9.900990099009901 / this.flowRate;
            long t0 = System.currentTimeMillis();
            double w0 = 0.9900990099009901;
            while (true) {
                this.point.et = (double)(System.currentTimeMillis() - t0) / 1000.0 / 60.0;
                this.point.pct = w0 * (1.0 - Math.exp(-this.point.et / tau));
                this.point.pct += (Math.random() * 2.0 - 1.0) * 0.025 * w0;
                this.publish(this.point);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    return null;
                }
            }
        }

        @Override
        protected void process(List<MyDataPoint> pointList) {
            MyDataPoint thePoint = pointList.get(pointList.size() - 1);
            CSTRStepResponseView.this.timeValueLabel.setText(CSTRStepResponseView.this.notScientific2.format(thePoint.et));
            CSTRStepResponseView.this.volumePercentValueLabel.setText(CSTRStepResponseView.this.notScientific4.format(thePoint.pct));
        }

        @Override
        protected void succeeded(Object result) {
        }
    }

    public class MyDataPoint {
        double et;
        double pct;
    }
}

