/*
 * CSTRImpulseResponseView.java
 */
package cstrimpulseresponse;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.Icon;
import org.jdesktop.application.Action;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.FrameView;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;

/**
 * The application's main frame.
 */
public class CSTRImpulseResponseView extends FrameView {
  // A few output formats

  DecimalFormat threeSigFigs = new DecimalFormat("0.00E00");
  DecimalFormat notScientific2 = new DecimalFormat("##0.00");
  DecimalFormat notScientific4 = new DecimalFormat("##0.0000");

  public CSTRImpulseResponseView(SingleFrameApplication app) {
    super(app);

    initComponents();

    // Set default values
    tAmount = 75.0;
    tracerAmountFormattedTextField.setValue(tAmount);
    vFlow = 5.0;
    flowRateFormattedTextField.setValue(vFlow);
    ResourceMap resourceMap = getResourceMap();
    afterStepIcon = resourceMap.getIcon("altDiagramLabel.icon");
    beforeStepIcon = resourceMap.getIcon("diagramLabel.icon");
    recordButton.setEnabled(false);
  }

  @Action
  public void showAboutBox() {
    if (aboutBox == null) {
      JFrame mainFrame = CSTRImpulseResponseApp.getApplication().getMainFrame();
      aboutBox = new CSTRImpulseResponseAboutBox(mainFrame);
      aboutBox.setLocationRelativeTo(mainFrame);
    }
    CSTRImpulseResponseApp.getApplication().show(aboutBox);
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    mainPanel = new javax.swing.JPanel();
    diagramLabel = new javax.swing.JLabel();
    timeLabel = new javax.swing.JLabel();
    volumePercentLabel = new javax.swing.JLabel();
    timeValueLabel = new javax.swing.JLabel();
    volumePercentValueLabel = new javax.swing.JLabel();
    recordButton = new javax.swing.JButton();
    injectTracerButton = new javax.swing.JButton();
    resetButton = new javax.swing.JButton();
    flowLabel = new javax.swing.JLabel();
    jScrollPane1 = new javax.swing.JScrollPane();
    outputTextArea = new javax.swing.JTextArea();
    flowRateFormattedTextField = new javax.swing.JFormattedTextField();
    tracerAmountLabel = new javax.swing.JLabel();
    tracerAmountFormattedTextField = new javax.swing.JFormattedTextField();
    menuBar = new javax.swing.JMenuBar();
    javax.swing.JMenu fileMenu = new javax.swing.JMenu();
    saveMenuItem = new javax.swing.JMenuItem();
    javax.swing.JMenuItem exitMenuItem = new javax.swing.JMenuItem();
    javax.swing.JMenu helpMenu = new javax.swing.JMenu();
    javax.swing.JMenuItem aboutMenuItem = new javax.swing.JMenuItem();
    userGuideMenuItem = new javax.swing.JMenuItem();

    mainPanel.setName("mainPanel"); // NOI18N

    org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(cstrimpulseresponse.CSTRImpulseResponseApp.class).getContext().getResourceMap(CSTRImpulseResponseView.class);
    diagramLabel.setIcon(resourceMap.getIcon("diagramLabel.icon")); // NOI18N
    diagramLabel.setText(resourceMap.getString("diagramLabel.text")); // NOI18N
    diagramLabel.setName("diagramLabel"); // NOI18N

    timeLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    timeLabel.setText(resourceMap.getString("timeLabel.text")); // NOI18N
    timeLabel.setName("timeLabel"); // NOI18N

    volumePercentLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    volumePercentLabel.setText(resourceMap.getString("volumePercentLabel.text")); // NOI18N
    volumePercentLabel.setName("volumePercentLabel"); // NOI18N

    timeValueLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    timeValueLabel.setText(resourceMap.getString("timeValueLabel.text")); // NOI18N
    timeValueLabel.setName("timeValueLabel"); // NOI18N

    volumePercentValueLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    volumePercentValueLabel.setText(resourceMap.getString("volumePercentValueLabel.text")); // NOI18N
    volumePercentValueLabel.setName("volumePercentValueLabel"); // NOI18N

    javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(cstrimpulseresponse.CSTRImpulseResponseApp.class).getContext().getActionMap(CSTRImpulseResponseView.class, this);
    recordButton.setAction(actionMap.get("recordOutput")); // NOI18N
    recordButton.setText(resourceMap.getString("recordButton.text")); // NOI18N
    recordButton.setName("recordButton"); // NOI18N

    injectTracerButton.setAction(actionMap.get("startTracerFlow")); // NOI18N
    injectTracerButton.setText(resourceMap.getString("injectTracerButton.text")); // NOI18N
    injectTracerButton.setName("injectTracerButton"); // NOI18N

    resetButton.setAction(actionMap.get("reset")); // NOI18N
    resetButton.setText(resourceMap.getString("resetButton.text")); // NOI18N
    resetButton.setName("resetButton"); // NOI18N

    flowLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    flowLabel.setText(resourceMap.getString("flowLabel.text")); // NOI18N
    flowLabel.setName("flowLabel"); // NOI18N

    jScrollPane1.setName("jScrollPane1"); // NOI18N

    outputTextArea.setColumns(20);
    outputTextArea.setRows(5);
    outputTextArea.setName("outputTextArea"); // NOI18N
    jScrollPane1.setViewportView(outputTextArea);

    flowRateFormattedTextField.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0.0"))));
    flowRateFormattedTextField.setHorizontalAlignment(javax.swing.JTextField.CENTER);
    flowRateFormattedTextField.setText(resourceMap.getString("flowRateFormattedTextField.text")); // NOI18N
    flowRateFormattedTextField.setToolTipText(resourceMap.getString("flowRateFormattedTextField.toolTipText")); // NOI18N
    flowRateFormattedTextField.setName("flowRateFormattedTextField"); // NOI18N
    flowRateFormattedTextField.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
      public void propertyChange(java.beans.PropertyChangeEvent evt) {
        newFlowRate(evt);
      }
    });

    tracerAmountLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    tracerAmountLabel.setText(resourceMap.getString("tracerAmountLabel.text")); // NOI18N
    tracerAmountLabel.setName("tracerAmountLabel"); // NOI18N

    tracerAmountFormattedTextField.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#,##0"))));
    tracerAmountFormattedTextField.setHorizontalAlignment(javax.swing.JTextField.CENTER);
    tracerAmountFormattedTextField.setText(resourceMap.getString("tracerAmountFormattedTextField.text")); // NOI18N
    tracerAmountFormattedTextField.setToolTipText(resourceMap.getString("tracerAmountFormattedTextField.toolTipText")); // NOI18N
    tracerAmountFormattedTextField.setName("tracerAmountFormattedTextField"); // NOI18N
    tracerAmountFormattedTextField.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
      public void propertyChange(java.beans.PropertyChangeEvent evt) {
        newTracerAmount(evt);
      }
    });

    org.jdesktop.layout.GroupLayout mainPanelLayout = new org.jdesktop.layout.GroupLayout(mainPanel);
    mainPanel.setLayout(mainPanelLayout);
    mainPanelLayout.setHorizontalGroup(
      mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(mainPanelLayout.createSequentialGroup()
        .addContainerGap()
        .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
          .add(mainPanelLayout.createSequentialGroup()
            .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
              .add(org.jdesktop.layout.GroupLayout.LEADING, resetButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 88, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
              .add(org.jdesktop.layout.GroupLayout.LEADING, tracerAmountLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
              .add(flowRateFormattedTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 141, Short.MAX_VALUE)
              .add(flowLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
              .add(org.jdesktop.layout.GroupLayout.LEADING, tracerAmountFormattedTextField))
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 11, Short.MAX_VALUE)
            .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
              .add(mainPanelLayout.createSequentialGroup()
                .add(diagramLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                  .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(volumePercentValueLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(timeLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(timeValueLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(volumePercentLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                  .add(recordButton)))
              .add(injectTracerButton)))
          .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 628, Short.MAX_VALUE))
        .addContainerGap())
    );
    mainPanelLayout.setVerticalGroup(
      mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(mainPanelLayout.createSequentialGroup()
        .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
          .add(mainPanelLayout.createSequentialGroup()
            .addContainerGap()
            .add(timeLabel)
            .add(18, 18, 18)
            .add(timeValueLabel)
            .add(19, 19, 19)
            .add(volumePercentLabel)
            .add(18, 18, 18)
            .add(volumePercentValueLabel)
            .add(18, 18, 18)
            .add(recordButton))
          .add(mainPanelLayout.createSequentialGroup()
            .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
              .add(diagramLabel)
              .add(mainPanelLayout.createSequentialGroup()
                .add(35, 35, 35)
                .add(flowLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(flowRateFormattedTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(32, 32, 32)
                .add(tracerAmountLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(tracerAmountFormattedTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
              .add(injectTracerButton)
              .add(resetButton))))
        .add(18, 18, 18)
        .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 229, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        .addContainerGap(21, Short.MAX_VALUE))
    );

    menuBar.setName("menuBar"); // NOI18N

    fileMenu.setText(resourceMap.getString("fileMenu.text")); // NOI18N
    fileMenu.setName("fileMenu"); // NOI18N

    saveMenuItem.setAction(actionMap.get("saveData")); // NOI18N
    saveMenuItem.setName("saveMenuItem"); // NOI18N
    fileMenu.add(saveMenuItem);

    exitMenuItem.setAction(actionMap.get("quit")); // NOI18N
    exitMenuItem.setName("exitMenuItem"); // NOI18N
    fileMenu.add(exitMenuItem);

    menuBar.add(fileMenu);

    helpMenu.setText(resourceMap.getString("helpMenu.text")); // NOI18N
    helpMenu.setName("helpMenu"); // NOI18N

    aboutMenuItem.setAction(actionMap.get("showAboutBox")); // NOI18N
    aboutMenuItem.setName("aboutMenuItem"); // NOI18N
    helpMenu.add(aboutMenuItem);

    userGuideMenuItem.setAction(actionMap.get("showUserGuide")); // NOI18N
    userGuideMenuItem.setText(resourceMap.getString("userGuideMenuItem.text")); // NOI18N
    userGuideMenuItem.setName("userGuideMenuItem"); // NOI18N
    helpMenu.add(userGuideMenuItem);

    menuBar.add(helpMenu);

    setComponent(mainPanel);
    setMenuBar(menuBar);
  }// </editor-fold>//GEN-END:initComponents

    private void newFlowRate(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_newFlowRate
      // see whether the value has really changed
      double newFlowRate = ((Number) flowRateFormattedTextField.getValue()).doubleValue();
      if (newFlowRate != vFlow) {
        // the value has changed ; make sure it is in range
        if (newFlowRate < 1.0) {
          vFlow = 1.0;
        } else if (newFlowRate > 50.) {
          vFlow = 50.0;
        } else {
          vFlow = newFlowRate;
        }
        flowRateFormattedTextField.setValue(new Double(vFlow));
      }
    }//GEN-LAST:event_newFlowRate

    private void newTracerAmount(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_newTracerAmount
      // see whether the value has really changed
      double newAmount = ((Number) tracerAmountFormattedTextField.getValue()).doubleValue();
      if (newAmount != tAmount) {
        // the value has changed ; make sure it is in range
        if (newAmount < 1.0) {
          tAmount = 1.0;
        } else if (newAmount > 250.) {
          tAmount = 250.0;
        } else {
          tAmount = newAmount;
        }
        tracerAmountFormattedTextField.setValue(new Double(tAmount));
      }
    }//GEN-LAST:event_newTracerAmount
  StartTracerFlowTask flowTask;

  @Action(block = Task.BlockingScope.COMPONENT)
  public Task startTracerFlow() {
    return flowTask = new StartTracerFlowTask(getApplication());
  }

  public class MyDataPoint {
      double et, pct;
  }

  private class StartTracerFlowTask extends org.jdesktop.application.Task<Object, MyDataPoint> {
    double flowRate, w0;
    MyDataPoint point;

    StartTracerFlowTask(org.jdesktop.application.Application app) {
      // Runs on the EDT.  Copy GUI state that
      // doInBackground() depends on from parameters
      // to StartTracerFlowTask fields, here.
      super(app);
      // disable the flow rate and tracer amount text fields
      flowRateFormattedTextField.setEnabled(false);
      tracerAmountFormattedTextField.setEnabled(false);
      recordButton.setEnabled(true);
      // get flow rate and amount injected
      flowRate = ((Number) flowRateFormattedTextField.getValue()).doubleValue();
      double amount = ((Number) tracerAmountFormattedTextField.getValue()).doubleValue();
      // calculate the initial concentration
      w0 = amount/100.0;
      // change the diagram
      diagramLabel.setIcon(afterStepIcon);
      // write the initial output
      String txt = "CSTR Impulse Response Data";
      txt += "\nNo tracer in flow prior to injection.";
      txt += "\nTotal feed flow: " + notScientific2.format(flowRate) + " L/min";
      txt += "\nAmount of tracer injected: " + notScientific2.format(amount) + " mL";
      txt += "\nElapsed time (min)\tOutlet Tracer Volume Percent";
      txt += "\n" + notScientific2.format(0.00) + "\t" + notScientific4.format(0.00);
      outputTextArea.setText(txt);
    }

    @Override
    protected Object doInBackground() {
      // Runs on a background thread, so don't reference
      // the Swing GUI from here.

      // allocate and initialize
      point = new MyDataPoint();
      double tau = 10.0/flowRate;
      long t0 = System.currentTimeMillis();

      // start an infinite loop
      while(true) {
        // calculate the elapsed time and the outlet volume percent
        point.et = ((double)(System.currentTimeMillis() - t0))/1000./60.;
        point.pct = w0*(Math.exp(-point.et/tau));
        point.pct += ((Math.random()*2.0)-1.0)*0.025*w0;
        publish(point);
        try {
          Thread.sleep(1000);
        } catch (InterruptedException ex) {
          return null;
        }

      }
    }

    @Override
    protected void process(List<MyDataPoint> pointList) {
      // only use the last point in the list if there is more than one
      MyDataPoint thePoint = pointList.get(pointList.size()-1);
      // update the time value label
      timeValueLabel.setText(notScientific2.format(thePoint.et));
      volumePercentValueLabel.setText(notScientific4.format(thePoint.pct));
    }

    @Override
    protected void succeeded(Object result) {
      // Runs on the EDT.  Update the GUI based on
      // the result computed by doInBackground().
    }
  }

  @Action
  public void reset() {
    JFrame mainFrame = CSTRImpulseResponseApp.getApplication().getMainFrame();
    int n = JOptionPane.showConfirmDialog(
            mainFrame, "This will erase the data window, continue?",
            "Reset Warning", JOptionPane.WARNING_MESSAGE,
            JOptionPane.YES_NO_OPTION);
    if (n == JOptionPane.YES_OPTION) {
      // Stop generating data
      flowTask.cancel(true);
      // Re-zero the time and volume percent values
      timeValueLabel.setText("0.00");
      volumePercentValueLabel.setText("0.00");
      // Clear the output area
      outputTextArea.setText("");
      // Reset the default values and enable the flow rate text field
      flowRateFormattedTextField.setEnabled(true);
      vFlow = 5.0;
      flowRateFormattedTextField.setValue(new Double(vFlow));
      tracerAmountFormattedTextField.setEnabled(true);
      tAmount = 75.0;
      tracerAmountFormattedTextField.setValue(tAmount);
      // Change the diagram
      diagramLabel.setIcon(beforeStepIcon);
      recordButton.setEnabled(false);
    } else if (n == JOptionPane.NO_OPTION) {
      return;
    } else {
      return;
    }
  }

  @Action
  public void recordOutput() {
    // Append the current data point to the output data
    String dataPoint = "\n" + timeValueLabel.getText() + "\t" + volumePercentValueLabel.getText();
    outputTextArea.append(dataPoint);
  }

  @Action
  public void showUserGuide() {
    if (userGuide == null) {
      JFrame mainFrame = CSTRImpulseResponseApp.getApplication().getMainFrame();
      userGuide = new CSTRImpulseResponseUserGuide(mainFrame);
      userGuide.setLocationRelativeTo(mainFrame);
    }
    CSTRImpulseResponseApp.getApplication().show(userGuide);
  }

  @Action
  public void saveData() throws IOException {
    // Open a file chooser
    JFrame mainFrame = CSTRImpulseResponseApp.getApplication().getMainFrame();
    JFileChooser fc = new JFileChooser();
    int returnVal = fc.showSaveDialog(mainFrame);
    if (returnVal == JFileChooser.APPROVE_OPTION) {
      // the user selected a file
      File dataFile = fc.getSelectedFile();
      // open the file
      FileWriter outputStream = new FileWriter(dataFile);
      // write the data in the outputTextArea to the file
      outputTextArea.write(outputStream);
      // close the file
      outputStream.close();
    } else {
      // the user canceled
      return;
    }
  }

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JLabel diagramLabel;
  private javax.swing.JLabel flowLabel;
  private javax.swing.JFormattedTextField flowRateFormattedTextField;
  private javax.swing.JButton injectTracerButton;
  private javax.swing.JScrollPane jScrollPane1;
  private javax.swing.JPanel mainPanel;
  private javax.swing.JMenuBar menuBar;
  private javax.swing.JTextArea outputTextArea;
  private javax.swing.JButton recordButton;
  private javax.swing.JButton resetButton;
  private javax.swing.JMenuItem saveMenuItem;
  private javax.swing.JLabel timeLabel;
  private javax.swing.JLabel timeValueLabel;
  private javax.swing.JFormattedTextField tracerAmountFormattedTextField;
  private javax.swing.JLabel tracerAmountLabel;
  private javax.swing.JMenuItem userGuideMenuItem;
  private javax.swing.JLabel volumePercentLabel;
  private javax.swing.JLabel volumePercentValueLabel;
  // End of variables declaration//GEN-END:variables
  private JDialog aboutBox, userGuide;
  private double vFlow, tAmount;
  private Icon beforeStepIcon,  afterStepIcon;
}
