/*
 * Decompiled with CFR 0.152.
 */
package cstrimpulseresponse;

import cstrimpulseresponse.CSTRImpulseResponseAboutBox;
import cstrimpulseresponse.CSTRImpulseResponseApp;
import cstrimpulseresponse.CSTRImpulseResponseUserGuide;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.Task;
import org.jdesktop.layout.GroupLayout;

public class CSTRImpulseResponseView
extends FrameView {
    DecimalFormat threeSigFigs = new DecimalFormat("0.00E00");
    DecimalFormat notScientific2 = new DecimalFormat("##0.00");
    DecimalFormat notScientific4 = new DecimalFormat("##0.0000");
    StartTracerFlowTask flowTask;
    private JLabel diagramLabel;
    private JLabel flowLabel;
    private JFormattedTextField flowRateFormattedTextField;
    private JButton injectTracerButton;
    private JScrollPane jScrollPane1;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JTextArea outputTextArea;
    private JButton recordButton;
    private JButton resetButton;
    private JMenuItem saveMenuItem;
    private JLabel timeLabel;
    private JLabel timeValueLabel;
    private JFormattedTextField tracerAmountFormattedTextField;
    private JLabel tracerAmountLabel;
    private JMenuItem userGuideMenuItem;
    private JLabel volumePercentLabel;
    private JLabel volumePercentValueLabel;
    private JDialog aboutBox;
    private JDialog userGuide;
    private double vFlow;
    private double tAmount;
    private Icon beforeStepIcon;
    private Icon afterStepIcon;

    public CSTRImpulseResponseView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        this.tAmount = 75.0;
        this.tracerAmountFormattedTextField.setValue(this.tAmount);
        this.vFlow = 5.0;
        this.flowRateFormattedTextField.setValue(this.vFlow);
        ResourceMap resourceMap = this.getResourceMap();
        this.afterStepIcon = resourceMap.getIcon("altDiagramLabel.icon");
        this.beforeStepIcon = resourceMap.getIcon("diagramLabel.icon");
        this.recordButton.setEnabled(false);
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = CSTRImpulseResponseApp.getApplication().getMainFrame();
            this.aboutBox = new CSTRImpulseResponseAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        CSTRImpulseResponseApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.diagramLabel = new JLabel();
        this.timeLabel = new JLabel();
        this.volumePercentLabel = new JLabel();
        this.timeValueLabel = new JLabel();
        this.volumePercentValueLabel = new JLabel();
        this.recordButton = new JButton();
        this.injectTracerButton = new JButton();
        this.resetButton = new JButton();
        this.flowLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.outputTextArea = new JTextArea();
        this.flowRateFormattedTextField = new JFormattedTextField();
        this.tracerAmountLabel = new JLabel();
        this.tracerAmountFormattedTextField = new JFormattedTextField();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.saveMenuItem = new JMenuItem();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.userGuideMenuItem = new JMenuItem();
        this.mainPanel.setName("mainPanel");
        ResourceMap resourceMap = Application.getInstance(CSTRImpulseResponseApp.class).getContext().getResourceMap(CSTRImpulseResponseView.class);
        this.diagramLabel.setIcon(resourceMap.getIcon("diagramLabel.icon"));
        this.diagramLabel.setText(resourceMap.getString("diagramLabel.text", new Object[0]));
        this.diagramLabel.setName("diagramLabel");
        this.timeLabel.setHorizontalAlignment(0);
        this.timeLabel.setText(resourceMap.getString("timeLabel.text", new Object[0]));
        this.timeLabel.setName("timeLabel");
        this.volumePercentLabel.setHorizontalAlignment(0);
        this.volumePercentLabel.setText(resourceMap.getString("volumePercentLabel.text", new Object[0]));
        this.volumePercentLabel.setName("volumePercentLabel");
        this.timeValueLabel.setHorizontalAlignment(0);
        this.timeValueLabel.setText(resourceMap.getString("timeValueLabel.text", new Object[0]));
        this.timeValueLabel.setName("timeValueLabel");
        this.volumePercentValueLabel.setHorizontalAlignment(0);
        this.volumePercentValueLabel.setText(resourceMap.getString("volumePercentValueLabel.text", new Object[0]));
        this.volumePercentValueLabel.setName("volumePercentValueLabel");
        ApplicationActionMap actionMap = Application.getInstance(CSTRImpulseResponseApp.class).getContext().getActionMap(CSTRImpulseResponseView.class, this);
        this.recordButton.setAction(actionMap.get("recordOutput"));
        this.recordButton.setText(resourceMap.getString("recordButton.text", new Object[0]));
        this.recordButton.setName("recordButton");
        this.injectTracerButton.setAction(actionMap.get("startTracerFlow"));
        this.injectTracerButton.setText(resourceMap.getString("injectTracerButton.text", new Object[0]));
        this.injectTracerButton.setName("injectTracerButton");
        this.resetButton.setAction(actionMap.get("reset"));
        this.resetButton.setText(resourceMap.getString("resetButton.text", new Object[0]));
        this.resetButton.setName("resetButton");
        this.flowLabel.setHorizontalAlignment(0);
        this.flowLabel.setText(resourceMap.getString("flowLabel.text", new Object[0]));
        this.flowLabel.setName("flowLabel");
        this.jScrollPane1.setName("jScrollPane1");
        this.outputTextArea.setColumns(20);
        this.outputTextArea.setRows(5);
        this.outputTextArea.setName("outputTextArea");
        this.jScrollPane1.setViewportView(this.outputTextArea);
        this.flowRateFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.0"))));
        this.flowRateFormattedTextField.setHorizontalAlignment(0);
        this.flowRateFormattedTextField.setText(resourceMap.getString("flowRateFormattedTextField.text", new Object[0]));
        this.flowRateFormattedTextField.setToolTipText(resourceMap.getString("flowRateFormattedTextField.toolTipText", new Object[0]));
        this.flowRateFormattedTextField.setName("flowRateFormattedTextField");
        this.flowRateFormattedTextField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                CSTRImpulseResponseView.this.newFlowRate(evt);
            }
        });
        this.tracerAmountLabel.setHorizontalAlignment(0);
        this.tracerAmountLabel.setText(resourceMap.getString("tracerAmountLabel.text", new Object[0]));
        this.tracerAmountLabel.setName("tracerAmountLabel");
        this.tracerAmountFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0"))));
        this.tracerAmountFormattedTextField.setHorizontalAlignment(0);
        this.tracerAmountFormattedTextField.setText(resourceMap.getString("tracerAmountFormattedTextField.text", new Object[0]));
        this.tracerAmountFormattedTextField.setToolTipText(resourceMap.getString("tracerAmountFormattedTextField.toolTipText", new Object[0]));
        this.tracerAmountFormattedTextField.setName("tracerAmountFormattedTextField");
        this.tracerAmountFormattedTextField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                CSTRImpulseResponseView.this.newTracerAmount(evt);
            }
        });
        GroupLayout mainPanelLayout = new GroupLayout((Container)this.mainPanel);
        this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
        mainPanelLayout.setHorizontalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(2, false).add(1, (Component)this.resetButton, -2, 88, -2).add(1, (Component)this.tracerAmountLabel, -1, -1, Short.MAX_VALUE).add((Component)this.flowRateFormattedTextField, -1, 141, Short.MAX_VALUE).add((Component)this.flowLabel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.tracerAmountFormattedTextField)).addPreferredGap(0, 11, Short.MAX_VALUE).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((Component)this.diagramLabel).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1, false).add((Component)this.volumePercentValueLabel, -1, -1, Short.MAX_VALUE).add((Component)this.timeLabel, -1, -1, Short.MAX_VALUE).add((Component)this.timeValueLabel, -1, -1, Short.MAX_VALUE).add((Component)this.volumePercentLabel, -1, -1, Short.MAX_VALUE)).add((Component)this.recordButton))).add((Component)this.injectTracerButton))).add((Component)this.jScrollPane1, -1, 628, Short.MAX_VALUE)).addContainerGap()));
        mainPanelLayout.setVerticalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.timeLabel).add(18, 18, 18).add((Component)this.timeValueLabel).add(19, 19, 19).add((Component)this.volumePercentLabel).add(18, 18, 18).add((Component)this.volumePercentValueLabel).add(18, 18, 18).add((Component)this.recordButton)).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((Component)this.diagramLabel).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add(35, 35, 35).add((Component)this.flowLabel).addPreferredGap(0).add((Component)this.flowRateFormattedTextField, -2, -1, -2).add(32, 32, 32).add((Component)this.tracerAmountLabel).addPreferredGap(0).add((Component)this.tracerAmountFormattedTextField, -2, -1, -2))).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.injectTracerButton).add((Component)this.resetButton)))).add(18, 18, 18).add((Component)this.jScrollPane1, -2, 229, -2).addContainerGap(21, Short.MAX_VALUE)));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        this.saveMenuItem.setAction(actionMap.get("saveData"));
        this.saveMenuItem.setName("saveMenuItem");
        fileMenu.add(this.saveMenuItem);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.userGuideMenuItem.setAction(actionMap.get("showUserGuide"));
        this.userGuideMenuItem.setText(resourceMap.getString("userGuideMenuItem.text", new Object[0]));
        this.userGuideMenuItem.setName("userGuideMenuItem");
        helpMenu.add(this.userGuideMenuItem);
        this.menuBar.add(helpMenu);
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
    }

    private void newFlowRate(PropertyChangeEvent evt) {
        double newFlowRate = ((Number)this.flowRateFormattedTextField.getValue()).doubleValue();
        if (newFlowRate != this.vFlow) {
            this.vFlow = newFlowRate < 1.0 ? 1.0 : (newFlowRate > 50.0 ? 50.0 : newFlowRate);
            this.flowRateFormattedTextField.setValue(new Double(this.vFlow));
        }
    }

    private void newTracerAmount(PropertyChangeEvent evt) {
        double newAmount = ((Number)this.tracerAmountFormattedTextField.getValue()).doubleValue();
        if (newAmount != this.tAmount) {
            this.tAmount = newAmount < 1.0 ? 1.0 : (newAmount > 250.0 ? 250.0 : newAmount);
            this.tracerAmountFormattedTextField.setValue(new Double(this.tAmount));
        }
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task startTracerFlow() {
        this.flowTask = new StartTracerFlowTask(this.getApplication());
        return this.flowTask;
    }

    @Action
    public void reset() {
        JFrame mainFrame = CSTRImpulseResponseApp.getApplication().getMainFrame();
        int n = JOptionPane.showConfirmDialog(mainFrame, "This will erase the data window, continue?", "Reset Warning", 2, 0);
        if (n != 0) {
            if (n == 1) {
                return;
            }
            return;
        }
        this.flowTask.cancel(true);
        this.timeValueLabel.setText("0.00");
        this.volumePercentValueLabel.setText("0.00");
        this.outputTextArea.setText("");
        this.flowRateFormattedTextField.setEnabled(true);
        this.vFlow = 5.0;
        this.flowRateFormattedTextField.setValue(new Double(this.vFlow));
        this.tracerAmountFormattedTextField.setEnabled(true);
        this.tAmount = 75.0;
        this.tracerAmountFormattedTextField.setValue(this.tAmount);
        this.diagramLabel.setIcon(this.beforeStepIcon);
        this.recordButton.setEnabled(false);
    }

    @Action
    public void recordOutput() {
        String dataPoint = "\n" + this.timeValueLabel.getText() + "\t" + this.volumePercentValueLabel.getText();
        this.outputTextArea.append(dataPoint);
    }

    @Action
    public void showUserGuide() {
        if (this.userGuide == null) {
            JFrame mainFrame = CSTRImpulseResponseApp.getApplication().getMainFrame();
            this.userGuide = new CSTRImpulseResponseUserGuide(mainFrame);
            this.userGuide.setLocationRelativeTo(mainFrame);
        }
        CSTRImpulseResponseApp.getApplication().show(this.userGuide);
    }

    @Action
    public void saveData() throws IOException {
        JFileChooser fc = new JFileChooser();
        JFrame mainFrame = CSTRImpulseResponseApp.getApplication().getMainFrame();
        int returnVal = fc.showSaveDialog(mainFrame);
        if (returnVal != 0) {
            return;
        }
        File dataFile = fc.getSelectedFile();
        FileWriter outputStream = new FileWriter(dataFile);
        this.outputTextArea.write(outputStream);
        outputStream.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StartTracerFlowTask
    extends Task<Object, MyDataPoint> {
        double flowRate;
        double w0;
        MyDataPoint point;

        StartTracerFlowTask(Application app) {
            super(app);
            CSTRImpulseResponseView.this.flowRateFormattedTextField.setEnabled(false);
            CSTRImpulseResponseView.this.tracerAmountFormattedTextField.setEnabled(false);
            CSTRImpulseResponseView.this.recordButton.setEnabled(true);
            this.flowRate = ((Number)CSTRImpulseResponseView.this.flowRateFormattedTextField.getValue()).doubleValue();
            double amount = ((Number)CSTRImpulseResponseView.this.tracerAmountFormattedTextField.getValue()).doubleValue();
            this.w0 = amount / 100.0;
            CSTRImpulseResponseView.this.diagramLabel.setIcon(CSTRImpulseResponseView.this.afterStepIcon);
            String txt = "CSTR Impulse Response Data";
            txt = txt + "\nNo tracer in flow prior to injection.";
            txt = txt + "\nTotal feed flow: " + CSTRImpulseResponseView.this.notScientific2.format(this.flowRate) + " L/min";
            txt = txt + "\nAmount of tracer injected: " + CSTRImpulseResponseView.this.notScientific2.format(amount) + " mL";
            txt = txt + "\nElapsed time (min)\tOutlet Tracer Volume Percent";
            txt = txt + "\n" + CSTRImpulseResponseView.this.notScientific2.format(0.0) + "\t" + CSTRImpulseResponseView.this.notScientific4.format(0.0);
            CSTRImpulseResponseView.this.outputTextArea.setText(txt);
        }

        @Override
        protected Object doInBackground() {
            this.point = new MyDataPoint();
            double tau = 10.0 / this.flowRate;
            long t0 = System.currentTimeMillis();
            while (true) {
                this.point.et = (double)(System.currentTimeMillis() - t0) / 1000.0 / 60.0;
                this.point.pct = this.w0 * Math.exp(-this.point.et / tau);
                this.point.pct += (Math.random() * 2.0 - 1.0) * 0.025 * this.w0;
                this.publish(this.point);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    return null;
                }
            }
        }

        @Override
        protected void process(List<MyDataPoint> pointList) {
            MyDataPoint thePoint = pointList.get(pointList.size() - 1);
            CSTRImpulseResponseView.this.timeValueLabel.setText(CSTRImpulseResponseView.this.notScientific2.format(thePoint.et));
            CSTRImpulseResponseView.this.volumePercentValueLabel.setText(CSTRImpulseResponseView.this.notScientific4.format(thePoint.pct));
        }

        @Override
        protected void succeeded(Object result) {
        }
    }

    public class MyDataPoint {
        double et;
        double pct;
    }
}

