/*
 * Decompiled with CFR 0.152.
 */
package numeth;

import java.text.DecimalFormat;
import numeth.NMMatrixOperator;
import numeth.NMResult;
import numeth.NMSimplexFcn;
import numeth.NMSimplexListener;

public class NMSimplexOptimizer
implements NMSimplexListener {
    private NMSimplexFcn fcn;
    private int nParams;
    private int errorExpandCount;
    private boolean hasBounds = false;
    private boolean[] hasUpperBound;
    private boolean[] hasLowerBound;
    private double tol;
    private double roundingErrorCutoff;
    private double[] upperBound;
    private double[] lowerBound;
    private double[][] vertex;
    private NMSimplexListener theListener;

    public NMResult minimize(int maxIts, double[] guess) {
        String[] eMsg = new String[]{" ", "NMSimplexOptimizer.minimize: too few vertices ", "NMSimplexOptimizer.minimize: error while adjusting simplex", "NMSimplexOptimizer.minimize: error evaluating objective function", "NMSimplexOptimizer.minimize: did not converge to within specified tolerance"};
        NMResult theResult = new NMResult();
        double bestSoFar = 1.0E99;
        int lowVert = 0;
        int highVert = 0;
        for (int i = 0; i < this.nParams + 1; ++i) {
            this.vertex[this.nParams][i] = guess[i];
        }
        NMResult checkResult = this.checkVertices();
        if (theResult.getStatus() > 0) {
            theResult.setStatus(1, eMsg[1], checkResult);
            return theResult;
        }
        for (int iter = 0; iter < maxIts; ++iter) {
            int j;
            int i;
            NMResult consResult;
            int i2;
            int i3;
            int i4;
            double lowVal;
            double highVal = lowVal = this.vertex[0][this.nParams];
            lowVert = 0;
            highVert = 0;
            for (int i5 = 1; i5 < this.nParams + 1; ++i5) {
                if (this.vertex[i5][this.nParams] > highVal) {
                    highVal = this.vertex[i5][this.nParams];
                    highVert = i5;
                }
                if (!(this.vertex[i5][this.nParams] < lowVal)) continue;
                lowVal = this.vertex[i5][this.nParams];
                lowVert = i5;
            }
            double nHighVal = lowVal;
            for (i4 = 0; i4 < this.nParams + 1; ++i4) {
                if (i4 == highVert || !(this.vertex[i4][this.nParams] > nHighVal)) continue;
                nHighVal = this.vertex[i4][this.nParams];
            }
            this.theListener.call(iter, this.vertex[lowVert][this.nParams]);
            for (i4 = 0; i4 < this.nParams + 1; ++i4) {
                guess[i4] = this.vertex[lowVert][i4];
            }
            double rtol = 2.0 * Math.abs(this.vertex[highVert][this.nParams] - this.vertex[lowVert][this.nParams]);
            if ((rtol /= Math.abs(this.vertex[highVert][this.nParams] + this.vertex[lowVert][this.nParams])) < this.tol) {
                for (int i6 = 0; i6 < this.nParams + 1; ++i6) {
                    guess[i6] = this.vertex[lowVert][i6];
                }
                return theResult;
            }
            double[] center = new double[this.nParams];
            for (i3 = 0; i3 < this.nParams; ++i3) {
                center[i3] = 0.0;
            }
            for (int j2 = 0; j2 < this.nParams; ++j2) {
                for (i2 = 0; i2 < this.nParams + 1; ++i2) {
                    if (i2 == highVert) continue;
                    int n = j2;
                    center[n] = center[n] + this.vertex[i2][j2];
                }
            }
            for (i3 = 0; i3 < this.nParams; ++i3) {
                center[i3] = center[i3] / (double)this.nParams;
            }
            double[] test1 = new double[this.nParams + 1];
            for (i2 = 0; i2 < this.nParams; ++i2) {
                test1[i2] = 2.0 * center[i2] - this.vertex[highVert][i2];
            }
            if (this.hasBounds && (consResult = this.constrain(this.vertex[highVert], test1)).getStatus() != 0) {
                theResult.setStatus(2, eMsg[2], consResult);
                return theResult;
            }
            NMResult evalResult = this.fcn.evalSimplexFcn(test1);
            if (evalResult.getStatus() > 0) {
                theResult.setStatus(3, eMsg[3], evalResult);
                return theResult;
            }
            if (lowVal <= test1[this.nParams] && test1[this.nParams] < nHighVal) {
                for (int i7 = 0; i7 < this.nParams + 1; ++i7) {
                    this.vertex[highVert][i7] = test1[i7];
                }
                continue;
            }
            if (test1[this.nParams] < lowVal) {
                double[] test2 = new double[this.nParams + 1];
                for (i = 0; i < this.nParams; ++i) {
                    test2[i] = 3.0 * center[i] - 2.0 * this.vertex[highVert][i];
                }
                if (this.hasBounds && (consResult = this.constrain(this.vertex[highVert], test2)).getStatus() != 0) {
                    theResult.setStatus(2, eMsg[2], consResult);
                    return theResult;
                }
                evalResult = this.fcn.evalSimplexFcn(test2);
                if (evalResult.getStatus() > 0) {
                    theResult.setStatus(3, eMsg[3], evalResult);
                    return theResult;
                }
                if (test2[this.nParams] < test1[this.nParams]) {
                    for (i = 0; i < this.nParams + 1; ++i) {
                        this.vertex[highVert][i] = test2[i];
                    }
                    continue;
                }
                for (i = 0; i < this.nParams + 1; ++i) {
                    this.vertex[highVert][i] = test1[i];
                }
                continue;
            }
            if (test1[this.nParams] < highVal) {
                double[] test2 = new double[this.nParams + 1];
                for (i = 0; i < this.nParams; ++i) {
                    test2[i] = 1.5 * center[i] - 0.5 * this.vertex[highVert][i];
                }
                if (this.hasBounds && (consResult = this.constrain(this.vertex[highVert], test2)).getStatus() != 0) {
                    theResult.setStatus(2, eMsg[2], consResult);
                    return theResult;
                }
                evalResult = this.fcn.evalSimplexFcn(test2);
                if (evalResult.getStatus() > 0) {
                    theResult.setStatus(3, eMsg[3], evalResult);
                    return theResult;
                }
                if (test2[this.nParams] <= test1[this.nParams]) {
                    for (i = 0; i < this.nParams + 1; ++i) {
                        this.vertex[highVert][i] = test2[i];
                    }
                    continue;
                }
                for (i = 0; i < this.nParams + 1; ++i) {
                    if (i == lowVert) continue;
                    for (j = 0; j < this.nParams; ++j) {
                        test2[j] = 0.5 * this.vertex[i][j] + 0.5 * this.vertex[lowVert][j];
                    }
                    evalResult = this.fcn.evalSimplexFcn(test1);
                    if (evalResult.getStatus() > 0) {
                        theResult.setStatus(3, eMsg[3], evalResult);
                        return theResult;
                    }
                    for (j = 0; j < this.nParams + 1; ++j) {
                        this.vertex[i][j] = test2[j];
                    }
                }
                continue;
            }
            if (!(test1[this.nParams] > highVal)) continue;
            double[] test2 = new double[this.nParams + 1];
            for (i = 0; i < this.nParams; ++i) {
                test2[i] = 0.5 * center[i] + 0.5 * this.vertex[highVert][i];
            }
            if (this.hasBounds && (consResult = this.constrain(this.vertex[highVert], test2)).getStatus() != 0) {
                theResult.setStatus(2, eMsg[2], consResult);
                return theResult;
            }
            evalResult = this.fcn.evalSimplexFcn(test2);
            if (evalResult.getStatus() > 0) {
                theResult.setStatus(3, eMsg[3], evalResult);
                return theResult;
            }
            if (test2[this.nParams] <= highVal) {
                for (i = 0; i < this.nParams + 1; ++i) {
                    this.vertex[highVert][i] = test2[i];
                }
                continue;
            }
            for (i = 0; i < this.nParams + 1; ++i) {
                if (i == lowVert) continue;
                for (j = 0; j < this.nParams; ++j) {
                    test2[j] = 0.5 * this.vertex[i][j] + 0.5 * this.vertex[lowVert][j];
                }
                evalResult = this.fcn.evalSimplexFcn(test1);
                if (evalResult.getStatus() > 0) {
                    theResult.setStatus(3, eMsg[3], evalResult);
                    return theResult;
                }
                for (j = 0; j < this.nParams + 1; ++j) {
                    this.vertex[i][j] = test2[j];
                }
            }
        }
        for (int i = 0; i < this.nParams + 1; ++i) {
            guess[i] = this.vertex[lowVert][i];
        }
        theResult.setStatus(4, eMsg[4]);
        return theResult;
    }

    public NMResult estError(double[] error, int nData) {
        int j;
        int i;
        int i2;
        int i3;
        int i4;
        String[] eMsg = new String[]{"", "NMSimplexOptimizer.estError: expanding vertex", "NMSimplexOptimizer.estError: expanded maximum times and still have roundoff error", "NMSimplexOptimizer.estError: creating half-way point", "NMSimplexOptimizer.estError: inverting the B matrix", "NMSimplexOptimizer.estError: multiplying Q and B inverse matrices", "NMSimplexOptimizer.estError: multiplying QB(inv) matrix and a vector", "NMSimplexOptimizer.estError: multiplying B(inv) matrix and a vector", "NMSimplexOptimizer.estError: multiplying B(inv) matrix and B(inv)a product vector", "NMSimplexOptimizer.estError: multiplying a row vector and B(inv)B(inv)a product vector", "NMSimplexOptimizer.estError: evaluating objective function at new minimum vertex", "NMSimplexOptimizer.estError: inverting the re-formed B matrix", "NMSimplexOptimizer.estError: transposing the re-formed q matrix", "NMSimplexOptimizer.estError: multiplying B(inv) and q(trans)", "NMSimplexOptimizer.estError: multiplying q and the B(inv)q(trans) product "};
        NMResult theResult = new NMResult();
        double[][] halfWay = new double[this.nParams + 1][this.nParams + 1];
        for (int i5 = 0; i5 < this.nParams + 1; ++i5) {
            halfWay[i5] = new double[this.nParams + 1];
        }
        double[] a = new double[this.nParams];
        double[] minVert = new double[this.nParams + 1];
        double[][] b = new double[this.nParams][this.nParams];
        double[][] bInv = new double[this.nParams][this.nParams];
        double[][] q = new double[this.nParams][this.nParams];
        double[][] eps = new double[this.nParams][this.nParams];
        for (int i6 = 0; i6 < this.nParams; ++i6) {
            b[i6] = new double[this.nParams];
            bInv[i6] = new double[this.nParams];
            q[i6] = new double[this.nParams];
            eps[i6] = new double[this.nParams];
        }
        double[] center = new double[this.nParams];
        for (i4 = 0; i4 < this.nParams; ++i4) {
            center[i4] = 0.0;
        }
        for (int j2 = 0; j2 < this.nParams; ++j2) {
            for (int i7 = 0; i7 < this.nParams + 1; ++i7) {
                int n = j2;
                center[n] = center[n] + this.vertex[i7][j2];
            }
        }
        for (i4 = 0; i4 < this.nParams; ++i4) {
            center[i4] = center[i4] / (double)(this.nParams + 1);
        }
        int lowVert = 0;
        double lowVal = this.vertex[0][this.nParams];
        for (int i8 = 1; i8 < this.nParams + 1; ++i8) {
            if (!(this.vertex[i8][this.nParams] < lowVal)) continue;
            lowVal = this.vertex[i8][this.nParams];
            lowVert = i8;
        }
        DecimalFormat myFormat = new DecimalFormat("0.0000E00");
        String txt = "\ncenter: ";
        for (int i9 = 0; i9 < this.nParams; ++i9) {
            txt = txt + "\n" + myFormat.format(center[i9]);
        }
        txt = txt + "\n\nlowvert: " + Integer.toString(lowVert);
        System.out.println(txt);
        double[] zeroVert = new double[this.nParams + 1];
        for (i3 = 0; i3 < this.nParams + 1; ++i3) {
            zeroVert[i3] = this.vertex[lowVert][i3];
            this.vertex[lowVert][i3] = this.vertex[0][i3];
            this.vertex[0][i3] = zeroVert[i3];
        }
        lowVert = 0;
        for (i3 = 0; i3 < this.nParams + 1; ++i3) {
            if (i3 == lowVert) continue;
            boolean expand = true;
            if ((this.vertex[i3][this.nParams] - zeroVert[this.nParams]) / zeroVert[this.nParams] > this.roundingErrorCutoff) {
                expand = false;
            }
            int expandCount = 0;
            while (expand) {
                ++expandCount;
                double[] test = new double[this.nParams + 1];
                for (int j3 = 0; j3 < this.nParams; ++j3) {
                    test[j3] = center[j3] + 2.0 * (this.vertex[i3][j3] - center[j3]);
                }
                NMResult testResult = this.fcn.evalSimplexFcn(test);
                if (testResult.getStatus() > 0) {
                    theResult.setStatus(1, eMsg[1], testResult);
                    return theResult;
                }
                for (int j4 = 0; j4 < this.nParams + 1; ++j4) {
                    this.vertex[i3][j4] = test[j4];
                }
                if ((this.vertex[i3][this.nParams] - zeroVert[this.nParams]) / zeroVert[this.nParams] > this.roundingErrorCutoff) {
                    expand = false;
                }
                if (expandCount <= this.errorExpandCount) continue;
                theResult.setStatus(2, eMsg[2]);
                return theResult;
            }
        }
        for (int v1 = 0; v1 < this.nParams + 1; ++v1) {
            for (int v2 = 0; v2 < this.nParams + 1; ++v2) {
                if (v2 == v1) continue;
                double[] test = new double[this.nParams + 1];
                for (int j5 = 0; j5 < this.nParams; ++j5) {
                    test[j5] = (this.vertex[v1][j5] + this.vertex[v2][j5]) / 2.0;
                }
                NMResult testResult = this.fcn.evalSimplexFcn(test);
                if (testResult.getStatus() > 0) {
                    theResult.setStatus(3, eMsg[3], testResult);
                    return theResult;
                }
                halfWay[v1][v2] = test[this.nParams];
            }
        }
        DecimalFormat myFormat2 = new DecimalFormat("0.0000E00");
        String txt2 = "\nhalfWay: ";
        for (int i10 = 0; i10 < this.nParams + 1; ++i10) {
            txt2 = txt2 + "\n";
            for (int j6 = 0; j6 < this.nParams + 1; ++j6) {
                txt2 = i10 != j6 ? txt2 + " " + myFormat2.format(halfWay[i10][j6]) : txt2 + " " + myFormat2.format(0.0);
            }
        }
        System.out.println(txt2);
        boolean satisfied = true;
        while (!satisfied) {
            for (int ii = 1; ii < this.nParams + 1; ++ii) {
                int i11 = ii - 1;
                a[i11] = 4.0 * halfWay[0][ii] - this.vertex[ii][this.nParams] - 3.0 * zeroVert[this.nParams];
                b[i11][i11] = 2.0 * (this.vertex[ii][this.nParams] + zeroVert[this.nParams] - 2.0 * halfWay[0][ii]);
                for (int jj = 1; jj < this.nParams + 1; ++jj) {
                    int j7 = jj - 1;
                    b[i11][j7] = 2.0 * (halfWay[ii][jj] + zeroVert[this.nParams] - halfWay[0][ii] - halfWay[0][jj]);
                    q[i11][j7] = this.vertex[ii][jj] - zeroVert[j7];
                }
            }
            NMMatrixOperator theOperator = new NMMatrixOperator();
            NMResult matrixResult = theOperator.invert(b, bInv);
            if (matrixResult.getStatus() > 0) {
                theResult.setStatus(4, eMsg[4], matrixResult);
                return theResult;
            }
            matrixResult = theOperator.mult(q, bInv, b);
            if (matrixResult.getStatus() > 0) {
                theResult.setStatus(5, eMsg[5], matrixResult);
                return theResult;
            }
            double[] productVect = new double[this.nParams];
            matrixResult = theOperator.mult(b, a, productVect);
            if (matrixResult.getStatus() > 0) {
                theResult.setStatus(6, eMsg[6], matrixResult);
                return theResult;
            }
            for (int i12 = 0; i12 < this.nParams; ++i12) {
                minVert[i12] = zeroVert[i12] - productVect[i12];
            }
            matrixResult = this.fcn.evalSimplexFcn(minVert);
            if (matrixResult.getStatus() > 0) {
                theResult.setStatus(3, eMsg[3], matrixResult);
                return theResult;
            }
            double[] tvect = new double[this.nParams];
            double[] tvect2 = new double[this.nParams];
            matrixResult = theOperator.mult(bInv, a, tvect);
            if (matrixResult.getStatus() > 0) {
                theResult.setStatus(7, eMsg[7], matrixResult);
                return theResult;
            }
            matrixResult = theOperator.mult(bInv, tvect, tvect2);
            if (matrixResult.getStatus() > 0) {
                theResult.setStatus(8, eMsg[8], matrixResult);
                return theResult;
            }
            matrixResult = theOperator.mult(a, tvect2);
            if (matrixResult.getStatus() > 0) {
                theResult.setStatus(9, eMsg[9], matrixResult);
                return theResult;
            }
            if (matrixResult.getDoubleValue() < 0.25) {
                satisfied = true;
            }
            for (int i13 = 0; i13 < this.nParams + 1; ++i13) {
                zeroVert[i13] = minVert[i13];
            }
            matrixResult = this.fcn.evalSimplexFcn(zeroVert);
            if (matrixResult.getStatus() <= 0) continue;
            theResult.setStatus(10, eMsg[10], matrixResult);
            return theResult;
        }
        for (int ii = 1; ii < this.nParams + 1; ++ii) {
            int i14 = ii - 1;
            b[i14][i14] = 2.0 * (this.vertex[ii][this.nParams] + zeroVert[this.nParams] - 2.0 * halfWay[0][ii]);
            for (int jj = 1; jj < this.nParams + 1; ++jj) {
                int j8 = jj - 1;
                b[i14][j8] = 2.0 * (halfWay[ii][jj] + zeroVert[this.nParams] - halfWay[0][ii] - halfWay[0][jj]);
                q[i14][j8] = this.vertex[ii][jj] - zeroVert[j8];
            }
        }
        DecimalFormat myFormat3 = new DecimalFormat("0.0000E00");
        String txt3 = "\nB: ";
        for (i2 = 0; i2 < this.nParams; ++i2) {
            txt3 = txt3 + "\n";
            for (int j9 = 0; j9 < this.nParams; ++j9) {
                txt3 = txt3 + " " + myFormat3.format(b[i2][j9]);
            }
        }
        System.out.println(txt3);
        myFormat3 = new DecimalFormat("0.0000E00");
        txt3 = "\nQ: ";
        for (i2 = 0; i2 < this.nParams; ++i2) {
            txt3 = txt3 + "\n";
            for (int j10 = 0; j10 < this.nParams; ++j10) {
                txt3 = txt3 + " " + myFormat3.format(q[i2][j10]);
            }
        }
        System.out.println(txt3);
        NMMatrixOperator theOperator = new NMMatrixOperator();
        NMResult matrixResult = theOperator.invert(b, bInv);
        if (matrixResult.getStatus() > 0) {
            theResult.setStatus(11, eMsg[11], matrixResult);
            return theResult;
        }
        DecimalFormat myFormat4 = new DecimalFormat("0.0000E00");
        String txt4 = "\nB(inv): ";
        for (i = 0; i < this.nParams; ++i) {
            txt4 = txt4 + "\n";
            for (j = 0; j < this.nParams; ++j) {
                txt4 = txt4 + " " + myFormat4.format(bInv[i][j]);
            }
        }
        System.out.println(txt4);
        matrixResult = theOperator.transpose(q, b);
        if (matrixResult.getStatus() > 0) {
            theResult.setStatus(12, eMsg[12], matrixResult);
            return theResult;
        }
        myFormat4 = new DecimalFormat("0.0000E00");
        txt4 = "\nQ(t): ";
        for (i = 0; i < this.nParams; ++i) {
            txt4 = txt4 + "\n";
            for (j = 0; j < this.nParams; ++j) {
                txt4 = txt4 + " " + myFormat4.format(b[i][j]);
            }
        }
        System.out.println(txt4);
        matrixResult = theOperator.mult(bInv, b, eps);
        if (matrixResult.getStatus() > 0) {
            theResult.setStatus(13, eMsg[13], matrixResult);
            return theResult;
        }
        myFormat4 = new DecimalFormat("0.0000E00");
        txt4 = "\nB(inv)Q(t): ";
        for (i = 0; i < this.nParams; ++i) {
            txt4 = txt4 + "\n";
            for (j = 0; j < this.nParams; ++j) {
                txt4 = txt4 + " " + myFormat4.format(eps[i][j]);
            }
        }
        System.out.println(txt4);
        matrixResult = theOperator.mult(q, eps, bInv);
        if (matrixResult.getStatus() > 0) {
            theResult.setStatus(14, eMsg[14], matrixResult);
            return theResult;
        }
        myFormat4 = new DecimalFormat("0.0000E00");
        txt4 = "\nQB(inv)Q(t): ";
        for (i = 0; i < this.nParams; ++i) {
            txt4 = txt4 + "\n";
            for (j = 0; j < this.nParams; ++j) {
                txt4 = txt4 + " " + myFormat4.format(bInv[i][j]);
            }
        }
        System.out.println(txt4);
        for (int i15 = 0; i15 < this.nParams; ++i15) {
            error[i15] = bInv[i15][i15] * 2.0 * zeroVert[this.nParams] / (double)(nData - this.nParams);
            error[i15] = Math.abs(error[i15]);
            error[i15] = Math.sqrt(error[i15]);
        }
        return theResult;
    }

    public NMResult addVertex(int iParam, double[] fromVertex, double[] newVertex, double fraction) {
        String[] eMsg = new String[]{"", "NMSimplexOptimizer.addVertex: supplied vertex length not correct", "NMSimplexOptimizer.addVertex: new vertex length not correct", "NMSimplexOptimizer.addVertex: unable to apply constraints", "NMSimplexOptimizer.addVertex: failed to find appropriate perturbation"};
        NMResult theResult = new NMResult();
        if (fromVertex.length != this.nParams + 1) {
            theResult.setStatus(1, eMsg[1]);
            return theResult;
        }
        if (newVertex.length != this.nParams + 1) {
            theResult.setStatus(2, eMsg[2]);
            return theResult;
        }
        for (int i = 0; i < this.nParams; ++i) {
            newVertex[i] = fromVertex[i];
            this.vertex[iParam][i] = fromVertex[i];
        }
        double perturbation = newVertex[iParam] == 0.0 ? fraction : fraction * newVertex[iParam];
        boolean isGoodVertex = false;
        int pertCount = 0;
        while (!isGoodVertex) {
            NMResult consResult;
            NMResult consResult2;
            int n = iParam;
            newVertex[n] = newVertex[n] + perturbation;
            if (this.hasBounds && (consResult2 = this.constrain(fromVertex, newVertex)).getStatus() != 0) {
                theResult.setStatus(3, eMsg[3], consResult2);
                return theResult;
            }
            NMResult fcnResult = this.fcn.evalSimplexFcn(newVertex);
            if (fcnResult.getStatus() == 0) {
                isGoodVertex = true;
                continue;
            }
            int n2 = iParam;
            newVertex[n2] = newVertex[n2] - 2.0 * perturbation;
            if (this.hasBounds && (consResult = this.constrain(fromVertex, newVertex)).getStatus() != 0) {
                theResult.setStatus(3, eMsg[3], consResult);
                return theResult;
            }
            fcnResult = this.fcn.evalSimplexFcn(newVertex);
            if (fcnResult.getStatus() == 0) {
                isGoodVertex = true;
                continue;
            }
            int n3 = iParam;
            newVertex[n3] = newVertex[n3] + perturbation;
            perturbation *= 0.1;
            if (pertCount++ < 10) continue;
            theResult.setStatus(4, eMsg[4]);
            return theResult;
        }
        for (int j = 0; j < this.nParams + 1; ++j) {
            this.vertex[iParam][j] = newVertex[j];
        }
        return theResult;
    }

    public NMResult constrain(double[] oldParam, double[] newParam) {
        NMResult theResult = new NMResult();
        for (int i = 0; i < this.nParams; ++i) {
            if (this.hasUpperBound[i] && newParam[i] > this.upperBound[i]) {
                newParam[i] = oldParam == null ? this.upperBound[i] : oldParam[i] + 0.9 * (this.upperBound[i] - oldParam[i]);
            }
            if (!this.hasLowerBound[i] || !(newParam[i] < this.lowerBound[i])) continue;
            newParam[i] = oldParam == null ? this.lowerBound[i] : oldParam[i] - 0.9 * (this.lowerBound[i] - oldParam[i]);
        }
        return theResult;
    }

    public NMResult checkVertices() {
        String[] eMsg = new String[]{"", "NMSimplexOptimizer.checkVertices: vertex value is zero or missing"};
        NMResult theResult = new NMResult();
        for (int i = 0; i < this.nParams + 1; ++i) {
            if (this.vertex[i][this.nParams] != 0.0) continue;
            theResult.setStatus(1, eMsg[1]);
            return theResult;
        }
        return theResult;
    }

    public void registerListener(NMSimplexListener listener) {
        this.theListener = listener;
    }

    public void unregisterListener() {
        this.theListener = this;
    }

    public void call(int iteration, double sumOfSquares) {
    }

    public void setTol(double tol) {
        this.tol = tol;
    }

    public void clearBounds() {
        if (this.hasBounds) {
            this.hasBounds = false;
            this.hasUpperBound = new boolean[this.nParams];
            this.hasLowerBound = new boolean[this.nParams];
            this.upperBound = new double[this.nParams];
            this.lowerBound = new double[this.nParams];
            for (int i = 0; i < this.nParams; ++i) {
                this.hasUpperBound[i] = false;
                this.hasLowerBound[i] = false;
            }
        }
    }

    public void setBounds(boolean[] hasUpperBound, boolean[] hasLowerBound, double[] upperBound, double[] lowerBound) {
        this.hasBounds = true;
        for (int i = 0; i < this.nParams; ++i) {
            if (hasUpperBound[i]) {
                this.hasUpperBound[i] = hasUpperBound[i];
                this.upperBound[i] = upperBound[i];
            }
            if (!hasLowerBound[i]) continue;
            this.hasLowerBound[i] = hasLowerBound[i];
            this.lowerBound[i] = lowerBound[i];
        }
    }

    public NMSimplexOptimizer(int n, NMSimplexFcn nmfcn) {
        this.setTol(1.0E-4);
        this.theListener = this;
        this.errorExpandCount = 20;
        this.roundingErrorCutoff = 1.0E-8;
        this.nParams = n;
        this.fcn = nmfcn;
        this.hasUpperBound = new boolean[this.nParams];
        this.hasLowerBound = new boolean[this.nParams];
        this.upperBound = new double[this.nParams];
        this.lowerBound = new double[this.nParams];
        this.vertex = new double[this.nParams + 1][this.nParams + 1];
        for (int i = 0; i < this.nParams; ++i) {
            this.vertex[i][this.nParams] = 0.0;
            this.hasUpperBound[i] = false;
            this.hasLowerBound[i] = false;
        }
    }

    public void setErrorExpandCount(int errorExpandCount) {
        this.errorExpandCount = errorExpandCount;
    }

    public void setRoundingErrorCutoff(double roundingErrorCutoff) {
        this.roundingErrorCutoff = roundingErrorCutoff;
    }
}

