/*
 * Decompiled with CFR 0.152.
 */
package numeth;

import numeth.NMMatrixOperator;
import numeth.NMNewtRaphEqns;
import numeth.NMResult;

public class NMNewtRaphSolver {
    private NMNewtRaphEqns nlaes;
    private int maxIterations;
    private boolean treatAsFractions;
    private boolean treatAsNonNegative;
    private double minSigValue;
    private double tol;

    public NMResult solve(double[] x, double[] y) {
        String[] eMsg = new String[]{"", "NMNewtRaphSolver.solve: number of equations not equal to the number of unknowns", "NMNewtRaphSolver.solve: error getting Jacobian", "NMNewtRaphSolver.solve: error evaluating the equations", "NMNewtRaphSolver.solve: error solving linearized equations", "NMNewtRaphSolver.solve: solution is diverging", "NMNewtRaphSolver:solve: failed to converge"};
        NMResult theResult = new NMResult();
        int n = x.length;
        if (n != y.length) {
            theResult.setStatus(1, eMsg[1]);
            return theResult;
        }
        int nIterations = 0;
        boolean convergenceFlag = false;
        double sum = 1.0E99;
        double[] x0 = new double[n];
        for (int i = 0; i < n; ++i) {
            x0[i] = x[i];
        }
        double[][] jac = new double[n][n];
        while (nIterations < this.maxIterations) {
            int j;
            int j2;
            boolean renormalize = false;
            NMResult jacResult = this.nlaes.evalNewtRaphJac(x0, jac);
            if (jacResult.getStatus() > 0) {
                theResult.setStatus(2, eMsg[2], jacResult);
                return theResult;
            }
            NMResult evalResult = this.nlaes.evalNewtRaphEqns(x0, y);
            if (evalResult.getStatus() > 0) {
                theResult.setStatus(3, eMsg[3], evalResult);
                return theResult;
            }
            for (int j3 = 0; j3 < n; ++j3) {
                y[j3] = -y[j3];
            }
            NMMatrixOperator solver = new NMMatrixOperator();
            NMResult linResult = solver.gaussElim(jac, x, y);
            if (linResult.getStatus() > 0) {
                theResult.setStatus(4, eMsg[4], linResult);
                return theResult;
            }
            for (j2 = 0; j2 < n; ++j2) {
                int n2 = j2;
                x[n2] = x[n2] + x0[j2];
            }
            if (this.treatAsFractions) {
                renormalize = false;
                for (j2 = 0; j2 < n; ++j2) {
                    if (x[j2] < 0.0) {
                        x[j2] = 0.1 * x0[j2];
                        renormalize = true;
                        continue;
                    }
                    if (!(x[j2] > 1.0)) continue;
                    x[j2] = x0[j2] + 0.9 * (1.0 - x0[j2]);
                    renormalize = true;
                }
                if (renormalize) {
                    double total = 0.0;
                    for (j = 0; j < n; ++j) {
                        total += x[j];
                    }
                    for (j = 0; j < n; ++j) {
                        x[j] = x[j] / total;
                    }
                }
            }
            if (this.treatAsNonNegative) {
                for (int i = 0; i < n; ++i) {
                    if (!(x[i] < 0.0)) continue;
                    x[i] = 0.01 * this.minSigValue;
                    renormalize = true;
                }
            }
            if (++nIterations == 1) {
                sum = 1.0E99;
                for (j2 = 0; j2 < n; ++j2) {
                    x0[j2] = x[j2];
                }
                continue;
            }
            convergenceFlag = false;
            if (renormalize) {
                convergenceFlag = true;
            } else {
                double newSum = 0.0;
                for (j = 0; j < n; ++j) {
                    double rel = Math.abs(x[j]) > this.minSigValue ? Math.abs(1.0 - x0[j] / x[j]) : 0.0;
                    if (rel > this.tol) {
                        convergenceFlag = true;
                    }
                    newSum += rel * rel;
                }
                if (!convergenceFlag) {
                    return theResult;
                }
                if (newSum > 100.0 * sum && nIterations > 25) {
                    theResult.setStatus(5, eMsg[5]);
                    return theResult;
                }
                sum = newSum;
            }
            for (j2 = 0; j2 < n; ++j2) {
                x0[j2] = x[j2];
            }
        }
        theResult.setStatus(6, eMsg[6]);
        return theResult;
    }

    public NMResult solveWithinBounds(double[] x, double[] y, double[] xMin, double[] xMax) {
        String[] eMsg = new String[]{"", "NMNewtRaphSolver.solve: number of equations not equal to the number of unknowns", "NMNewtRaphSolver.solve: error getting Jacobian", "NMNewtRaphSolver.solve: error evaluating the equations", "NMNewtRaphSolver.solve: error solving linearized equations", "NMNewtRaphSolver.solve: solution is diverging", "NMNewtRaphSolver:solve: failed to converge"};
        NMResult theResult = new NMResult();
        int n = x.length;
        if (n != y.length) {
            theResult.setStatus(1, eMsg[1]);
            return theResult;
        }
        int nIterations = 0;
        boolean convergenceFlag = false;
        double sum = 1.0E99;
        double[] x0 = new double[n];
        for (int i = 0; i < n; ++i) {
            x0[i] = x[i];
        }
        double[][] jac = new double[n][n];
        while (nIterations < this.maxIterations) {
            int j;
            boolean doAnother = false;
            NMResult jacResult = this.nlaes.evalNewtRaphJac(x0, jac);
            if (jacResult.getStatus() > 0) {
                theResult.setStatus(2, eMsg[2], jacResult);
                return theResult;
            }
            NMResult evalResult = this.nlaes.evalNewtRaphEqns(x0, y);
            if (evalResult.getStatus() > 0) {
                theResult.setStatus(3, eMsg[3], evalResult);
                return theResult;
            }
            for (int j2 = 0; j2 < n; ++j2) {
                y[j2] = -y[j2];
            }
            NMMatrixOperator solver = new NMMatrixOperator();
            NMResult linResult = solver.gaussElim(jac, x, y);
            if (linResult.getStatus() > 0) {
                theResult.setStatus(4, eMsg[4], linResult);
                return theResult;
            }
            for (j = 0; j < n; ++j) {
                int n2 = j;
                x[n2] = x[n2] + x0[j];
            }
            for (j = 0; j < n; ++j) {
                if (x[j] < xMin[j]) {
                    x[j] = x0[j] - 0.9 * (x0[j] - xMin[j]);
                    doAnother = true;
                    continue;
                }
                if (!(x[j] > xMax[j])) continue;
                x[j] = x0[j] + 0.9 * (xMax[j] - x0[j]);
                doAnother = true;
            }
            if (++nIterations == 1) {
                sum = 1.0E99;
                for (j = 0; j < n; ++j) {
                    x0[j] = x[j];
                }
                continue;
            }
            convergenceFlag = false;
            if (doAnother) {
                convergenceFlag = true;
            } else {
                double newSum = 0.0;
                for (int j3 = 0; j3 < n; ++j3) {
                    double rel = Math.abs(x[j3]) > this.minSigValue ? Math.abs(1.0 - x0[j3] / x[j3]) : 0.0;
                    if (rel > this.tol) {
                        convergenceFlag = true;
                    }
                    newSum += rel * rel;
                }
                if (!convergenceFlag) {
                    return theResult;
                }
                if (newSum > 100.0 * sum && nIterations > 25) {
                    theResult.setStatus(5, eMsg[5]);
                    return theResult;
                }
                sum = newSum;
            }
            for (j = 0; j < n; ++j) {
                x0[j] = x[j];
            }
        }
        theResult.setStatus(6, eMsg[6]);
        return theResult;
    }

    public NMNewtRaphSolver(NMNewtRaphEqns theEqns) {
        this.nlaes = theEqns;
        this.maxIterations = 500;
        this.treatAsFractions = false;
        this.treatAsNonNegative = false;
        this.minSigValue = 1.0E-15;
        this.tol = 1.0E-4;
    }

    public void setTreatAsFractions(boolean treatAsFractions) {
        this.treatAsFractions = treatAsFractions;
    }

    public void setTreatAsNonNegative(boolean treatAsNonNegative) {
        this.treatAsNonNegative = treatAsNonNegative;
    }

    public double getMinSigValue() {
        return this.minSigValue;
    }

    public void setMinSigValue(double minSigValue) {
        this.minSigValue = minSigValue;
    }

    public double getTol() {
        return this.tol;
    }

    public void setTol(double tol) {
        this.tol = tol;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }
}

